/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.terminal;

import java.io.IOException;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.terminal.Terminal;
import org.primefaces.renderkit.CoreRenderer;

public class TerminalRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Terminal terminal = (Terminal)component;
        if (context.getExternalContext().getRequestParameterMap().containsKey(terminal.getClientId(context))) {
            this.handleCommand(context, component);
        } else {
            this.encodeMarkup(context, terminal);
            this.encodeScript(context, terminal);
        }
    }

    protected void encodeMarkup(FacesContext context, Terminal terminal) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = terminal.getClientId(context);
        writer.startElement("div", (UIComponent)terminal);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Terminal terminal) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = terminal.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Terminal','" + terminal.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",PS1:'" + terminal.getPrompt() + "'");
        if (terminal.getWelcomeMessage() != null) {
            writer.write(",WELCOME_MESSAGE:'" + terminal.getWelcomeMessage() + "'");
        }
        if (terminal.getWidth() != null) {
            writer.write(",WIDTH:'" + terminal.getWidth() + "'");
        }
        if (terminal.getHeight() != null) {
            writer.write(",HEIGHT:'" + terminal.getHeight() + "'");
        }
        writer.write("},'terminal');});");
        this.endScript(writer);
    }

    protected void handleCommand(FacesContext context, UIComponent component) throws IOException {
        String[] args;
        ResponseWriter writer = context.getResponseWriter();
        Terminal terminal = (Terminal)component;
        String clientId = terminal.getClientId(context);
        String argsParam = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_args");
        String[] tokens = argsParam.split(",");
        String command = tokens[0];
        if (tokens.length > 1) {
            args = new String[tokens.length - 1];
            for (int t = 1; t < tokens.length; ++t) {
                args[t - 1] = tokens[t];
            }
        } else {
            args = new String[]{};
        }
        MethodExpression commandHandler = terminal.getCommandHandler();
        String result = (String)commandHandler.invoke(context.getELContext(), new Object[]{command, args});
        writer.write(result);
    }
}

