/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.spinner;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.spinner.Spinner;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class SpinnerRenderer
extends InputRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(FacesContext context, UIComponent component) {
        Spinner spinner = (Spinner)component;
        if (spinner.isDisabled() || spinner.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)spinner);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(spinner.getClientId(context) + "_input");
        String prefix = spinner.getPrefix();
        String suffix = spinner.getSuffix();
        try {
            if (prefix != null) {
                submittedValue = submittedValue.substring(prefix.length());
            } else if (suffix != null) {
                submittedValue = submittedValue.substring(0, submittedValue.length() - suffix.length());
            }
        }
        catch (Exception e) {
        }
        finally {
            spinner.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Spinner spinner = (Spinner)component;
        this.encodeMarkup(context, spinner);
        this.encodeScript(context, spinner);
    }

    protected void encodeScript(FacesContext context, Spinner spinner) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('Spinner','" + spinner.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",step:" + spinner.getStepFactor());
        if (spinner.getMin() != Double.MIN_VALUE) {
            writer.write(",min:" + spinner.getMin());
        }
        if (spinner.getMax() != Double.MAX_VALUE) {
            writer.write(",max:" + spinner.getMax());
        }
        if (spinner.getPrefix() != null) {
            writer.write(",prefix:'" + spinner.getPrefix() + "'");
        }
        if (spinner.getSuffix() != null) {
            writer.write(",suffix:'" + spinner.getSuffix() + "'");
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)spinner);
        writer.write("});});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, Spinner spinner) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        String styleClass = spinner.getStyleClass();
        styleClass = styleClass == null ? "ui-spinner ui-widget ui-corner-all" : "ui-spinner ui-widget ui-corner-all " + styleClass;
        styleClass = spinner.isDisabled() ? styleClass + " ui-state-disabled" : styleClass;
        styleClass = !spinner.isValid() ? styleClass + " ui-state-error" : styleClass;
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (spinner.getStyle() != null) {
            writer.writeAttribute("style", (Object)spinner.getStyle(), null);
        }
        this.encodeInput(context, spinner);
        this.encodeButton(context, "ui-spinner-button ui-spinner-up ui-corner-tr ui-button ui-widget ui-state-default ui-button-text-only", "ui-icon ui-icon-triangle-1-n");
        this.encodeButton(context, "ui-spinner-button ui-spinner-down ui-corner-br ui-button ui-widget ui-state-default ui-button-text-only", "ui-icon ui-icon-triangle-1-s");
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, Spinner spinner) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = spinner.getClientId(context) + "_input";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("class", (Object)"ui-spinner-input ui-inputfield ui-state-default ui-corner-all", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)spinner);
        valueToRender = spinner.getPrefix() != null ? spinner.getPrefix() + valueToRender : valueToRender;
        String string = valueToRender = spinner.getSuffix() != null ? valueToRender + spinner.getSuffix() : valueToRender;
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)spinner, HTML.INPUT_TEXT_ATTRS);
        if (spinner.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (spinner.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
        writer.endElement("input");
    }

    protected void encodeButton(FacesContext context, String styleClass, String iconClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("span");
        writer.endElement("a");
    }
}

