/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.slider;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.slider.Slider;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class SliderRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Slider slider = (Slider)component;
        this.encodeMarkup(facesContext, slider);
        this.encodeScript(facesContext, slider);
    }

    protected void encodeMarkup(FacesContext context, Slider slider) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = slider.getClientId(context);
        writer.startElement("div", (UIComponent)slider);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (slider.getStyle() != null) {
            writer.writeAttribute("style", (Object)slider.getStyle(), null);
        }
        if (slider.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)slider.getStyleClass(), null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Slider slider) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = slider.getClientId(context);
        UIComponent input = this.getTarget(context, slider, slider.getFor());
        UIComponent output = this.getTarget(context, slider, slider.getDisplay());
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Slider','" + slider.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",value:" + ComponentUtils.getValueToRender(context, input));
        writer.write(",input:'" + input.getClientId(context) + "'");
        writer.write(",min:" + slider.getMinValue());
        writer.write(",max:" + slider.getMaxValue());
        writer.write(",animate:" + slider.isAnimate());
        writer.write(",step:" + slider.getStep());
        writer.write(",orientation:'" + slider.getType() + "'");
        if (slider.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (output != null) {
            writer.write(",output:'" + output.getClientId(context) + "'");
        }
        if (slider.getOnSlideStart() != null) {
            writer.write(",onSlideStart:function(event, ui) {" + slider.getOnSlideStart() + "}");
        }
        if (slider.getOnSlide() != null) {
            writer.write(",onSlide:function(event, ui) {" + slider.getOnSlide() + "}");
        }
        if (slider.getOnSlideEnd() != null) {
            writer.write(",onSlideEnd:function(event, ui) {" + slider.getOnSlideEnd() + "}");
        }
        this.encodeClientBehaviors(context, slider);
        writer.write("});");
        this.endScript(writer);
    }

    protected UIComponent getTarget(FacesContext context, Slider slider, String target) {
        if (target == null) {
            return null;
        }
        UIComponent targetComponent = slider.findComponent(target);
        if (targetComponent == null) {
            throw new FacesException("Cannot find slider target component '" + target + "' in view");
        }
        return targetComponent;
    }
}

