/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectcheckboxmenu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectMany;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.selectcheckboxmenu.SelectCheckboxMenu;
import org.primefaces.renderkit.SelectManyRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectCheckboxMenuRenderer
extends SelectManyRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectMany", "javax.faces.Checkbox").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectCheckboxMenu menu = (SelectCheckboxMenu)component;
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected void encodeMarkup(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        boolean valid = menu.isValid();
        String style = menu.getStyle();
        String styleclass = menu.getStyleClass();
        styleclass = styleclass == null ? "ui-selectcheckboxmenu ui-widget ui-state-default ui-corner-all ui-helper-clearfix" : "ui-selectcheckboxmenu ui-widget ui-state-default ui-corner-all ui-helper-clearfix " + styleclass;
        styleclass = menu.isDisabled() ? styleclass + " ui-state-disabled" : styleclass;
        styleclass = !valid ? styleclass + " ui-state-error" : styleclass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleclass, "styleclass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInputs(context, menu, selectItems);
        this.encodeLabel(context, menu, selectItems, valid);
        this.encodeMenuIcon(context, menu, valid);
        writer.endElement("div");
    }

    protected void encodeInputs(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        int idx = -1;
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, menu, values, submittedValues, converter, selectItem, ++idx);
        }
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, SelectCheckboxMenu menu, Object values, Object submittedValues, Converter converter, SelectItem option, int idx) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        String name = menu.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean bl = disabled = option.isDisabled() || menu.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean checked = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !checked) {
            return;
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (menu.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)menu.getOnchange(), null);
        }
        writer.endElement("input");
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)id, null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
    }

    protected void encodeLabel(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems, boolean valid) throws IOException {
        String labelClass;
        ResponseWriter writer = context.getResponseWriter();
        String label = menu.getLabel();
        String string = labelClass = !valid ? "ui-selectcheckboxmenu-label ui-corner-all ui-state-error" : "ui-selectcheckboxmenu-label ui-corner-all";
        if (label == null) {
            label = "&nbsp;";
        }
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-label-container", null);
        if (menu.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)menu.getTabindex(), null);
        }
        writer.startElement("label", null);
        writer.writeAttribute("class", (Object)labelClass, null);
        writer.write(label);
        writer.endElement("label");
        writer.endElement("a");
    }

    protected void encodeMenuIcon(FacesContext context, SelectCheckboxMenu menu, boolean valid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconClass = valid ? "ui-selectcheckboxmenu-trigger ui-state-default ui-corner-right" : "ui-selectcheckboxmenu-trigger ui-state-default ui-corner-right ui-state-error";
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('SelectCheckboxMenu','" + menu.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (menu.getOnShow() != null) {
            writer.write(",onShow:function(){" + menu.getOnShow() + "}");
        }
        if (menu.getOnHide() != null) {
            writer.write(",onHide:function(){" + menu.getOnHide() + "}");
        }
        if (menu.getScrollHeight() != Integer.MAX_VALUE) {
            writer.write(",scrollHeight:" + menu.getScrollHeight());
        }
        if (menu.isFilter()) {
            writer.write(",filter:true");
            if (menu.getFilterMatchMode() != null) {
                writer.write(",filterMatchMode:'" + menu.getFilterMatchMode() + "'");
            }
            if (menu.getFilterFunction() != null) {
                writer.write(",filterFunction:" + menu.getFilterFunction());
            }
            if (menu.isCaseSensitive()) {
                writer.write(",caseSensitive:true");
            }
        }
        if (menu.getPanelStyle() != null) {
            writer.write(",panelStyle:'" + menu.getPanelStyle() + "'");
        }
        if (menu.getPanelStyleClass() != null) {
            writer.write(",panelStyleClass:'" + menu.getPanelStyleClass() + "'");
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)menu);
        writer.write("});});");
        this.endScript(writer);
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }
}

