/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panelmenu;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.panelmenu.PanelMenu;
import org.primefaces.component.submenu.Submenu;

public class PanelMenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        PanelMenu menu = (PanelMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        String widgetVar = menu.resolveWidgetVar();
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('PanelMenu','" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        PanelMenu menu = (PanelMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-panelmenu ui-widget" : "ui-panelmenu ui-widget " + styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("role", (Object)"menu", null);
        for (UIComponent child : menu.getChildren()) {
            if (!child.isRendered() || !(child instanceof Submenu)) continue;
            this.encodeRootSubmenu(context, menu, (Submenu)child);
        }
        writer.endElement("div");
    }

    protected void encodeRootSubmenu(FacesContext context, PanelMenu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("h3", null);
        writer.writeAttribute("class", (Object)"ui-panelmenu-header ui-state-default ui-corner-all", null);
        writer.writeAttribute("role", (Object)"tab", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-e", null);
        writer.endElement("span");
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        writer.writeText((Object)submenu.getLabel(), null);
        writer.endElement("a");
        writer.endElement("h3");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)submenu.getClientId(context), null);
        writer.writeAttribute("class", (Object)"ui-panelmenu-content ui-widget-content ui-helper-hidden", null);
        writer.writeAttribute("role", (Object)"tabpanel", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        for (UIComponent child : submenu.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Submenu)) continue;
            this.encodeDescendantSubmenu(context, (Submenu)child);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeDescendantSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-widget ui-menuitem ui-corner-all ui-menu-parent", null);
        writer.writeAttribute("role", (Object)"menuitem", null);
        writer.startElement("a", null);
        writer.writeAttribute("id", (Object)submenu.getClientId(context), null);
        writer.writeAttribute("class", (Object)"ui-menuitem-link ui-corner-all", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-panelmenu-icon ui-icon ui-icon-triangle-1-e", null);
        writer.endElement("span");
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-icon " + icon), null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
        writer.writeText((Object)submenu.getLabel(), null);
        writer.endElement("span");
        writer.endElement("a");
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        for (UIComponent child : submenu.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Submenu)) continue;
            this.encodeDescendantSubmenu(context, (Submenu)child);
        }
        writer.endElement("ul");
        writer.endElement("li");
    }
}

