/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.overlaypanel;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.overlaypanel.OverlayPanel;
import org.primefaces.renderkit.CoreRenderer;

public class OverlayPanelRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OverlayPanel panel = (OverlayPanel)component;
        if (panel.isContentLoadRequest(context)) {
            this.renderChildren(context, (UIComponent)panel);
        } else {
            this.encodeMarkup(context, panel);
            this.encodeScript(context, panel);
        }
    }

    protected void encodeMarkup(FacesContext context, OverlayPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        String style = panel.getStyle();
        String styleClass = panel.getStyleClass();
        styleClass = styleClass == null ? "ui-overlaypanel ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow" : "ui-overlaypanel ui-widget ui-widget-content ui-overlay-hidden ui-corner-all ui-shadow " + styleClass;
        writer.startElement("div", (UIComponent)panel);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (!panel.isDynamic()) {
            this.renderChildren(context, (UIComponent)panel);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, OverlayPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent target = panel.findComponent(panel.getFor());
        if (target == null) {
            throw new FacesException("Cannot find component '" + panel.getFor() + "' in view.");
        }
        String clientId = panel.getClientId(context);
        String targetClientId = target.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('OverlayPanel','" + panel.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",target:'" + targetClientId + "'");
        if (panel.getShowEvent() != null) {
            writer.write(",showEvent:'" + panel.getShowEvent() + "'");
        }
        if (panel.getHideEvent() != null) {
            writer.write(",hideEvent:'" + panel.getHideEvent() + "'");
        }
        if (panel.getShowEffect() != null) {
            writer.write(",showEffect:'" + panel.getShowEffect() + "'");
        }
        if (panel.getHideEffect() != null) {
            writer.write(",hideEffect:'" + panel.getHideEffect() + "'");
        }
        if (panel.getOnShow() != null) {
            writer.write(",onShow:function(){" + panel.getOnShow() + "}");
        }
        if (panel.getOnHide() != null) {
            writer.write(",onHide:function(){" + panel.getOnHide() + "}");
        }
        if (panel.getMy() != null) {
            writer.write(",my:'" + panel.getMy() + "'");
        }
        if (panel.getAt() != null) {
            writer.write(",at:'" + panel.getAt() + "'");
        }
        if (panel.isAppendToBody()) {
            writer.write(",appendToBody:true");
        }
        if (panel.isDynamic()) {
            writer.write(",dynamic:true");
        }
        writer.write("});});");
        this.endScript(writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

