/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.outputlabel;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.outputlabel.OutputLabel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

public class OutputLabelRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        OutputLabel label = (OutputLabel)component;
        String clientId = label.getClientId();
        Object value = label.getValue();
        UIInput target = this.findTarget(context, label);
        String _for = target instanceof InputHolder ? ((InputHolder)target).getInputClientId() : target.getClientId(context);
        String defaultStyleClass = target.isValid() ? "ui-outputlabel" : "ui-outputlabel ui-state-error";
        String styleClass = label.getStyleClass();
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        writer.startElement("label", (UIComponent)label);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        writer.writeAttribute("for", (Object)_for, "for");
        this.renderPassThruAttributes(context, (UIComponent)label, HTML.LABEL_ATTRS);
        if (value != null) {
            String text = value.toString();
            if (label.isEscape()) {
                writer.writeText((Object)text, "value");
            } else {
                writer.write(text);
            }
            target.getAttributes().put("label", value);
        }
        if (target.isRequired()) {
            writer.startElement("span", (UIComponent)label);
            writer.writeAttribute("class", (Object)"ui-outputlabel-rfi", null);
            writer.write("*");
            writer.endElement("span");
        }
        writer.endElement("label");
    }

    protected UIInput findTarget(FacesContext context, OutputLabel label) {
        UIComponent _forComponent = null;
        String _for = label.getFor();
        if (_for != null && (_forComponent = label.findComponent(_for)) == null) {
            throw new FacesException("Cannot find component with identifier \"" + _for + "\" referenced from \"" + label.getClientId(context) + "\".");
        }
        return (UIInput)_forComponent;
    }
}

