/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.orderlist;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.column.Column;
import org.primefaces.component.orderlist.OrderList;
import org.primefaces.renderkit.CoreRenderer;

public class OrderListRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        OrderList pickList = (OrderList)component;
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String values = pickList.getClientId(context) + "_values";
        if (values != null) {
            pickList.setSubmittedValue(params.get(values));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OrderList ol = (OrderList)component;
        this.encodeMarkup(context, ol);
        this.encodeScript(context, ol);
    }

    protected void encodeMarkup(FacesContext context, OrderList ol) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ol.getClientId(context);
        String controlsLocation = ol.getControlsLocation();
        String style = ol.getStyle();
        String styleClass = ol.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-orderlist ui-widget" : "ui-orderlist ui-widget " + styleClass;
        if (ol.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.startElement("table", (UIComponent)ol);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        if (controlsLocation.equals("left")) {
            this.encodeControls(context, ol);
        }
        this.encodeList(context, ol);
        if (controlsLocation.equals("right")) {
            this.encodeControls(context, ol);
        }
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeList(FacesContext context, OrderList ol) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ol.getClientId(context);
        UIComponent caption = ol.getFacet("caption");
        String listStyleClass = "ui-widget-content ui-orderlist-list";
        writer.startElement("td", null);
        if (caption != null) {
            this.encodeCaption(context, caption);
            listStyleClass = listStyleClass + " ui-corner-bottom";
        } else {
            listStyleClass = listStyleClass + " ui-corner-all";
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)listStyleClass, null);
        this.encodeOptions(context, ol, (List)ol.getValue());
        writer.endElement("ul");
        this.encodeInput(context, clientId + "_values");
        writer.endElement("td");
    }

    protected void encodeInput(FacesContext context, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("multiple", (Object)"true", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        writer.endElement("select");
    }

    protected void encodeControls(FacesContext context, OrderList ol) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"ui-orderlist-controls", null);
        this.encodeButton(context, ol.getMoveUpLabel(), "ui-orderlist-button-move-up", "ui-icon ui-icon-arrow-1-n");
        this.encodeButton(context, ol.getMoveTopLabel(), "ui-orderlist-button-move-top", "ui-icon ui-icon-arrowstop-1-n");
        this.encodeButton(context, ol.getMoveDownLabel(), "ui-orderlist-button-move-down", "ui-icon ui-icon-arrow-1-s");
        this.encodeButton(context, ol.getMoveBottomLabel(), "ui-orderlist-button-move-bottom", "ui-icon ui-icon-arrowstop-1-s");
        writer.endElement("td");
    }

    protected void encodeOptions(FacesContext context, OrderList old, List model) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = old.getVar();
        Converter converter = old.getConverter();
        for (Object item : model) {
            context.getExternalContext().getRequestMap().put(var, item);
            String value = converter != null ? converter.getAsString(context, (UIComponent)old, old.getItemValue()) : old.getItemValue().toString();
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-orderlist-item ui-corner-all", null);
            writer.writeAttribute("data-item-value", (Object)value, null);
            if (old.getChildCount() > 0) {
                writer.startElement("table", null);
                writer.startElement("tbody", null);
                writer.startElement("tr", null);
                for (UIComponent kid : old.getChildren()) {
                    if (!(kid instanceof Column) || !kid.isRendered()) continue;
                    Column column = (Column)kid;
                    writer.startElement("td", null);
                    if (column.getStyle() != null) {
                        writer.writeAttribute("style", (Object)column.getStyle(), null);
                    }
                    if (column.getStyleClass() != null) {
                        writer.writeAttribute("class", (Object)column.getStyleClass(), null);
                    }
                    kid.encodeAll(context);
                    writer.endElement("td");
                }
                writer.endElement("tr");
                writer.endElement("tbody");
                writer.endElement("table");
            } else {
                writer.writeText((Object)old.getItemLabel(), null);
            }
            writer.endElement("li");
        }
        context.getExternalContext().getRequestMap().remove(var);
    }

    protected void encodeButton(FacesContext context, String title, String styleClass, String icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)("ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only " + styleClass), null);
        writer.writeAttribute("title", (Object)title, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext context, OrderList ol) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ol.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('OrderList','" + ol.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (ol.getEffect() != null) {
            writer.write(",effect:'" + ol.getEffect() + "'");
        }
        writer.write("});");
        this.endScript(writer);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        try {
            String[] values;
            OrderList ol = (OrderList)component;
            ArrayList<String> orderedList = new ArrayList<String>();
            Converter converter = ol.getConverter();
            for (String item : values = (String[])submittedValue) {
                String convertedValue;
                if (this.isValueBlank(item)) continue;
                String string = convertedValue = converter != null ? converter.getAsObject(context, (UIComponent)ol, item) : item;
                if (convertedValue == null) continue;
                orderedList.add(convertedValue);
            }
            return orderedList;
        }
        catch (Exception exception) {
            throw new ConverterException((Throwable)exception);
        }
    }

    protected void encodeCaption(FacesContext context, UIComponent caption) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-orderlist-caption ui-widget-header ui-corner-top", null);
        caption.encodeAll(context);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

