/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.OverlayMenu;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.separator.Separator;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.ComponentUtils;

public abstract class BaseMenuRenderer
extends OutcomeTargetRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        if (menu.isDynamic()) {
            menu.buildMenuFromModel();
        }
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected abstract void encodeMarkup(FacesContext var1, AbstractMenu var2) throws IOException;

    protected abstract void encodeScript(FacesContext var1, AbstractMenu var2) throws IOException;

    protected void encodeMenuItem(FacesContext context, MenuItem menuItem) throws IOException {
        String clientId = menuItem.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuItem.getIcon();
        String title = menuItem.getTitle();
        if (menuItem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuItem);
        } else {
            String styleClass;
            boolean disabled = menuItem.isDisabled();
            String onclick = menuItem.getOnclick();
            writer.startElement("a", null);
            writer.writeAttribute("id", (Object)menuItem.getClientId(context), null);
            if (title != null) {
                writer.writeAttribute("title", (Object)title, null);
            }
            styleClass = (styleClass = menuItem.getStyleClass()) == null ? "ui-menuitem-link ui-corner-all" : "ui-menuitem-link ui-corner-all " + styleClass;
            styleClass = disabled ? styleClass + " ui-state-disabled" : styleClass;
            writer.writeAttribute("class", (Object)styleClass, null);
            if (menuItem.getStyle() != null) {
                writer.writeAttribute("style", (Object)menuItem.getStyle(), null);
            }
            if (menuItem.getUrl() != null || menuItem.getOutcome() != null) {
                String targetURL = this.getTargetURL(context, menuItem);
                String href = disabled ? "#" : targetURL;
                writer.writeAttribute("href", (Object)targetURL, null);
                if (menuItem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                }
            } else {
                writer.writeAttribute("href", (Object)"#", null);
                UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menuItem);
                if (form == null) {
                    throw new FacesException("MenuItem must be inside a form element");
                }
                String command = menuItem.isAjax() ? this.buildAjaxRequest(context, menuItem, form) : this.buildNonAjaxRequest(context, (UIComponent)menuItem, form, clientId, true);
                String string = onclick = onclick == null ? command : onclick + ";" + command;
            }
            if (onclick != null && !disabled) {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
                writer.endElement("span");
            }
            if (menuItem.getValue() != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
                writer.writeText((Object)((String)menuItem.getValue()), "value");
                writer.endElement("span");
            }
            writer.endElement("a");
        }
    }

    protected void encodeSeparator(FacesContext context, Separator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = separator.getStyle();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-separator ui-state-default" : "ui-separator ui-state-default " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.endElement("li");
    }

    protected void encodeOverlayConfig(FacesContext context, OverlayMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",overlay:true");
        writer.write(",my:'" + menu.getMy() + "'");
        writer.write(",at:'" + menu.getAt() + "'");
        UIComponent trigger = ((UIComponent)menu).findComponent(menu.getTrigger());
        String triggerClientId = trigger == null ? menu.getTrigger() : trigger.getClientId(context);
        writer.write(",trigger:'" + triggerClientId + "'");
        writer.write(",triggerEvent:'" + menu.getTriggerEvent() + "'");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

