/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.megamenu;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.column.Column;
import org.primefaces.component.megamenu.MegaMenu;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.separator.Separator;
import org.primefaces.component.submenu.Submenu;

public class MegaMenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MegaMenu menu = (MegaMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('MegaMenu','" + menu.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",autoDisplay:" + menu.isAutoDisplay());
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MegaMenu menu = (MegaMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        String style = menu.getStyle();
        String styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-menu ui-menubar ui-megamenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix" : "ui-menu ui-menubar ui-megamenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix " + styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("role", (Object)"menubar", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        this.encodeRootItems(context, menu);
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeRootItems(FacesContext context, MegaMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : menu.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (child instanceof Submenu) {
                this.encodeRootSubmenu(context, (Submenu)child);
                continue;
            }
            if (!(child instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)child);
        }
    }

    protected void encodeRootSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        String label = submenu.getLabel();
        String style = submenu.getStyle();
        String styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget ui-menuitem ui-corner-all ui-menu-parent" : "ui-widget ui-menuitem ui-corner-all ui-menu-parent " + styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("role", (Object)"menuitem", null);
        writer.writeAttribute("aria-haspopup", (Object)"true", null);
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"javascript:void(0)", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-link ui-corner-all", null);
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
            writer.endElement("span");
        }
        if (label != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
            writer.writeText((Object)submenu.getLabel(), "value");
            writer.endElement("span");
        }
        this.encodeSubmenuIcon(context, submenu);
        writer.endElement("a");
        if (submenu.getChildCount() > 0) {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-menu-list ui-corner-all ui-helper-clearfix ui-menu-child ui-shadow", null);
            writer.writeAttribute("role", (Object)"menu", null);
            writer.startElement("table", null);
            writer.startElement("tbody", null);
            writer.startElement("tr", null);
            for (UIComponent child : submenu.getChildren()) {
                if (!child.isRendered() || !(child instanceof Column)) continue;
                this.encodeColumn(context, (Column)child);
            }
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
            writer.endElement("ul");
        }
        writer.endElement("li");
    }

    protected void encodeColumn(FacesContext context, Column column) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        if (column.getStyle() != null) {
            writer.writeAttribute("style", (Object)column.getStyle(), null);
        }
        if (column.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)column.getStyleClass(), null);
        }
        for (UIComponent child : column.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof Submenu) {
                this.encodeDescendantSubmenu(context, (Submenu)child);
                continue;
            }
            if (child instanceof Separator) {
                this.encodeSubmenuSeparator(context, (Separator)child);
                continue;
            }
            child.encodeAll(context);
        }
        writer.endElement("td");
    }

    protected void encodeDescendantSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        String style = submenu.getStyle();
        String styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget-header ui-corner-all" : "ui-widget-header ui-corner-all " + styleClass;
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        writer.writeAttribute("role", (Object)"menu", null);
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("h3", null);
        if (label != null) {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("h3");
        writer.endElement("li");
        for (UIComponent child : submenu.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)child);
        }
        writer.endElement("ul");
    }

    protected void encodeSubmenuIcon(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getParent() instanceof MegaMenu ? "ui-icon ui-icon-triangle-1-s" : "ui-icon ui-icon-triangle-1-e";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)icon, null);
        writer.endElement("span");
    }

    protected void encodeSubmenuSeparator(FacesContext context, Separator separator) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = separator.getStyleClass();
        styleClass = styleClass == null ? "ui-separator ui-state-default ui-corner-all" : "ui-separator ui-state-default ui-corner-all " + styleClass;
        writer.startElement("hr", (UIComponent)separator);
        writer.writeAttribute("id", (Object)separator.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (separator.getTitle() != null) {
            writer.writeAttribute("title", (Object)separator.getTitle(), "title");
        }
        if (separator.getStyle() != null) {
            writer.writeAttribute("style", (Object)separator.getStyle(), "style");
        }
        writer.endElement("hr");
    }
}

