/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.keyboard;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.keyboard.Keyboard;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class KeyboardRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Keyboard keyboard = (Keyboard)component;
        if (keyboard.isDisabled() || keyboard.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)keyboard);
        String clientId = keyboard.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            keyboard.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Keyboard keyboard = (Keyboard)component;
        this.encodeMarkup(context, keyboard);
        this.encodeScript(context, keyboard);
    }

    protected void encodeScript(FacesContext context, Keyboard keyboard) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = keyboard.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Keyboard','" + keyboard.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",showOn:'" + keyboard.getShowMode() + "'");
        writer.write(",showAnim:'" + keyboard.getEffect() + "'");
        if (keyboard.isButtonImageOnly()) {
            writer.write(",buttonImageOnly:true");
        }
        if (keyboard.getButtonImage() != null) {
            writer.write(",buttonImage:'" + this.getResourceURL(context, keyboard.getButtonImage()) + "'");
        }
        if (keyboard.getEffectDuration() != null) {
            writer.write(",duration:'" + keyboard.getEffectDuration() + "'");
        }
        if (!keyboard.isKeypadOnly()) {
            writer.write(",keypadOnly:false");
            writer.write(",layoutName:'" + keyboard.getLayout() + "'");
            if (keyboard.getLayoutTemplate() != null) {
                writer.write(",layoutTemplate:'" + keyboard.getLayoutTemplate() + "'");
            }
        }
        if (keyboard.getStyleClass() != null) {
            writer.write(",keypadClass:'" + keyboard.getStyleClass() + "'");
        }
        if (keyboard.getPromptLabel() != null) {
            writer.write(",prompt:'" + keyboard.getPromptLabel() + "'");
        }
        if (keyboard.getBackspaceLabel() != null) {
            writer.write(",backText:'" + keyboard.getBackspaceLabel() + "'");
        }
        if (keyboard.getClearLabel() != null) {
            writer.write(",clearText:'" + keyboard.getClearLabel() + "'");
        }
        if (keyboard.getCloseLabel() != null) {
            writer.write(",closeText:'" + keyboard.getCloseLabel() + "'");
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)keyboard);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, Keyboard keyboard) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = keyboard.getClientId(context);
        String type = keyboard.isPassword() ? "password" : "text";
        String defaultClass = "ui-inputfield ui-keyboard-input ui-widget ui-state-default ui-corner-all";
        String styleClass = keyboard.getStyleClass();
        styleClass = styleClass == null ? defaultClass : defaultClass + " " + styleClass;
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)keyboard);
        writer.startElement("input", (UIComponent)keyboard);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)type, null);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, "value");
        }
        this.renderPassThruAttributes(context, (UIComponent)keyboard, HTML.INPUT_TEXT_ATTRS);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (keyboard.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (keyboard.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (keyboard.getStyle() != null) {
            writer.writeAttribute("style", (Object)keyboard.getStyle(), "style");
        }
        writer.endElement("input");
    }
}

