/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inplace;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inplace.Inplace;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class InplaceRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Inplace inplace = (Inplace)component;
        this.encodeMarkup(context, inplace);
        this.encodeScript(context, inplace);
    }

    protected void encodeMarkup(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inplace.getClientId(context);
        String userStyleClass = inplace.getStyleClass();
        String userStyle = inplace.getStyle();
        String styleClass = userStyleClass == null ? "ui-inplace ui-hidden-container" : "ui-inplace ui-hidden-container " + userStyleClass;
        boolean disabled = inplace.isDisabled();
        String displayClass = disabled ? "ui-inplace-display-disabled" : "ui-inplace-display";
        boolean validationFailed = context.isValidationFailed();
        String displayStyle = validationFailed ? "none" : "inline";
        String contentStyle = validationFailed ? "inline" : "none";
        writer.startElement("span", (UIComponent)inplace);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (userStyle != null) {
            writer.writeAttribute("style", (Object)userStyle, "id");
        }
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_display"), "id");
        writer.writeAttribute("class", (Object)displayClass, null);
        writer.writeAttribute("style", (Object)("display:" + displayStyle), null);
        writer.writeText((Object)this.getLabelToRender(context, inplace), null);
        writer.endElement("span");
        if (!inplace.isDisabled()) {
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + "_content"), "id");
            writer.writeAttribute("class", (Object)"ui-inplace-content", null);
            writer.writeAttribute("style", (Object)("display:" + contentStyle), null);
            this.renderChildren(context, (UIComponent)inplace);
            if (inplace.isEditor()) {
                this.encodeEditor(context, inplace);
            }
            writer.endElement("span");
        }
        writer.endElement("span");
    }

    protected String getLabelToRender(FacesContext context, Inplace inplace) {
        String label = inplace.getLabel();
        String emptyLabel = inplace.getEmptyLabel();
        if (label != null) {
            return label;
        }
        String value = ComponentUtils.getValueToRender(context, (UIComponent)inplace.getChildren().get(0));
        if (value == null || this.isValueBlank(value)) {
            if (emptyLabel != null) {
                return emptyLabel;
            }
            return "";
        }
        return value;
    }

    protected void encodeScript(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inplace.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Inplace','" + inplace.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",effect:'" + inplace.getEffect() + "'");
        writer.write(",effectSpeed:'" + inplace.getEffectSpeed() + "'");
        writer.write(",event:'" + inplace.getEvent() + "'");
        if (inplace.isToggleable()) {
            writer.write(",toggleable:true");
        }
        if (inplace.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (inplace.isEditor()) {
            writer.write(",editor:true");
        }
        this.encodeClientBehaviors(context, inplace);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeEditor(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(inplace.getClientId(context) + "_editor"), null);
        writer.writeAttribute("class", (Object)"ui-inplace-editor", null);
        this.encodeButton(context, inplace.getSaveLabel(), "ui-inplace-save", "ui-icon-check");
        this.encodeButton(context, inplace.getCancelLabel(), "ui-inplace-cancel", "ui-icon-close");
        writer.endElement("span");
    }

    protected void encodeButton(FacesContext context, String title, String styleClass, String icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)("ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only " + styleClass), null);
        writer.writeAttribute("title", (Object)title, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("button");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

