/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFExporter
extends Exporter {
    private Font cellFont;
    private Font facetFont;

    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance((Document)document, (OutputStream)baos);
            if (preProcessor != null) {
                preProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            if (!document.isOpen()) {
                document.open();
            }
            document.add((Element)this.exportPDFTable(context, table, pageOnly, selectionOnly, encodingType));
            if (postProcessor != null) {
                postProcessor.invoke(context.getELContext(), new Object[]{document});
            }
            document.close();
            this.writePDFToResponse(context.getExternalContext(), baos, filename);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected PdfPTable exportPDFTable(FacesContext context, DataTable table, boolean pageOnly, boolean selectionOnly, String encoding) {
        int columnsCount = this.getColumnsCount(table);
        PdfPTable pdfTable = new PdfPTable(columnsCount);
        this.cellFont = FontFactory.getFont((String)"Times", (String)encoding);
        this.facetFont = FontFactory.getFont((String)"Times", (String)encoding, (float)12.0f, (int)1);
        this.addColumnFacets(table, pdfTable, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, pdfTable);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, pdfTable);
        } else {
            this.exportAll(context, table, pdfTable);
        }
        if (table.hasFooterColumn()) {
            this.addColumnFacets(table, pdfTable, Exporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
        return pdfTable;
    }

    protected void exportPageOnly(FacesContext context, DataTable table, PdfPTable pdfTable) {
        int first = table.getFirst();
        int rowsToExport = first + table.getRows();
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, pdfTable, rowIndex);
        }
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, PdfPTable pdfTable) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportCells(table, pdfTable);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, pdfTable);
            }
        }
    }

    protected void exportAll(FacesContext context, DataTable table, PdfPTable pdfTable) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                if (rowIndex % rows == 0) {
                    table.setFirst(rowIndex);
                    table.loadLazyData();
                }
                this.exportRow(table, pdfTable, rowIndex);
            }
            table.setFirst(first);
            table.loadLazyData();
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, pdfTable, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportRow(DataTable table, PdfPTable pdfTable, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.exportCells(table, pdfTable);
    }

    protected void exportCells(DataTable table, PdfPTable pdfTable) {
        for (UIColumn col : table.getColumns()) {
            if (!col.isRendered()) {
                return;
            }
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            if (!col.isExportable()) continue;
            this.addColumnValue(pdfTable, col.getChildren(), this.cellFont);
        }
    }

    protected void addColumnFacets(DataTable table, PdfPTable pdfTable, Exporter.ColumnType columnType) {
        for (UIColumn col : table.getColumns()) {
            if (!col.isRendered()) {
                return;
            }
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            if (!col.isExportable()) continue;
            this.addColumnValue(pdfTable, col.getFacet(columnType.facet()), this.facetFont);
        }
    }

    protected void addColumnValue(PdfPTable pdfTable, UIComponent component, Font font) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        pdfTable.addCell((Phrase)new Paragraph(value, font));
    }

    protected void addColumnValue(PdfPTable pdfTable, List<UIComponent> components, Font font) {
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
            builder.append(value);
        }
        pdfTable.addCell((Phrase)new Paragraph(builder.toString(), font));
    }

    protected void writePDFToResponse(ExternalContext externalContext, ByteArrayOutputStream baos, String fileName) throws IOException, DocumentException {
        externalContext.setResponseContentType("application/pdf");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + fileName + ".pdf");
        externalContext.setResponseContentLength(baos.size());
        externalContext.addResponseCookie("primefaces.download", "true", new HashMap());
        OutputStream out = externalContext.getResponseOutputStream();
        baos.writeTo(out);
        externalContext.responseFlushBuffer();
    }

    protected int getColumnsCount(DataTable table) {
        int count = 0;
        for (UIComponent child : table.getChildren()) {
            Columns columns;
            if (!child.isRendered()) continue;
            if (child instanceof Column) {
                Column column = (Column)child;
                if (!column.isExportable()) continue;
                ++count;
                continue;
            }
            if (!(child instanceof Columns) || !(columns = (Columns)child).isExportable()) continue;
            count += columns.getRowCount();
        }
        return count;
    }
}

