/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExporter
extends Exporter {
    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        if (preProcessor != null) {
            preProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        this.addColumnFacets(table, sheet, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, sheet);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, sheet);
        } else {
            this.exportAll(context, table, sheet);
        }
        if (table.hasFooterColumn()) {
            this.addColumnFacets(table, sheet, Exporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
        if (postProcessor != null) {
            postProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        this.writeExcelToResponse(context.getExternalContext(), (Workbook)wb, filename);
    }

    protected void exportPageOnly(FacesContext context, DataTable table, Sheet sheet) {
        int first = table.getFirst();
        int rowsToExport = first + table.getRows();
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, sheet, rowIndex);
        }
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, Sheet sheet) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportCells(table, sheet);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, sheet);
            }
        }
    }

    protected void exportAll(FacesContext context, DataTable table, Sheet sheet) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                if (rowIndex % rows == 0) {
                    table.setFirst(rowIndex);
                    table.loadLazyData();
                }
                this.exportRow(table, sheet, rowIndex);
            }
            table.setFirst(first);
            table.loadLazyData();
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, sheet, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportRow(DataTable table, Sheet sheet, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.exportCells(table, sheet);
    }

    protected void exportCells(DataTable table, Sheet sheet) {
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row row = sheet.createRow(sheetRowIndex);
        for (UIColumn col : table.getColumns()) {
            if (!col.isRendered()) {
                return;
            }
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            if (!col.isExportable()) continue;
            this.addColumnValue(row, col.getChildren());
        }
    }

    protected void addColumnFacets(DataTable table, Sheet sheet, Exporter.ColumnType columnType) {
        int sheetRowIndex = columnType.equals((Object)Exporter.ColumnType.HEADER) ? 0 : sheet.getLastRowNum() + 1;
        Row rowHeader = sheet.createRow(sheetRowIndex);
        for (UIColumn col : table.getColumns()) {
            if (!col.isRendered()) {
                return;
            }
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyModel();
            }
            if (!col.isExportable()) continue;
            this.addColumnValue(rowHeader, col.getFacet(columnType.facet()));
        }
    }

    protected void addColumnValue(Row row, UIComponent component) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        cell.setCellValue((RichTextString)new HSSFRichTextString(value));
    }

    protected void addColumnValue(Row row, List<UIComponent> components) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
            builder.append(value);
        }
        cell.setCellValue((RichTextString)new HSSFRichTextString(builder.toString()));
    }

    protected void writeExcelToResponse(ExternalContext externalContext, Workbook generatedExcel, String filename) throws IOException {
        externalContext.setResponseContentType("application/vnd.ms-excel");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", "attachment;filename=" + filename + ".xls");
        externalContext.addResponseCookie("primefaces.download", "true", new HashMap());
        OutputStream out = externalContext.getResponseOutputStream();
        generatedExcel.write(out);
        externalContext.responseFlushBuffer();
    }
}

