/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dock;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dock.Dock;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class DockRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Dock dock = (Dock)component;
        if (dock.isDynamic()) {
            dock.buildMenuFromModel();
        }
        this.encodeStyle(context, dock);
        this.encodeMarkup(context, dock);
        this.encodeScript(context, dock);
    }

    protected void encodeStyle(FacesContext context, Dock dock) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.write("<!--[if lt IE 7]>\n<style type=\"text/css\">\n");
        responseWriter.write(".ui-dock img { behavior: url('" + this.getResourceRequestPath(context, "dock/assets/iepngfix.htc") + "');}");
        responseWriter.write("</style><![endif]-->");
    }

    protected void encodeScript(FacesContext facesContext, Dock dock) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dock.getClientId(facesContext);
        String position = dock.getPosition();
        String containerClass = ".ui-dock-container-" + position;
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('Dock','" + dock.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",maxWidth: " + dock.getMaxWidth());
        writer.write(",items: 'a'");
        writer.write(",itemsText: 'span'");
        writer.write(",container: '" + containerClass + "'");
        writer.write(",itemWidth: " + dock.getItemWidth());
        writer.write(",proximity: " + dock.getProximity());
        writer.write(",halign: '" + dock.getHalign() + "'");
        writer.write("},'dock');");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext facesContext, Dock dock) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dock.getClientId(facesContext);
        String position = dock.getPosition();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)("ui-dock-" + position + " ui-widget"), "styleClass");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)("ui-dock-container-" + position + " ui-widget-header"), null);
        this.encodeMenuItems(facesContext, dock);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeMenuItems(FacesContext context, Dock dock) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String position = dock.getPosition();
        for (UIComponent child : dock.getChildren()) {
            if (!(child instanceof MenuItem) || !child.isRendered()) continue;
            MenuItem menuitem = (MenuItem)child;
            String clientId = menuitem.getClientId(context);
            String styleClass = "ui-dock-item-" + position;
            if (menuitem.getStyleClass() != null) {
                styleClass = styleClass + " " + menuitem.getStyleClass();
            }
            writer.startElement("a", null);
            writer.writeAttribute("id", (Object)menuitem.getClientId(context), null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (menuitem.getStyle() != null) {
                writer.writeAttribute("style", (Object)menuitem.getStyle(), null);
            }
            if (menuitem.getUrl() != null) {
                writer.writeAttribute("href", (Object)this.getResourceURL(context, menuitem.getUrl()), null);
                if (menuitem.getOnclick() != null) {
                    writer.writeAttribute("onclick", (Object)menuitem.getOnclick(), null);
                }
                if (menuitem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
                }
            } else {
                writer.writeAttribute("href", (Object)"#", null);
                UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menuitem);
                if (form == null) {
                    throw new FacesException("Dock must be inside a form element");
                }
                String command = menuitem.isAjax() ? this.buildAjaxRequest(context, menuitem, form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, form, clientId, true);
                command = menuitem.getOnclick() == null ? command : menuitem.getOnclick() + ";" + command;
                writer.writeAttribute("onclick", (Object)command, null);
            }
            if (position.equalsIgnoreCase("top")) {
                this.encodeItemIcon(context, menuitem);
                this.encodeItemLabel(context, menuitem);
            } else {
                this.encodeItemLabel(context, menuitem);
                this.encodeItemIcon(context, menuitem);
            }
            writer.endElement("a");
        }
    }

    protected void encodeItemIcon(FacesContext facesContext, MenuItem menuitem) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)this.getResourceURL(facesContext, menuitem.getIcon()), null);
        writer.endElement("img");
    }

    protected void encodeItemLabel(FacesContext facesContext, MenuItem menuitem) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("span", null);
        if (menuitem.getValue() != null) {
            writer.write((String)menuitem.getValue());
        }
        writer.endElement("span");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

