/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.model.ListDataModel;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.row.Row;
import org.primefaces.model.BeanPropertyComparator;
import org.primefaces.model.SortOrder;

public class SortFeature
implements DataTableFeature {
    private boolean isSortRquest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_sorting");
    }

    public void decode(FacesContext context, DataTable table) {
        UIColumn sortColumn;
        String sortDir;
        block9: {
            table.setRowIndex(-1);
            String clientId = table.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String sortKey = (String)params.get(clientId + "_sortKey");
            sortDir = (String)params.get(clientId + "_sortDir");
            boolean isDynamicColumn = params.containsKey(clientId + "_dynamic_column");
            sortColumn = null;
            if (isDynamicColumn) {
                String[] idTokens = sortKey.split(String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context)));
                int colIndex = Integer.parseInt(idTokens[idTokens.length - 1]);
                for (UIColumn column : table.getColumns()) {
                    DynamicColumn dynamicColumn;
                    if (!(column instanceof DynamicColumn) || (dynamicColumn = (DynamicColumn)column).getIndex() != colIndex) continue;
                    dynamicColumn.applyModel();
                    sortColumn = dynamicColumn;
                    break;
                }
            } else {
                ColumnGroup group = table.getColumnGroup("header");
                if (group != null) {
                    for (UIComponent child : group.getChildren()) {
                        Row headerRow = (Row)child;
                        for (UIComponent headerRowChild : headerRow.getChildren()) {
                            Column column = (Column)headerRowChild;
                            if (!column.getClientId(context).equals(sortKey)) continue;
                            sortColumn = column;
                            break block9;
                        }
                    }
                } else {
                    for (UIComponent child : table.getChildren()) {
                        if (!child.getClientId(context).equals(sortKey)) continue;
                        sortColumn = (Column)child;
                        break;
                    }
                }
            }
        }
        table.setFirst(0);
        ValueExpression sortByVE = sortColumn.getValueExpression("sortBy");
        table.setValueExpression("sortBy", sortByVE);
        table.setSortColumn(sortColumn);
        table.setSortOrder(sortDir);
        if (!table.isLazy()) {
            this.sort(context, table, sortByVE, table.getVar(), SortOrder.valueOf(sortDir), sortColumn.getSortFunction());
        }
    }

    public void sort(FacesContext context, DataTable table, ValueExpression sortByVE, String var, SortOrder sortOrder, MethodExpression sortFunction) {
        Object value = table.getValue();
        List list = null;
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            list = (List)value;
        } else if (value instanceof ListDataModel) {
            list = (List)((ListDataModel)value).getWrappedData();
        } else {
            throw new FacesException("Data type should be java.util.List or javax.faces.model.ListDataModel instance to be sortable.");
        }
        Collections.sort(list, new BeanPropertyComparator(sortByVE, var, sortOrder, sortFunction));
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        if (table.isLazy()) {
            table.loadLazyData();
        }
        renderer.encodeTbody(context, table, true);
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return this.isSortRquest(context, table);
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isSortRquest(context, table);
    }
}

