/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.util.ComponentUtils;

public class SelectionFeature
implements DataTableFeature {
    public void decode(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String selection = (String)params.get(clientId + "_selection");
        if (table.isSingleSelectionMode()) {
            this.decodeSingleSelection(table, selection);
        } else {
            this.decodeMultipleSelection(table, selection);
        }
    }

    void decodeSingleSelection(DataTable table, String selection) {
        if (ComponentUtils.isValueBlank(selection)) {
            table.setSelection(null);
        } else {
            table.setSelection(table.getRowData(selection));
        }
    }

    void decodeMultipleSelection(DataTable table, String selection) {
        Class clazz = table.getValueExpression("selection").getType(FacesContext.getCurrentInstance().getELContext());
        if (ComponentUtils.isValueBlank(selection)) {
            Object data = Array.newInstance(clazz.getComponentType(), 0);
            table.setSelection(data);
        } else {
            String[] rowKeys = selection.split(",");
            ArrayList<Object> selectionList = new ArrayList<Object>();
            for (int i = 0; i < rowKeys.length; ++i) {
                Object rowData = table.getRowData(rowKeys[i]);
                if (rowData == null) continue;
                selectionList.add(rowData);
            }
            Object selectinArray = Array.newInstance(clazz.getComponentType(), selectionList.size());
            table.setSelection(selectionList.toArray((Object[])selectinArray));
        }
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        throw new RuntimeException("SelectFeature should not encode.");
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return table.isSelectionEnabled();
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return false;
    }
}

