/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;

public class RowExpandFeature
implements DataTableFeature {
    public void decode(FacesContext context, DataTable table) {
        throw new RuntimeException("RowExpandFeature should not encode.");
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map params = context.getExternalContext().getRequestParameterMap();
        int expandedRowIndex = Integer.parseInt((String)params.get(table.getClientId(context) + "_expandedRowIndex"));
        String rowIndexVar = table.getRowIndexVar();
        table.setRowIndex(expandedRowIndex);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().put(rowIndexVar, expandedRowIndex);
        }
        writer.startElement("tr", null);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.writeAttribute("class", (Object)"ui-expanded-row-content ui-widget-content", null);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)table.getColumnsCount(), null);
        table.getRowExpansion().encodeAll(context);
        writer.endElement("td");
        writer.endElement("tr");
        table.setRowIndex(-1);
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_rowExpansion");
    }
}

