/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dashboard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIPanel;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.event.DashboardReorderEvent;
import org.primefaces.model.DashboardColumn;
import org.primefaces.model.DashboardModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js")})
public class Dashboard
extends UIPanel
implements Widget,
ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Dashboard";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.DashboardRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";
    public static final String CONTAINER_CLASS = "ui-dashboard";
    public static final String COLUMN_CLASS = "ui-dashboard-column";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("reorder"));

    public Dashboard() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
        this.handleAttribute("widgetVar", _widgetVar);
    }

    public DashboardModel getModel() {
        return (DashboardModel)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.model), null);
    }

    public void setModel(DashboardModel _model) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.model), (Object)_model);
        this.handleAttribute("model", _model);
    }

    public boolean isDisabled() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabled), (Object)false);
    }

    public void setDisabled(boolean _disabled) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabled), (Object)_disabled);
        this.handleAttribute("disabled", _disabled);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
        this.handleAttribute("style", _style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
        this.handleAttribute("styleClass", _styleClass);
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.isRequestSource(context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("reorder")) {
                String[] idTokens;
                String widgetClientId = (String)params.get(clientId + "_widgetId");
                Integer itemIndex = Integer.valueOf((String)params.get(clientId + "_itemIndex"));
                Integer receiverColumnIndex = Integer.valueOf((String)params.get(clientId + "_receiverColumnIndex"));
                String senderIndexParam = clientId + "_senderColumnIndex";
                Integer senderColumnIndex = null;
                if (params.containsKey(senderIndexParam)) {
                    senderColumnIndex = Integer.valueOf((String)params.get(senderIndexParam));
                }
                String widgetId = (idTokens = widgetClientId.split(":")).length == 1 ? idTokens[0] : idTokens[idTokens.length - 1];
                DashboardReorderEvent reorderEvent = new DashboardReorderEvent((UIComponent)this, behaviorEvent.getBehavior(), widgetId, itemIndex, receiverColumnIndex, senderColumnIndex);
                reorderEvent.setPhaseId(behaviorEvent.getPhaseId());
                this.updateDashboardModel(this.getModel(), widgetId, itemIndex, receiverColumnIndex, senderColumnIndex);
                super.queueEvent((FacesEvent)reorderEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    protected void updateDashboardModel(DashboardModel model, String widgetId, Integer itemIndex, Integer receiverColumnIndex, Integer senderColumnIndex) {
        if (senderColumnIndex == null) {
            DashboardColumn column = model.getColumn(receiverColumnIndex);
            column.reorderWidget(itemIndex, widgetId);
        } else {
            DashboardColumn oldColumn = model.getColumn(senderColumnIndex);
            DashboardColumn newColumn = model.getColumn(receiverColumnIndex);
            model.transferWidget(oldColumn, newColumn, widgetId, itemIndex);
        }
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void processDecodes(FacesContext context) {
        if (this.isRequestSource(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isRequestSource(context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRequestSource(context)) {
            super.processUpdates(context);
        }
    }

    private boolean isRequestSource(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        model,
        disabled,
        style,
        styleClass;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

