/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandlink;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.commandlink.CommandLink;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class CommandLinkRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        CommandLink link = (CommandLink)component;
        if (link.isDisabled()) {
            return;
        }
        String param = component.getClientId();
        if (context.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        CommandLink link = (CommandLink)component;
        String clientId = link.getClientId(context);
        Object label = link.getValue();
        if (!link.isDisabled()) {
            String request;
            String styleClass = link.getStyleClass();
            styleClass = styleClass == null ? "ui-commandlink" : "ui-commandlink " + styleClass;
            writer.startElement("a", (UIComponent)link);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (link.isAjax()) {
                request = this.buildAjaxRequest(context, link, null);
            } else {
                UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)link);
                if (form == null) {
                    throw new FacesException("Commandlink \"" + clientId + "\" must be inside a form component");
                }
                request = this.buildNonAjaxRequest(context, (UIComponent)link, form, clientId, true);
            }
            String onclick = link.getOnclick() != null ? link.getOnclick() + ";" + request : request;
            writer.writeAttribute("onclick", (Object)onclick, "onclick");
            this.renderPassThruAttributes(context, (UIComponent)link, HTML.LINK_ATTRS, HTML.CLICK_EVENT);
            if (label != null) {
                writer.writeText(label, "value");
            } else {
                this.renderChildren(context, (UIComponent)link);
            }
            writer.endElement("a");
        } else {
            String styleClass = link.getStyleClass();
            styleClass = styleClass == null ? "ui-commandlink ui-state-disabled" : "ui-commandlink ui-state-disabled " + styleClass;
            writer.startElement("span", (UIComponent)link);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("class", (Object)styleClass, "styleclass");
            if (link.getStyle() != null) {
                writer.writeAttribute("style", (Object)link.getStyle(), "style");
            }
            if (label != null) {
                writer.writeText(label, "value");
            } else {
                this.renderChildren(context, (UIComponent)link);
            }
            writer.endElement("span");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

