/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.bar;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.bar.BarChart;
import org.primefaces.model.chart.CartesianChartModel;
import org.primefaces.model.chart.ChartSeries;

public class BarChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        BarChart chart = (BarChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BarChart chart = (BarChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('BarChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeData(context, chart);
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeOptions(FacesContext context, BarChart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        CartesianChartModel model = (CartesianChartModel)chart.getValue();
        writer.write(",axes:{");
        this.encodeAxis(context, "xaxis", chart.getXaxisLabel(), chart.getXaxisAngle(), Double.MIN_VALUE, Double.MAX_VALUE);
        this.encodeAxis(context, ",yaxis", chart.getYaxisLabel(), chart.getYaxisAngle(), Double.MIN_VALUE, Double.MAX_VALUE);
        writer.write("}");
        writer.write(",series:[");
        Iterator<ChartSeries> it = model.getSeries().iterator();
        while (it.hasNext()) {
            ChartSeries series = it.next();
            writer.write("{");
            writer.write("label:'" + series.getLabel() + "'");
            writer.write("}");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        writer.write(",orientation:'" + chart.getOrientation() + "'");
        writer.write(",barPadding:" + chart.getBarPadding());
        writer.write(",barMargin:" + chart.getBarMargin());
        if (chart.isStacked()) {
            writer.write(",stackSeries:true");
        }
        if (chart.isBreakOnNull()) {
            writer.write(",breakOnNull:true");
        }
        if (chart.isZoom()) {
            writer.write(",zoom:true");
        }
        if (chart.isAnimate()) {
            writer.write(",animate:true");
        }
        if (chart.isShowDatatip()) {
            writer.write(",datatip:true");
            if (chart.getDatatipFormat() != null) {
                writer.write(",datatipFormat:'" + chart.getDatatipFormat() + "'");
            }
        }
        if (chart.getMin() != Double.MIN_VALUE) {
            writer.write(",min:" + chart.getMin());
        }
        if (chart.getMax() != Double.MAX_VALUE) {
            writer.write(",max:" + chart.getMax());
        }
    }

    protected void encodeData(FacesContext context, BarChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        CartesianChartModel model = (CartesianChartModel)chart.getValue();
        boolean horizontal = chart.getOrientation().equals("horizontal");
        List<String> categories = chart.getCategories();
        writer.write(",data:[");
        Iterator<Object> it = model.getSeries().iterator();
        while (it.hasNext()) {
            ChartSeries series = it.next();
            int i = 1;
            writer.write("[");
            Iterator<Object> x = series.getData().keySet().iterator();
            while (x.hasNext()) {
                String valueToRender;
                Number value = series.getData().get(x.next());
                String string = valueToRender = value != null ? value.toString() : "null";
                if (horizontal) {
                    writer.write("[");
                    writer.write(valueToRender + "," + i);
                    writer.write("]");
                    ++i;
                } else {
                    writer.write(valueToRender);
                }
                if (!x.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        writer.write(",categories:[");
        it = categories.iterator();
        while (it.hasNext()) {
            writer.write("'" + (String)it.next() + "'");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }
}

