/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.captcha;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.captcha.Captcha;
import org.primefaces.component.captcha.Verification;
import org.primefaces.renderkit.CoreRenderer;

public class CaptchaRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(CaptchaRenderer.class.getName());
    private static final String CHALLENGE_FIELD = "recaptcha_challenge_field";
    private static final String RESPONSE_FIELD = "recaptcha_response_field";

    public void decode(FacesContext context, UIComponent component) {
        Captcha captcha = (Captcha)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String challenge = (String)params.get(CHALLENGE_FIELD);
        String answer = (String)params.get(RESPONSE_FIELD);
        if (answer != null) {
            if (answer.equals("")) {
                captcha.setSubmittedValue(answer);
            } else {
                captcha.setSubmittedValue(new Verification(challenge, answer));
            }
        } else {
            captcha.setSubmittedValue("");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Captcha captcha = (Captcha)component;
        captcha.setRequired(true);
        String protocol = captcha.isSecure() ? "https" : "http";
        String publicKey = this.getPublicKey(context, captcha);
        if (publicKey == null) {
            throw new FacesException("Cannot find public key for catpcha, use primefaces.PUBLIC_CAPTCHA_KEY context-param to define one");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("var RecaptchaOptions = {");
        writer.write("theme:\"" + captcha.getTheme() + "\"");
        writer.write(",lang:\"" + captcha.getLanguage() + "\"");
        if (captcha.getTabindex() != 0) {
            writer.write(",tabIndex:" + captcha.getTabindex());
        }
        writer.write("};");
        writer.endElement("script");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)(protocol + "://www.google.com/recaptcha/api/challenge?k=" + publicKey), null);
        writer.endElement("script");
        writer.startElement("noscript", null);
        writer.startElement("iframe", null);
        writer.writeAttribute("src", (Object)(protocol + "://www.google.com/recaptcha/api/noscript?k=" + publicKey), null);
        writer.endElement("iframe");
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)CHALLENGE_FIELD, null);
        writer.writeAttribute("name", (Object)CHALLENGE_FIELD, null);
        writer.writeAttribute("rows", (Object)"3", null);
        writer.writeAttribute("columns", (Object)"40", null);
        writer.endElement("textarea");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)RESPONSE_FIELD, null);
        writer.writeAttribute("name", (Object)RESPONSE_FIELD, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)"manual_challenge", null);
        writer.endElement("input");
        writer.endElement("noscript");
    }

    protected String getPublicKey(FacesContext context, Captcha captcha) {
        return context.getExternalContext().getInitParameter("primefaces.PUBLIC_CAPTCHA_KEY");
    }
}

