/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.SavedState;
import org.primefaces.component.api.WrapperEvent;
import org.primefaces.model.TreeNode;

public abstract class UITree
extends UIComponentBase
implements NamingContainer {
    public static final String SEPARATOR = "_";
    private String rowKey;
    private TreeNode rowNode;

    public String getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(String rowKey) {
        this.saveDescendantState();
        this.rowKey = rowKey;
        if (rowKey == null) {
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(this.getVar());
        } else {
            TreeNode root = this.getValue();
            this.rowNode = this.findTreeNode(root, rowKey);
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(this.getVar(), this.rowNode.getData());
        }
        this.restoreDescendantState();
    }

    public TreeNode getRowNode() {
        return this.rowNode;
    }

    public String getVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.var), null);
    }

    public void setVar(String _var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)_var);
    }

    public TreeNode getValue() {
        return (TreeNode)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value), null);
    }

    public void setValue(TreeNode _value) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), (Object)_value);
    }

    protected TreeNode findTreeNode(TreeNode searchRoot, String rowKey) {
        String[] paths = rowKey.split(SEPARATOR);
        if (paths.length == 0) {
            return null;
        }
        int childIndex = Integer.parseInt(paths[0]);
        searchRoot = searchRoot.getChildren().get(childIndex);
        if (paths.length == 1) {
            return searchRoot;
        }
        String relativeRowKey = rowKey.substring(rowKey.indexOf(SEPARATOR) + 1);
        return this.findTreeNode(searchRoot, relativeRowKey);
    }

    public String getContainerClientId(FacesContext context) {
        String clientId = super.getContainerClientId(context);
        String _rowKey = this.getRowKey();
        if (_rowKey == null) {
            return clientId;
        }
        StringBuilder builder = new StringBuilder();
        return builder.append(clientId).append(UINamingContainer.getSeparatorChar((FacesContext)context)).append(this.rowKey).toString();
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new WrapperEvent((UIComponent)this, event, this.getRowKey()));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof WrapperEvent)) {
            super.broadcast(event);
            return;
        }
        WrapperEvent wrapperEvent = (WrapperEvent)event;
        FacesEvent originalEvent = wrapperEvent.getFacesEvent();
        UIComponent originalSource = (UIComponent)originalEvent.getSource();
        this.setRowKey(wrapperEvent.getRowKey());
        originalSource.broadcast(originalEvent);
    }

    public void processDecodes(FacesContext context) {
        this.pushComponentToEL(context, (UIComponent)this);
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (saved == null) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.saved));
        }
        this.processNodes(context, PhaseId.APPLY_REQUEST_VALUES);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        this.popComponentFromEL(context);
    }

    public void processValidators(FacesContext context) {
        this.pushComponentToEL(context, (UIComponent)this);
        this.processNodes(context, PhaseId.PROCESS_VALIDATIONS);
        this.popComponentFromEL(context);
    }

    public void processUpdates(FacesContext context) {
        this.pushComponentToEL(context, (UIComponent)this);
        this.processNodes(context, PhaseId.UPDATE_MODEL_VALUES);
        this.popComponentFromEL(context);
    }

    protected void processNodes(FacesContext context, PhaseId phaseId) {
        this.processFacets(context, phaseId);
        this.processColumnFacets(context, phaseId);
        TreeNode root = this.getValue();
        if (root != null) {
            this.processNode(context, phaseId, root, null);
        }
        this.setRowKey(null);
    }

    protected void processNode(FacesContext context, PhaseId phaseId, TreeNode treeNode, String rowKey) {
        this.processColumnChildren(context, phaseId, rowKey);
        if (treeNode.isExpanded() || treeNode.getParent() == null) {
            int childIndex = 0;
            Iterator<TreeNode> iterator = treeNode.getChildren().iterator();
            while (iterator.hasNext()) {
                String childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + SEPARATOR + childIndex;
                this.processNode(context, phaseId, iterator.next(), childRowKey);
                ++childIndex;
            }
        }
    }

    protected void processFacets(FacesContext context, PhaseId phaseId) {
        this.setRowKey(null);
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    facet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    facet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    facet.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    protected void processColumnFacets(FacesContext context, PhaseId phaseId) {
        this.setRowKey(null);
        for (UIComponent child : this.getChildren()) {
            UIColumn column;
            if (!(child instanceof UIColumn) || !child.isRendered() || (column = (UIColumn)child).getFacetCount() <= 0) continue;
            for (UIComponent columnFacet : column.getFacets().values()) {
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    columnFacet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    columnFacet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    columnFacet.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    protected void processColumnChildren(FacesContext context, PhaseId phaseId, String nodeKey) {
        this.setRowKey(nodeKey);
        if (nodeKey == null) {
            return;
        }
        for (UIComponent child : this.getChildren()) {
            if (!(child instanceof UIColumn) || !child.isRendered()) continue;
            for (UIComponent grandkid : child.getChildren()) {
                if (!grandkid.isRendered()) continue;
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    grandkid.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    grandkid.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    grandkid.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    private void saveDescendantState() {
        FacesContext context = FacesContext.getCurrentInstance();
        for (UIComponent child : this.getChildren()) {
            this.saveDescendantState(child, context);
        }
    }

    private void saveDescendantState(UIComponent component, FacesContext context) {
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            SavedState state = null;
            String clientId = component.getClientId(context);
            if (saved == null) {
                state = new SavedState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), clientId, (Object)state);
            }
            if (state == null && (state = (SavedState)saved.get(clientId)) == null) {
                state = new SavedState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), clientId, (Object)state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
        }
        for (UIComponent uiComponent : component.getChildren()) {
            this.saveDescendantState(uiComponent, context);
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.saveDescendantState(facet, context);
            }
        }
    }

    private void restoreDescendantState() {
        FacesContext context = FacesContext.getCurrentInstance();
        for (UIComponent child : this.getChildren()) {
            this.restoreDescendantState(child, context);
        }
    }

    private void restoreDescendantState(UIComponent component, FacesContext context) {
        String id = component.getId();
        component.setId(id);
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = (SavedState)saved.get(clientId);
            if (state == null) {
                state = new SavedState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
        }
        for (UIComponent kid : component.getChildren()) {
            this.restoreDescendantState(kid, context);
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.restoreDescendantState(facet, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        if (!this.isVisitable(context)) {
            return false;
        }
        FacesContext facesContext = context.getFacesContext();
        String oldRowKey = this.getRowKey();
        this.setRowKey(null);
        this.pushComponentToEL(facesContext, null);
        try {
            VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
            if (result == VisitResult.COMPLETE) {
                boolean bl = true;
                return bl;
            }
            if (result == VisitResult.ACCEPT && this.doVisitChildren(context)) {
                if (this.visitFacets(context, callback)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.visitNodes(context, callback)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.popComponentFromEL(facesContext);
            this.setRowKey(oldRowKey);
        }
        return false;
    }

    protected boolean doVisitChildren(VisitContext context) {
        Collection idsToVisit = context.getSubtreeIdsToVisit((UIComponent)this);
        return !idsToVisit.isEmpty();
    }

    protected boolean visitFacets(VisitContext context, VisitCallback callback) {
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                if (!facet.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean visitColumns(VisitContext context, VisitCallback callback, String rowKey) {
        this.setRowKey(rowKey);
        if (rowKey == null) {
            return false;
        }
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UIColumn) || !child.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean visitNodes(VisitContext context, VisitCallback callback) {
        TreeNode root = this.getValue();
        if (root != null && this.visitNode(context, callback, root, null)) {
            return true;
        }
        this.setRowKey(null);
        return false;
    }

    protected boolean visitNode(VisitContext context, VisitCallback callback, TreeNode treeNode, String rowKey) {
        if (this.visitColumns(context, callback, rowKey)) {
            return true;
        }
        if (treeNode.isExpanded() || treeNode.getParent() == null) {
            int childIndex = 0;
            Iterator<TreeNode> iterator = treeNode.getChildren().iterator();
            while (iterator.hasNext()) {
                String childRowKey;
                String string = childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + SEPARATOR + childIndex;
                if (this.visitNode(context, callback, iterator.next(), childRowKey)) {
                    return true;
                }
                ++childIndex;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        var,
        saved,
        value;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

