/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee.wizard;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MasterPanel
implements WizardDescriptor.Panel {
    private boolean valid;
    private EventListenerList listenerList;
    private boolean inNewProject;
    private WizardDescriptor wizardDesc;
    private String lastMsg;
    private boolean lastMsgInfoIconEnabled;
    private JButton addAllButton;
    private JButton addButton;
    private JLabel availableLabel;
    private JList availableList;
    private JScrollPane availablePane;
    private JComboBox connectionCombo;
    private JLabel connectionLabel;
    private JButton downButton;
    private JLabel includeLabel;
    private JList includeList;
    private JScrollPane includePane;
    private JPanel masterPanel;
    private JButton removeAllButton;
    private JButton removeButton;
    private JComboBox tableCombo;
    private JLabel tableLabel;
    private JButton upButton;

    public MasterPanel(boolean inNewProject) {
        this.inNewProject = inNewProject;
    }

    private void initGUI() {
        this.initComponents();
        this.initLists();
        DatabaseExplorerUIs.connect((JComboBox)this.connectionCombo, (ConnectionManager)ConnectionManager.getDefault());
    }

    private void initLists() {
        this.availableList.setModel(new DefaultListModel());
        this.includeList.setModel(new DefaultListModel());
        ListDataListener listener = new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Object source = e.getSource();
                if (source == MasterPanel.this.availableList.getModel()) {
                    MasterPanel.this.addAllButton.setEnabled(MasterPanel.this.availableList.getModel().getSize() != 0);
                } else if (source == MasterPanel.this.includeList.getModel()) {
                    boolean empty = MasterPanel.this.includeList.getModel().getSize() == 0;
                    MasterPanel.this.removeAllButton.setEnabled(!empty);
                    MasterPanel.this.setValid(!empty);
                }
            }
        };
        this.availableList.getModel().addListDataListener(listener);
        this.includeList.getModel().addListDataListener(listener);
    }

    private void initComponents() {
        this.masterPanel = new JPanel();
        this.connectionCombo = new JComboBox();
        this.connectionLabel = new JLabel();
        this.tableLabel = new JLabel();
        this.tableCombo = new JComboBox();
        this.availableLabel = new JLabel();
        this.availablePane = new JScrollPane();
        this.availableList = new JList();
        this.addAllButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.includePane = new JScrollPane();
        this.includeList = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.includeLabel = new JLabel();
        FormListener formListener = new FormListener();
        this.masterPanel.setName(NbBundle.getMessage(MasterPanel.class, (String)"TITLE_MasterPanel"));
        this.connectionCombo.addActionListener(formListener);
        this.connectionLabel.setLabelFor(this.connectionCombo);
        Mnemonics.setLocalizedText((JLabel)this.connectionLabel, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_DatabaseConnection"));
        this.tableLabel.setLabelFor(this.tableCombo);
        Mnemonics.setLocalizedText((JLabel)this.tableLabel, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_DatabaseTable"));
        this.tableCombo.setEnabled(false);
        this.tableCombo.setRenderer(J2EEUtils.DBColumnInfo.getRenderer());
        this.tableCombo.addActionListener(formListener);
        this.availableLabel.setLabelFor(this.availableList);
        Mnemonics.setLocalizedText((JLabel)this.availableLabel, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_AvailableColumns"));
        this.availableList.addListSelectionListener(formListener);
        this.availablePane.setViewportView(this.availableList);
        this.availableList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_AvailableColumns_ACSD"));
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterAddAll"));
        this.addAllButton.setEnabled(false);
        this.addAllButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterAdd"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterRemove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeAllButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterRemoveAll"));
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(formListener);
        this.includeList.addListSelectionListener(formListener);
        this.includePane.setViewportView(this.includeList);
        this.includeList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_ColumnsToInclude_ACSD"));
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/up.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterUp"));
        this.upButton.setEnabled(false);
        this.upButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.upButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.upButton.addActionListener(formListener);
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/j2ee/resources/down.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterDown"));
        this.downButton.setEnabled(false);
        this.downButton.setHorizontalAlignment(10);
        if (!Utilities.isMac()) {
            this.downButton.setMargin(new Insets(2, 6, 2, 6));
        }
        this.downButton.addActionListener(formListener);
        this.includeLabel.setLabelFor(this.includeList);
        Mnemonics.setLocalizedText((JLabel)this.includeLabel, (String)NbBundle.getMessage(MasterPanel.class, (String)"LBL_ColumnsToInclude"));
        GroupLayout masterPanelLayout = new GroupLayout(this.masterPanel);
        this.masterPanel.setLayout(masterPanelLayout);
        masterPanelLayout.setHorizontalGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(masterPanelLayout.createSequentialGroup().addContainerGap().addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(masterPanelLayout.createSequentialGroup().addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.connectionLabel).addComponent(this.tableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableCombo, 0, 290, Short.MAX_VALUE).addComponent(this.connectionCombo, 0, 290, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, masterPanelLayout.createSequentialGroup().addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.availablePane, -1, 152, Short.MAX_VALUE).addComponent(this.availableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addButton, -1, -1, Short.MAX_VALUE).addComponent(this.addAllButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeAllButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(masterPanelLayout.createSequentialGroup().addComponent(this.includePane, -1, 150, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.upButton, -1, -1, Short.MAX_VALUE).addComponent(this.downButton, -1, -1, Short.MAX_VALUE))).addComponent(this.includeLabel)))).addContainerGap()));
        masterPanelLayout.linkSize(0, this.addAllButton, this.addButton, this.downButton, this.removeAllButton, this.removeButton, this.upButton);
        masterPanelLayout.setVerticalGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(masterPanelLayout.createSequentialGroup().addContainerGap().addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectionLabel).addComponent(this.connectionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tableLabel).addComponent(this.tableCombo, -2, -1, -2)).addGap(10, 10, 10).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.availableLabel).addComponent(this.includeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.availablePane, 0, 152, Short.MAX_VALUE).addComponent(this.includePane, 0, 152, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, masterPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addAllButton).addComponent(this.upButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(masterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeButton).addComponent(this.downButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 15, Short.MAX_VALUE))).addContainerGap()));
        this.connectionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_DatabaseConnection_ACSD"));
        this.tableCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_DatabaseTable_ACSD"));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterAddAll_ACSD"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterAdd_ACSD"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterRemove_ACSD"));
        this.removeAllButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterRemoveAll_ACSD"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterUp_ACSD"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"LBL_MasterDown_ACSD"));
        this.masterPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MasterPanel.class, (String)"TITLE_MasterPanel"));
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.includeList.getModel();
        int index = this.includeList.getSelectedIndex();
        Object item = model.remove(index);
        model.add(index + 1, item);
        this.includeList.setSelectedIndex(index + 1);
        this.includeList.ensureIndexIsVisible(index + 1);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.includeList.getModel();
        int index = this.includeList.getSelectedIndex();
        Object item = model.remove(index);
        model.add(index - 1, item);
        this.includeList.setSelectedIndex(index - 1);
        this.includeList.ensureIndexIsVisible(index - 1);
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        MasterPanel.moveListItems(this.includeList, this.availableList, false);
        this.showMsg("MSG_AtLeastOneColumnIncluded");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        MasterPanel.moveListItems(this.includeList, this.availableList, true);
        if (this.includeList.getModel().getSize() == 0) {
            this.showMsg("MSG_AtLeastOneColumnIncluded");
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        MasterPanel.moveListItems(this.availableList, this.includeList, true);
        this.hideMsg();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        MasterPanel.moveListItems(this.availableList, this.includeList, false);
        this.hideMsg();
    }

    private void includeListValueChanged(ListSelectionEvent evt) {
        int[] index = this.includeList.getSelectedIndices();
        boolean single = index.length == 1;
        this.upButton.setEnabled(single && index[0] != 0);
        this.downButton.setEnabled(single && index[0] != this.includeList.getModel().getSize() - 1);
        boolean any = index.length > 0;
        this.removeButton.setEnabled(any);
        if (any) {
            this.availableList.clearSelection();
        }
    }

    private void availableListValueChanged(ListSelectionEvent evt) {
        boolean enabled = this.availableList.getSelectedIndex() != -1;
        this.addButton.setEnabled(enabled);
        if (enabled) {
            this.includeList.clearSelection();
        }
    }

    private void tableComboActionPerformed(ActionEvent evt) {
        Connection con;
        J2EEUtils.DBColumnInfo table = this.getTable();
        DatabaseConnection connection = this.getConnection();
        Connection connection2 = con = connection == null || table == null || !table.isValid() ? null : connection.getJDBCConnection();
        if (table != null) {
            if (!table.isValid()) {
                this.showMsg("MSG_MasterInvalidTableSelected");
            } else {
                this.hideMsg();
            }
        }
        try {
            DefaultListModel model = (DefaultListModel)this.availableList.getModel();
            model.clear();
            model = (DefaultListModel)this.includeList.getModel();
            model.clear();
            if (con != null) {
                ResultSet rs = con.getMetaData().getColumns(con.getCatalog(), connection.getSchema(), table.getName(), "%");
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    model.addElement(columnName);
                }
                rs.close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
        }
    }

    private void connectionComboActionPerformed(ActionEvent evt) {
        DatabaseConnection connection = this.getConnection();
        if (connection != null) {
            this.hideMsg();
            Connection con = J2EEUtils.establishConnection(connection);
            if (con == null) {
                return;
            }
            this.fillTableCombo(connection);
        } else {
            this.fillTableCombo(null);
        }
    }

    private DatabaseConnection getConnection() {
        Object selItem = this.connectionCombo.getSelectedItem();
        return selItem instanceof DatabaseConnection ? (DatabaseConnection)selItem : null;
    }

    private J2EEUtils.DBColumnInfo getTable() {
        return (J2EEUtils.DBColumnInfo)this.tableCombo.getSelectedItem();
    }

    private List getSelectedColumns() {
        DefaultListModel model = (DefaultListModel)this.includeList.getModel();
        return Arrays.asList(model.toArray());
    }

    private void fillTableCombo(DatabaseConnection connection) {
        DefaultComboBoxModel<J2EEUtils.DBColumnInfo> model = new DefaultComboBoxModel<J2EEUtils.DBColumnInfo>();
        int invalidCount = 0;
        if (connection != null) {
            for (J2EEUtils.DBColumnInfo tableName : J2EEUtils.tableNamesForConnection(connection)) {
                if (!tableName.isValid()) {
                    ++invalidCount;
                }
                model.addElement(tableName);
            }
        }
        this.tableCombo.setModel(model);
        this.tableCombo.setEnabled(this.tableCombo.getModel().getSize() != 0);
        this.tableCombo.setSelectedItem(this.tableCombo.getSelectedItem());
        if (connection != null) {
            if (model.getSize() == 0) {
                this.showMsg("MSG_MasterDBWithoutTables");
            } else if (invalidCount == model.getSize()) {
                this.showMsg("MSG_MasterDBWithoutTablesWithPrimaryKeys");
            } else {
                this.hideMsg();
            }
        }
    }

    private static void moveListItems(JList fromList, JList toList, boolean selected) {
        DefaultListModel fromModel = (DefaultListModel)fromList.getModel();
        DefaultListModel toModel = (DefaultListModel)toList.getModel();
        if (selected) {
            int i;
            int[] index = fromList.getSelectedIndices();
            for (i = 0; i < index.length; ++i) {
                Object item = fromModel.getElementAt(index[i]);
                toModel.addElement(item);
            }
            for (i = index.length - 1; i >= 0; --i) {
                fromModel.removeElementAt(index[i]);
            }
        } else {
            Enumeration items = fromModel.elements();
            while (items.hasMoreElements()) {
                toModel.addElement(items.nextElement());
            }
            fromModel.clear();
        }
    }

    public Component getComponent() {
        if (this.masterPanel == null) {
            this.initGUI();
        }
        return this.masterPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("gui.masterdetail-wizard.master");
    }

    public void readSettings(Object settings) {
        this.wizardDesc = (WizardDescriptor)settings;
        boolean valid = true;
        if (!this.inNewProject && settings instanceof TemplateWizard) {
            try {
                TemplateWizard wizard = (TemplateWizard)settings;
                DataFolder folder = wizard.getTargetFolder();
                FileObject fob = folder.getPrimaryFile();
                ClassPath cp = ClassPath.getClassPath((FileObject)fob, (String)"classpath/source");
                String name = cp.getResourceName(fob).trim();
                boolean bl = valid = name.length() != 0;
                if (!valid) {
                    this.showMsg("MSG_MasterDefaultPackage");
                } else {
                    FileObject root = cp.findOwnerRoot(fob);
                    URL[] urls = UnitTestForSourceQuery.findSources((FileObject)root);
                    if (urls.length != 0) {
                        this.showMsg("MSG_MasterTestPackage");
                        valid = false;
                    }
                }
                Project project = FileOwnerQuery.getOwner((FileObject)fob);
                if (project.getLookup().lookup(PersistenceLocationProvider.class) == null) {
                    this.showMsg("MSG_MasterNoProvider");
                    valid = false;
                }
            }
            catch (IOException ioex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ioex.getMessage(), ioex);
            }
        }
        this.connectionCombo.setEnabled(valid);
        if (!valid) {
            this.setValid(false);
        } else if (this.connectionCombo.getSelectedItem() == null) {
            this.showMsg("MSG_MasterDefaultConnection", true);
        }
        if (this.lastMsg != null) {
            this.showMsg(this.lastMsg, this.lastMsgInfoIconEnabled);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wizard = (WizardDescriptor)settings;
        wizard.putProperty("connection", (Object)this.getConnection());
        J2EEUtils.DBColumnInfo table = this.getTable();
        if (table != null) {
            wizard.putProperty("master", (Object)table.getName());
        }
        wizard.putProperty("masterColumns", (Object)this.getSelectedColumns());
    }

    public boolean isValid() {
        return this.valid;
    }

    void setValid(boolean valid) {
        if (valid == this.valid) {
            return;
        }
        this.valid = valid;
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, listener);
        }
    }

    private void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent e = null;
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (e == null) {
                e = new ChangeEvent(this);
            }
            listeners[i].stateChanged(e);
        }
    }

    private void showMsg(String msg) {
        this.showMsg(msg, false);
    }

    private void showMsg(String msg, boolean showInfoIcon) {
        this.lastMsg = msg;
        this.lastMsgInfoIconEnabled = showInfoIcon;
        if (this.wizardDesc != null) {
            if (msg != null) {
                msg = NbBundle.getMessage(this.getClass(), (String)msg);
            }
            if (showInfoIcon) {
                this.wizardDesc.putProperty("WizardPanel_infoMessage", (Object)msg);
            } else {
                this.wizardDesc.putProperty("WizardPanel_errorMessage", (Object)msg);
            }
        }
    }

    private void hideMsg() {
        this.showMsg(null, true);
    }

    private class FormListener
    implements ActionListener,
    ListSelectionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == MasterPanel.this.connectionCombo) {
                MasterPanel.this.connectionComboActionPerformed(evt);
            } else if (evt.getSource() == MasterPanel.this.tableCombo) {
                MasterPanel.this.tableComboActionPerformed(evt);
            } else if (evt.getSource() == MasterPanel.this.addAllButton) {
                MasterPanel.this.addAllButtonActionPerformed(evt);
            } else if (evt.getSource() == MasterPanel.this.addButton) {
                MasterPanel.this.addButtonActionPerformed(evt);
            } else if (evt.getSource() == MasterPanel.this.removeButton) {
                MasterPanel.this.removeButtonActionPerformed(evt);
            } else if (evt.getSource() == MasterPanel.this.removeAllButton) {
                MasterPanel.this.removeAllButtonActionPerformed(evt);
            } else if (evt.getSource() == MasterPanel.this.upButton) {
                MasterPanel.this.upButtonActionPerformed(evt);
            } else if (evt.getSource() == MasterPanel.this.downButton) {
                MasterPanel.this.downButtonActionPerformed(evt);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getSource() == MasterPanel.this.availableList) {
                MasterPanel.this.availableListValueChanged(evt);
            } else if (evt.getSource() == MasterPanel.this.includeList) {
                MasterPanel.this.includeListValueChanged(evt);
            }
        }
    }
}

