/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints.support;

import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.jackpot.spi.PatternConvertor;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.providers.spi.Trigger;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.MessageImpl;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchUtilities;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.spiimpl.batch.Scopes;
import org.netbeans.modules.java.hints.spiimpl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.spiimpl.pm.PatternCompiler;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class TransformationSupport {
    private String jackpotPattern;
    private Transformer transformer;
    private AtomicBoolean cancel = new AtomicBoolean();

    private TransformationSupport(String jackpotPattern, Transformer transformer) {
        this.jackpotPattern = jackpotPattern;
        this.transformer = transformer;
    }

    @NonNull
    public static TransformationSupport create(@NonNull String jackpotPattern) {
        return new TransformationSupport(jackpotPattern, null);
    }

    @NonNull
    public static TransformationSupport create(@NonNull String inputJackpotPattern, @NonNull Transformer t) {
        return new TransformationSupport(inputJackpotPattern, t);
    }

    @NonNull
    public TransformationSupport setCancel(@NonNull AtomicBoolean cancel) {
        this.cancel = cancel;
        return this;
    }

    @NonNull
    public Collection<? extends ModificationResult> processAllProjects() {
        if (this.transformer != null) {
            return TransformationSupport.performTransformation(this.jackpotPattern, this.transformer, this.cancel);
        }
        return TransformationSupport.performTransformation(this.jackpotPattern, this.cancel);
    }

    public void transformTreePath(@NonNull WorkingCopy workingCopy, @NonNull TreePath treePath) {
        if (this.transformer != null) {
            throw new UnsupportedOperationException("Not implemented yet");
        }
        TransformationSupport.performTransformation(workingCopy, treePath, this.jackpotPattern, this.cancel);
    }

    private static void performTransformation(WorkingCopy workingCopy, TreePath on, String jackpotPattern, AtomicBoolean cancel) {
        HintsInvoker inv = new HintsInvoker((CompilationInfo)workingCopy, cancel);
        Iterable<? extends HintDescription> hints = PatternConvertor.create(jackpotPattern);
        Map<HintDescription, List<ErrorDescription>> computeHints = inv.computeHints((CompilationInfo)workingCopy, on, false, hints, new ArrayList());
        if (computeHints == null || cancel.get()) {
            return;
        }
        ArrayList errs = new ArrayList();
        for (Map.Entry<HintDescription, List<ErrorDescription>> entry : computeHints.entrySet()) {
            errs.addAll(entry.getValue());
        }
        LinkedList problems = new LinkedList();
        try {
            if (BatchUtilities.applyFixes(workingCopy, Collections.<Project, Set<String>>emptyMap(), errs, null, new ArrayList(), problems)) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!problems.isEmpty()) {
            throw new IllegalStateException(((MessageImpl)problems.get((int)0)).text);
        }
    }

    private static Collection<? extends ModificationResult> performTransformation(String jackpotPattern, AtomicBoolean cancel) {
        LinkedList problems = new LinkedList();
        BatchSearch.BatchResult batchResult = BatchSearch.findOccurrences(PatternConvertor.create(jackpotPattern), Scopes.allOpenedProjectsScope());
        return BatchUtilities.applyFixes(batchResult, new ProgressHandleWrapper(1, 1), cancel, problems);
    }

    private static Collection<? extends ModificationResult> performTransformation(String inputJackpotPattern, final Transformer transformer, AtomicBoolean cancel) {
        ArrayList<HintDescription> descriptions = new ArrayList<HintDescription>();
        for (HintDescription hintDescription : PatternConvertor.create(inputJackpotPattern)) {
            final String triggerPattern = ((Trigger.PatternDescription)hintDescription.getTrigger()).getPattern();
            descriptions.add(HintDescriptionFactory.create().setTrigger(hintDescription.getTrigger()).setWorker(new HintDescription.Worker(){

                @Override
                public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
                    final HashMap<String, TypeMirrorHandle> constraintsHandles = new HashMap<String, TypeMirrorHandle>();
                    for (Map.Entry<String, TypeMirror> c : ctx.getConstraints().entrySet()) {
                        constraintsHandles.put(c.getKey(), TypeMirrorHandle.create((TypeMirror)c.getValue()));
                    }
                    Fix fix = new JavaFix(ctx.getInfo(), ctx.getPath()){

                        @Override
                        protected String getText() {
                            return "";
                        }

                        @Override
                        protected void performRewrite(JavaFix.TransformationContext ctx) {
                            WorkingCopy wc = ctx.getWorkingCopy();
                            HashMap<String, TypeMirror> constraints = new HashMap<String, TypeMirror>();
                            for (Map.Entry c : constraintsHandles.entrySet()) {
                                constraints.put((String)c.getKey(), ((TypeMirrorHandle)c.getValue()).resolve((CompilationInfo)wc));
                            }
                            Pattern pattern = PatternCompiler.compile((CompilationInfo)wc, triggerPattern, constraints, Collections.emptyList());
                            Collection occurrence = Matcher.create((CompilationInfo)wc).setTreeTopSearch().setSearchRoot(ctx.getPath()).match(pattern);
                            assert (occurrence.size() == 1);
                            transformer.transform(wc, (Occurrence)occurrence.iterator().next());
                        }
                    }.toEditorFix();
                    return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)"", Collections.singletonList(fix), (FileObject)ctx.getInfo().getFileObject(), (int)0, (int)0));
                }
            }).produce());
        }
        BatchSearch.BatchResult batchResult = BatchSearch.findOccurrences(descriptions, Scopes.allOpenedProjectsScope());
        return BatchUtilities.applyFixes(batchResult, new ProgressHandleWrapper(1, 1), cancel, new ArrayList());
    }

    private static Collection<? extends ModificationResult> performTransformation(String inputJackpotPattern, final String transformationJackpotPattern, AtomicBoolean cancel) {
        return TransformationSupport.performTransformation(inputJackpotPattern, new Transformer(){

            @Override
            public void transform(WorkingCopy copy, Occurrence occurrence) {
                try {
                    Fix toFix = TransformationSupport.rewriteFix((CompilationInfo)copy, "whatever", occurrence.getOccurrenceRoot(), transformationJackpotPattern, occurrence.getVariables(), occurrence.getMultiVariables(), occurrence.getVariables2Names(), Collections.emptyMap(), Collections.emptyMap(), new String[0]);
                    TransformationSupport.process(((JavaFixImpl)toFix).jf, copy, false, null, new ArrayList());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }, cancel);
    }

    private static ChangeInfo process(JavaFix jf, WorkingCopy wc, boolean canShowUI, Map<FileObject, byte[]> resourceContent, Collection<? super RefactoringElementImplementation> fileChanges) throws Exception {
        return JavaFixImpl.Accessor.INSTANCE.process(jf, wc, canShowUI, resourceContent, fileChanges);
    }

    private static Fix rewriteFix(CompilationInfo info, String displayName, TreePath what, String to, Map<String, TreePath> parameters, Map<String, Collection<? extends TreePath>> parametersMulti, Map<String, String> parameterNames, Map<String, TypeMirror> constraints, Map<String, String> options, String ... imports) {
        return JavaFixImpl.Accessor.INSTANCE.rewriteFix(info, displayName, what, to, parameters, parametersMulti, parameterNames, constraints, options, imports);
    }

    public static interface Transformer {
        public void transform(WorkingCopy var1, Occurrence var2);
    }
}

