/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints.support;

import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.Parameters;

public final class FixFactory {
    private FixFactory() {
    }

    public static final Fix addModifiersFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> toAdd, String text) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"toAdd", toAdd);
        Parameters.notNull((CharSequence)"text", (Object)text);
        return FixFactory.changeModifiersFix(compilationInfo, treePath, toAdd, Collections.<Modifier>emptySet(), text);
    }

    public static final Fix removeModifiersFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> toRemove, String text) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"toRemove", toRemove);
        Parameters.notNull((CharSequence)"text", (Object)text);
        return FixFactory.changeModifiersFix(compilationInfo, treePath, Collections.<Modifier>emptySet(), toRemove, text);
    }

    public static final Fix changeModifiersFix(CompilationInfo compilationInfo, TreePath treePath, Set<Modifier> toAdd, Set<Modifier> toRemove, String text) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"toAdd", toAdd);
        Parameters.notNull((CharSequence)"toRemove", toRemove);
        Parameters.notNull((CharSequence)"text", (Object)text);
        if (treePath.getLeaf().getKind() != Tree.Kind.MODIFIERS) {
            return null;
        }
        return new ChangeModifiersFixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), toAdd, toRemove, text).toEditorFix();
    }

    private static final class ChangeModifiersFixImpl
    extends JavaFix {
        private final TreePathHandle modsHandle;
        private final Set<Modifier> toAdd;
        private final Set<Modifier> toRemove;
        private final String text;

        public ChangeModifiersFixImpl(TreePathHandle modsHandle, Set<Modifier> toAdd, Set<Modifier> toRemove, String text) {
            super(modsHandle);
            this.modsHandle = modsHandle;
            this.toAdd = toAdd;
            this.toRemove = toRemove;
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            ModifiersTree mt = (ModifiersTree)path.getLeaf();
            EnumSet<Modifier> modifiers = mt.getFlags().isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(mt.getFlags());
            modifiers.addAll(this.toAdd);
            modifiers.removeAll(this.toRemove);
            ModifiersTree newMod = wc.getTreeMaker().Modifiers(modifiers, mt.getAnnotations());
            wc.rewrite((Tree)mt, (Tree)newMod);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChangeModifiersFixImpl other = (ChangeModifiersFixImpl)obj;
            if (!(this.modsHandle == other.modsHandle || this.modsHandle != null && this.modsHandle.equals((Object)other.modsHandle))) {
                return false;
            }
            if (!(this.toAdd == other.toAdd || this.toAdd != null && ((Object)this.toAdd).equals(other.toAdd))) {
                return false;
            }
            return this.toRemove == other.toRemove || this.toRemove != null && ((Object)this.toRemove).equals(other.toRemove);
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + (this.modsHandle != null ? this.modsHandle.hashCode() : 0);
            hash = 71 * hash + (this.toAdd != null ? ((Object)this.toAdd).hashCode() : 0);
            hash = 71 * hash + (this.toRemove != null ? ((Object)this.toRemove).hashCode() : 0);
            return hash;
        }
    }
}

