/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.analysis.api.CodeAnalysis;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.Hacks;
import org.netbeans.modules.java.hints.spiimpl.SPIAccessor;
import org.netbeans.modules.java.hints.spiimpl.SyntheticFix;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.Bundle;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class ErrorDescriptionFactory {
    private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.ANNOTATION_TYPE, new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.METHOD, Tree.Kind.VARIABLE});

    private ErrorDescriptionFactory() {
    }

    public static ErrorDescription forTree(HintContext context, TreePath tree, String text, Fix ... fixes) {
        return ErrorDescriptionFactory.forTree(context, tree.getLeaf(), text, fixes);
    }

    public static ErrorDescription forTree(HintContext context, Tree tree, String text, Fix ... fixes) {
        int end;
        int start;
        if (context.getHintMetadata().kind == Hint.Kind.INSPECTION) {
            start = (int)context.getInfo().getTrees().getSourcePositions().getStartPosition(context.getInfo().getCompilationUnit(), tree);
            end = (int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree);
        } else {
            start = end = context.getCaretLocation();
        }
        if (start != -1 && end != -1) {
            LazyFixList fixesForED = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.lazyListForFixes(ErrorDescriptionFactory.resolveDefaultFixes(context, fixes));
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((String)("text/x-java:" + context.getHintMetadata().id), (Severity)context.getSeverity(), (String)text, (CharSequence)context.getHintMetadata().description, (LazyFixList)fixesForED, (FileObject)context.getInfo().getFileObject(), (int)start, (int)end);
        }
        return null;
    }

    public static ErrorDescription forSpan(HintContext context, int start, int end, String text, Fix ... fixes) {
        if (context.getHintMetadata().kind != Hint.Kind.INSPECTION) {
            start = end = context.getCaretLocation();
        }
        if (start != -1 && end != -1) {
            LazyFixList fixesForED = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.lazyListForFixes(ErrorDescriptionFactory.resolveDefaultFixes(context, fixes));
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((String)("text/x-java:" + context.getHintMetadata().id), (Severity)context.getSeverity(), (String)text, (CharSequence)context.getHintMetadata().description, (LazyFixList)fixesForED, (FileObject)context.getInfo().getFileObject(), (int)start, (int)end);
        }
        return null;
    }

    public static ErrorDescription forName(HintContext context, TreePath tree, String text, Fix ... fixes) {
        return ErrorDescriptionFactory.forName(context, tree.getLeaf(), text, fixes);
    }

    public static ErrorDescription forName(HintContext context, Tree tree, String text, Fix ... fixes) {
        int[] span = context.getHintMetadata().kind == Hint.Kind.INSPECTION ? ErrorDescriptionFactory.computeNameSpan(tree, context) : new int[]{context.getCaretLocation(), context.getCaretLocation()};
        if (span != null && span[0] != -1 && span[1] != -1) {
            LazyFixList fixesForED = org.netbeans.spi.editor.hints.ErrorDescriptionFactory.lazyListForFixes(ErrorDescriptionFactory.resolveDefaultFixes(context, fixes));
            return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((String)("text/x-java:" + context.getHintMetadata().id), (Severity)context.getSeverity(), (String)text, (CharSequence)context.getHintMetadata().description, (LazyFixList)fixesForED, (FileObject)context.getInfo().getFileObject(), (int)span[0], (int)span[1]);
        }
        return null;
    }

    private static int[] computeNameSpan(Tree tree, HintContext context) {
        switch (tree.getKind()) {
            case METHOD: {
                return context.getInfo().getTreeUtilities().findNameSpan((MethodTree)tree);
            }
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return context.getInfo().getTreeUtilities().findNameSpan((ClassTree)tree);
            }
            case VARIABLE: {
                return context.getInfo().getTreeUtilities().findNameSpan((VariableTree)tree);
            }
            case MEMBER_SELECT: {
                MemberSelectTree mst = (MemberSelectTree)tree;
                int[] span = context.getInfo().getTreeUtilities().findNameSpan(mst);
                if (span == null) {
                    int end = (int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree);
                    span = new int[]{end - mst.getIdentifier().length(), end};
                }
                return span;
            }
            case METHOD_INVOCATION: {
                return ErrorDescriptionFactory.computeNameSpan(((MethodInvocationTree)tree).getMethodSelect(), context);
            }
        }
        int start = (int)context.getInfo().getTrees().getSourcePositions().getStartPosition(context.getInfo().getCompilationUnit(), tree);
        if (StatementTree.class.isAssignableFrom(tree.getKind().asInterface()) && tree.getKind() != Tree.Kind.EXPRESSION_STATEMENT && tree.getKind() != Tree.Kind.BLOCK) {
            TokenSequence ts = context.getInfo().getTokenHierarchy().tokenSequence();
            ts.move(start);
            if (ts.moveNext()) {
                return new int[]{ts.offset(), ts.offset() + ts.token().length()};
            }
        }
        return new int[]{start, (int)context.getInfo().getTrees().getSourcePositions().getEndPosition(context.getInfo().getCompilationUnit(), tree)};
    }

    static List<Fix> resolveDefaultFixes(HintContext ctx, Fix ... provided) {
        LinkedList<Fix> auxiliaryFixes = new LinkedList<Fix>();
        HintMetadata hm = SPIAccessor.getINSTANCE().getHintMetadata(ctx);
        if (hm != null) {
            LinkedHashSet<String> suppressWarningsKeys = new LinkedHashSet<String>();
            for (String string : hm.suppressWarnings) {
                if (string == null || string.length() == 0) break;
                suppressWarningsKeys.add(string);
            }
            auxiliaryFixes.add(new DisableConfigure(hm, true));
            auxiliaryFixes.add(new DisableConfigure(hm, false));
            if (hm.kind == Hint.Kind.INSPECTION) {
                auxiliaryFixes.add(new InspectFix(hm, false));
                if (!hm.options.contains((Object)HintMetadata.Options.QUERY)) {
                    auxiliaryFixes.add(new InspectFix(hm, true));
                }
            }
            if (!suppressWarningsKeys.isEmpty()) {
                auxiliaryFixes.addAll(ErrorDescriptionFactory.createSuppressWarnings(ctx.getInfo(), ctx.getPath(), suppressWarningsKeys.toArray(new String[0])));
            }
            LinkedList<Fix> result = new LinkedList<Fix>();
            for (Fix f : provided != null ? provided : new Fix[]{}) {
                if (f == null) continue;
                result.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes((Fix)f, auxiliaryFixes));
            }
            if (result.isEmpty()) {
                result.add(org.netbeans.spi.editor.hints.ErrorDescriptionFactory.attachSubfixes((Fix)new TopLevelConfigureFix(hm), auxiliaryFixes));
            }
            return result;
        }
        return Arrays.asList(provided);
    }

    static Fix createSuppressWarningsFix(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"keys", (Object)keys);
        if (keys.length == 0) {
            throw new IllegalArgumentException("key must not be empty");
        }
        if (!ErrorDescriptionFactory.isSuppressWarningsSupported(compilationInfo)) {
            return null;
        }
        while (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)treePath.getLeaf().getKind())) {
            treePath = treePath.getParentPath();
        }
        if (treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            return new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), compilationInfo.getFileObject(), keys);
        }
        return null;
    }

    static List<Fix> createSuppressWarnings(CompilationInfo compilationInfo, TreePath treePath, String ... keys) {
        Parameters.notNull((CharSequence)"compilationInfo", (Object)compilationInfo);
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"keys", (Object)keys);
        if (keys.length == 0) {
            throw new IllegalArgumentException("key must not be empty");
        }
        Fix f = ErrorDescriptionFactory.createSuppressWarningsFix(compilationInfo, treePath, keys);
        if (f != null) {
            return Collections.singletonList(f);
        }
        return Collections.emptyList();
    }

    private static boolean isSuppressWarningsSupported(CompilationInfo info) {
        if (info.getElements().getTypeElement("java.lang.SuppressWarnings") == null) {
            return false;
        }
        return info.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0;
    }

    private static final class FixImpl
    implements Fix,
    SyntheticFix {
        private String[] keys;
        private TreePathHandle handle;
        private FileObject file;

        public FixImpl(TreePathHandle handle, FileObject file, String ... keys) {
            this.keys = keys;
            this.handle = handle;
            this.file = file;
        }

        public String getText() {
            StringBuilder keyNames = new StringBuilder();
            for (int i = 0; i < this.keys.length; ++i) {
                String string = this.keys[i];
                keyNames.append(string);
                if (i >= this.keys.length - 1) continue;
                keyNames.append(", ");
            }
            return NbBundle.getMessage(ErrorDescriptionFactory.class, (String)"LBL_FIX_Suppress_Waning", (Object)keyNames.toString());
        }

        public ChangeInfo implement() throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws IOException {
                    TreePath path;
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    for (path = FixImpl.this.handle.resolve((CompilationInfo)copy); path != null && path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && !DECLARATION.contains((Object)path.getLeaf().getKind()); path = path.getParentPath()) {
                    }
                    if (path.getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
                        return;
                    }
                    Tree top = path.getLeaf();
                    ModifiersTree modifiers = null;
                    switch (top.getKind()) {
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            modifiers = ((ClassTree)top).getModifiers();
                            break;
                        }
                        case METHOD: {
                            modifiers = ((MethodTree)top).getModifiers();
                            break;
                        }
                        case VARIABLE: {
                            modifiers = ((VariableTree)top).getModifiers();
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled Tree.Kind";
                            break;
                        }
                    }
                    if (modifiers == null) {
                        return;
                    }
                    TypeElement el = copy.getElements().getTypeElement("java.lang.SuppressWarnings");
                    if (el == null) {
                        return;
                    }
                    ExpressionTree[] keyLiterals = new LiteralTree[FixImpl.this.keys.length];
                    for (int i = 0; i < FixImpl.this.keys.length; ++i) {
                        keyLiterals[i] = copy.getTreeMaker().Literal((Object)FixImpl.this.keys[i]);
                    }
                    ModifiersTree nueMods = GeneratorUtilities.get((WorkingCopy)copy).appendToAnnotationValue(modifiers, el, "value", keyLiterals);
                    copy.rewrite((Tree)modifiers, (Tree)nueMods);
                }
            }).commit();
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FixImpl other = (FixImpl)obj;
            if (!Arrays.deepEquals(this.keys, other.keys)) {
                return false;
            }
            if (!(this.handle == other.handle || this.handle != null && this.handle.equals((Object)other.handle))) {
                return false;
            }
            return this.file == other.file || this.file != null && this.file.equals(other.file);
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + Arrays.deepHashCode(this.keys);
            hash = 79 * hash + (this.handle != null ? this.handle.hashCode() : 0);
            hash = 79 * hash + (this.file != null ? this.file.hashCode() : 0);
            return hash;
        }
    }

    private static class InspectFix
    implements Fix,
    SyntheticFix {
        @NonNull
        private final HintMetadata metadata;
        private final boolean transform;

        InspectFix(@NonNull HintMetadata metadata, boolean transform) {
            this.metadata = metadata;
            this.transform = transform;
        }

        public String getText() {
            return this.transform ? Bundle.DN_InspectAndTransform() : Bundle.DN_Inspect();
        }

        public ChangeInfo implement() throws Exception {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (InspectFix.this.transform) {
                        Hacks.InspectAndTransformOpener o = (Hacks.InspectAndTransformOpener)Lookup.getDefault().lookup(Hacks.InspectAndTransformOpener.class);
                        if (o != null) {
                            o.openIAT(InspectFix.this.metadata);
                        }
                    } else {
                        CodeAnalysis.open((Analyzer.WarningDescription)Analyzer.WarningDescription.create((String)("text/x-java:" + ((InspectFix)InspectFix.this).metadata.id), null, null, null));
                    }
                }
            });
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InspectFix other = (InspectFix)obj;
            if (!(this.metadata == other.metadata || this.metadata != null && this.metadata.equals(other.metadata))) {
                return false;
            }
            return this.transform == other.transform;
        }

        public int hashCode() {
            int hash = 7;
            hash = 43 * hash + (this.metadata != null ? this.metadata.hashCode() : 0);
            hash = 43 * hash + (this.transform ? 1 : 0);
            return hash;
        }
    }

    private static final class TopLevelConfigureFix
    extends DisableConfigure
    implements EnhancedFix {
        public TopLevelConfigureFix(@NonNull HintMetadata metadata) {
            super(metadata, false);
        }

        public CharSequence getSortText() {
            return "\uffffzz";
        }
    }

    private static class DisableConfigure
    implements Fix,
    SyntheticFix {
        @NonNull
        private final HintMetadata metadata;
        private final boolean disable;

        DisableConfigure(@NonNull HintMetadata metadata, boolean disable) {
            this.metadata = metadata;
            this.disable = disable;
        }

        public String getText() {
            String key;
            String displayName = this.metadata.displayName;
            switch (this.metadata.kind) {
                case INSPECTION: {
                    key = this.disable ? "FIX_DisableHint" : "FIX_ConfigureHint";
                    break;
                }
                case ACTION: {
                    key = this.disable ? "FIX_DisableSuggestion" : "FIX_ConfigureSuggestion";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return NbBundle.getMessage(ErrorDescriptionFactory.class, (String)key, (Object)displayName);
        }

        public ChangeInfo implement() throws Exception {
            if (this.disable) {
                HintsSettings.setEnabled(this.metadata, false);
            } else {
                OptionsDisplayer.getDefault().open("Editor/Hints/text/x-java/" + this.metadata.id);
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DisableConfigure other = (DisableConfigure)obj;
            if (!(this.metadata == other.metadata || this.metadata != null && this.metadata.equals(other.metadata))) {
                return false;
            }
            return this.disable == other.disable;
        }

        public int hashCode() {
            int hash = 7;
            hash = 43 * hash + (this.metadata != null ? this.metadata.hashCode() : 0);
            hash = 43 * hash + (this.disable ? 1 : 0);
            return hash;
        }
    }
}

