/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.options;

import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public class HintsSettings {
    static final String ENABLED_KEY = "enabled";
    static final String OLD_SEVERITY_KEY = "severity";
    static final String NEW_SEVERITY_KEY = "hintSeverity";
    static final String IN_TASK_LIST_KEY = "inTaskList";
    private static final String DEFAULT_PROFILE = "default";
    private static Map<String, Preferences> preferencesOverride;
    private static final ChangeSupport cs;
    private static final String PREFERENCES_LOCATION = "org/netbeans/modules/java/hints";

    private HintsSettings() {
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static boolean isEnabled(HintMetadata hint) {
        Preferences p = HintsSettings.getPreferences(hint.id, HintsSettings.getCurrentProfileId());
        return HintsSettings.isEnabled(hint, p);
    }

    public static boolean isShowInTaskList(HintMetadata hint) {
        Preferences p = HintsSettings.getPreferences(hint.id, HintsSettings.getCurrentProfileId());
        return HintsSettings.isShowInTaskList(hint, p);
    }

    public static boolean isEnabled(HintMetadata metadata, Preferences preferences) {
        return HintsSettings.isEnabled(preferences, metadata.enabled);
    }

    public static boolean isEnabled(Preferences preferences, boolean enabledDefault) {
        boolean useDefault = preferences.parent() == null || DEFAULT_PROFILE.equals(preferences.parent().name());
        return preferences.getBoolean(ENABLED_KEY, useDefault && enabledDefault);
    }

    public static boolean isEnabledWithDefault(Preferences preferences, boolean enabledDefault) {
        return preferences.getBoolean(ENABLED_KEY, enabledDefault);
    }

    public static void setEnabled(HintMetadata metadata, boolean value) {
        HintsSettings.setEnabled(HintsSettings.getPreferences(metadata.id, HintsSettings.getCurrentProfileId()), value);
        HintsSettings.fireChangeEvent();
    }

    public static void setEnabled(Preferences p, boolean value) {
        p.putBoolean(ENABLED_KEY, value);
    }

    public static boolean isShowInTaskList(HintMetadata hint, Preferences preferences) {
        return preferences.getBoolean(IN_TASK_LIST_KEY, hint.showInTaskList);
    }

    public static void setShowInTaskList(Preferences p, boolean value) {
        p.putBoolean(IN_TASK_LIST_KEY, value);
    }

    public static Severity getSeverity(@NullAllowed HintMetadata hint, @NonNull Preferences preferences) {
        String s = preferences.get(NEW_SEVERITY_KEY, null);
        if (s != null) {
            return Severity.valueOf((String)s);
        }
        s = preferences.get(OLD_SEVERITY_KEY, null);
        if (s == null) {
            return hint != null ? hint.severity : null;
        }
        if ("ERROR".equals(s)) {
            return Severity.ERROR;
        }
        if ("WARNING".equals(s)) {
            return Severity.VERIFIER;
        }
        if ("CURRENT_LINE_WARNING".equals(s)) {
            return Severity.HINT;
        }
        return hint != null ? hint.severity : null;
    }

    public static void setSeverity(Preferences p, Severity severity) {
        p.put(NEW_SEVERITY_KEY, severity.name());
    }

    public static void setPreferencesOverride(Map<String, Preferences> preferencesOverride) {
        HintsSettings.preferencesOverride = preferencesOverride;
    }

    public static Map<String, Preferences> getPreferencesOverride() {
        return preferencesOverride;
    }

    public static void addChangeListener(ChangeListener l) {
        cs.addChangeListener(l);
    }

    public static void removeChangeListener(ChangeListener l) {
        cs.removeChangeListener(l);
    }

    public static void fireChangeEvent() {
        cs.fireChange();
    }

    public static Preferences getPreferences(String hintId, String profile) {
        Preferences p;
        Map<String, Preferences> override = HintsSettings.getPreferencesOverride();
        if (override != null && (p = override.get(hintId)) != null) {
            return p;
        }
        profile = profile == null ? HintsSettings.getCurrentProfileId() : profile;
        return NbPreferences.root().node(PREFERENCES_LOCATION).node(profile).node(hintId);
    }

    static {
        cs = new ChangeSupport(HintsSettings.class);
    }
}

