/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.providers.spi.ClassPathBasedHintProvider;
import org.netbeans.modules.java.hints.providers.spi.ElementBasedHintProvider;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.providers.spi.HintProvider;
import org.netbeans.modules.java.hints.spiimpl.RulesManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Lookup;

public class RulesManagerImpl
extends RulesManager {
    private final Map<HintMetadata, Collection<HintDescription>> globalHints = new HashMap<HintMetadata, Collection<HintDescription>>();

    public RulesManagerImpl() {
        this.reload();
    }

    @Override
    public void reload() {
        this.globalHints.clear();
        for (HintProvider p : Lookup.getDefault().lookupAll(HintProvider.class)) {
            Map<HintMetadata, ? extends Collection<? extends HintDescription>> pHints = p.computeHints();
            if (pHints == null) continue;
            for (Map.Entry<HintMetadata, ? extends Collection<? extends HintDescription>> e : pHints.entrySet()) {
                this.globalHints.put(e.getKey(), new ArrayList<HintDescription>(e.getValue()));
            }
        }
    }

    @Override
    public Map<HintMetadata, ? extends Collection<? extends HintDescription>> readHints(CompilationInfo info, Collection<? extends ClassPath> from, AtomicBoolean cancel) {
        HashMap<HintMetadata, Collection<HintDescription>> result = new HashMap<HintMetadata, Collection<HintDescription>>(this.globalHints);
        if (info != null) {
            for (ElementBasedHintProvider provider : Lookup.getDefault().lookupAll(ElementBasedHintProvider.class)) {
                RulesManagerImpl.sortByMetadata(provider.computeHints(info), result);
            }
        }
        if (from == null) {
            if (info != null) {
                ClasspathInfo cpInfo = info.getClasspathInfo();
                LinkedList<? extends ClassPath> cps = new LinkedList<ClassPath>();
                cps.add(cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT));
                cps.add(cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE));
                cps.add(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE));
                from = cps;
            } else {
                from = Collections.emptyList();
            }
        }
        ClassPath compound = ClassPathSupport.createProxyClassPath((ClassPath[])from.toArray(new ClassPath[0]));
        for (ClassPathBasedHintProvider p : Lookup.getDefault().lookupAll(ClassPathBasedHintProvider.class)) {
            RulesManagerImpl.sortByMetadata(p.computeHints(compound), result);
        }
        return result;
    }

    public static void sortByMetadata(Collection<? extends HintDescription> listedHints, Map<HintMetadata, Collection<HintDescription>> into) {
        for (HintDescription hintDescription : listedHints) {
            Collection<HintDescription> h = into.get(hintDescription.getMetadata());
            if (h == null) {
                h = new ArrayList<HintDescription>();
                into.put(hintDescription.getMetadata(), h);
            }
            h.add(hintDescription);
        }
    }
}

