/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.java.hints.providers.spi.PositionRefresherHelper;
import org.netbeans.spi.editor.hints.Context;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.PositionRefresher;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaHintsPositionRefresher
implements PositionRefresher {
    private static final Logger LOG = Logger.getLogger(JavaHintsPositionRefresher.class.getName());

    public Map<String, List<ErrorDescription>> getErrorDescriptionsAt(final Context context, final Document doc) {
        final ArrayList refreshers = new ArrayList(MimeLookup.getLookup((String)"text/x-java").lookupAll(PositionRefresherHelper.class));
        Iterator it = refreshers.iterator();
        while (it.hasNext()) {
            PositionRefresherHelper h = (PositionRefresherHelper)it.next();
            if (h.upToDateCheck(context, doc)) {
                LOG.log(Level.FINE, "Not computing warnings for {0}, results are up-to-date.", h.getKey());
                it.remove();
                continue;
            }
            LOG.log(Level.FINE, "Will compute warnings for {0}, results not up-to-date.", h.getKey());
        }
        if (refreshers.isEmpty()) {
            return Collections.emptyMap();
        }
        final JavaSource js = JavaSource.forDocument((Document)doc);
        if (js == null) {
            LOG.log(Level.FINE, "No JavaSource associated to: {0}", new Object[]{doc, doc.getProperty("stream")});
            return Collections.emptyMap();
        }
        final HashMap<String, List<ErrorDescription>> eds = new HashMap<String, List<ErrorDescription>>();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    js.runUserActionTask((Task)new RefreshTask(eds, refreshers, context, doc), true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        ProgressUtils.runOffEventDispatchThread((Runnable)r, (String)NbBundle.getMessage(JavaHintsPositionRefresher.class, (String)"Refresh_hints"), (AtomicBoolean)context.getCancel(), (boolean)false);
        return eds;
    }

    private class RefreshTask
    implements Task<CompilationController> {
        private final Map<String, List<ErrorDescription>> eds;
        private final List<PositionRefresherHelper> refreshers;
        private final Context ctx;
        private final Document doc;

        public RefreshTask(Map<String, List<ErrorDescription>> eds, List<PositionRefresherHelper> refreshers, Context ctx, Document doc) {
            this.eds = eds;
            this.refreshers = refreshers;
            this.ctx = ctx;
            this.doc = doc;
        }

        public void run(CompilationController controller) throws Exception {
            controller.toPhase(JavaSource.Phase.RESOLVED);
            Document doc = controller.getDocument();
            if (doc == null) {
                return;
            }
            for (PositionRefresherHelper h : this.refreshers) {
                if (this.ctx.isCanceled()) {
                    return;
                }
                this.eds.put(h.getKey(), h.getErrorDescriptionsAt((CompilationInfo)controller, this.ctx, doc));
            }
        }
    }
}

