/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.providers.code;

import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.java.hints.providers.code.FSWrapper;
import org.netbeans.modules.java.hints.providers.code.ReflectiveCustomizerProvider;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.providers.spi.HintProvider;
import org.netbeans.modules.java.hints.providers.spi.Trigger;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.BooleanOption;
import org.netbeans.spi.java.hints.ConstraintVariableType;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.TriggerPattern;
import org.netbeans.spi.java.hints.TriggerPatterns;
import org.netbeans.spi.java.hints.TriggerTreeKind;
import org.netbeans.spi.java.hints.UseOptions;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;

public class CodeHintProviderImpl
implements HintProvider {
    private static final Logger LOG = Logger.getLogger(WorkerImpl.class.getName());

    @Override
    public Map<HintMetadata, ? extends Collection<? extends HintDescription>> computeHints() {
        return this.computeHints(CodeHintProviderImpl.findLoader(), "META-INF/nb-hints/hints");
    }

    private Map<HintMetadata, ? extends Collection<? extends HintDescription>> computeHints(ClassLoader l, String path) {
        HashMap<HintMetadata, Collection<HintDescription>> result = new HashMap<HintMetadata, Collection<HintDescription>>();
        for (FSWrapper.ClassWrapper classWrapper : FSWrapper.listClasses()) {
            CodeHintProviderImpl.processClass(classWrapper, result);
        }
        return result;
    }

    static ClassLoader findLoader() {
        ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (l == null) {
            return CodeHintProviderImpl.class.getClassLoader();
        }
        return l;
    }

    public static void processClass(FSWrapper.ClassWrapper clazz, Map<HintMetadata, Collection<HintDescription>> result) throws SecurityException {
        String id;
        Hint metadata = clazz.getAnnotation(Hint.class);
        if (metadata == null) {
            metadata = new EmptyHintMetadataDescription();
        }
        if ((id = metadata.id()) == null || id.length() == 0) {
            id = clazz.getName();
        }
        HintMetadata hm = CodeHintProviderImpl.fromAnnotation(id, clazz, null, metadata);
        for (FSWrapper.MethodWrapper methodWrapper : clazz.getMethods()) {
            HintMetadata localMetadata;
            Hint localMetadataAnnotation = methodWrapper.getAnnotation(Hint.class);
            if (localMetadataAnnotation != null) {
                String localID = localMetadataAnnotation.id();
                if (localID == null || localID.length() == 0) {
                    localID = clazz.getName() + "." + methodWrapper.getName();
                }
                localMetadata = CodeHintProviderImpl.fromAnnotation(localID, clazz, methodWrapper, localMetadataAnnotation);
            } else {
                localMetadata = hm;
            }
            CodeHintProviderImpl.processMethod(result, methodWrapper, localMetadata);
        }
    }

    private static HintMetadata fromAnnotation(String id, FSWrapper.ClassWrapper clazz, FSWrapper.MethodWrapper method, Hint metadata) {
        HintMetadata hm = HintMetadata.Builder.create(id).setDescription(metadata.displayName(), metadata.description()).setCategory(metadata.category()).setEnabled(metadata.enabled()).setSeverity(metadata.severity()).setKind(metadata.hintKind()).setCustomizerProvider(CodeHintProviderImpl.createCustomizerProvider(clazz, method, id, metadata)).addSuppressWarnings(metadata.suppressWarnings()).addOptions(HintMetadata.Options.fromHintOptions(metadata.options()).toArray(new HintMetadata.Options[0])).build();
        return hm;
    }

    private static CustomizerProvider createCustomizerProvider(FSWrapper.ClassWrapper clazz, FSWrapper.MethodWrapper method, String id, Hint hint) {
        Class<? extends CustomizerProvider> customizerClass = hint.customizerProvider();
        if (customizerClass != CustomizerProvider.class) {
            return new DelegatingCustomizerProvider(customizerClass);
        }
        HashSet<String> allowedOptions = null;
        if (method != null) {
            UseOptions useOptions = method.getAnnotation(UseOptions.class);
            if (useOptions == null) {
                return null;
            }
            allowedOptions = new HashSet<String>(Arrays.asList(useOptions.value()));
        }
        ArrayList<ReflectiveCustomizerProvider.OptionDescriptor> declarativeOptions = new ArrayList<ReflectiveCustomizerProvider.OptionDescriptor>();
        for (FSWrapper.FieldWrapper fieldWrapper : clazz.getFields()) {
            String key;
            BooleanOption option = fieldWrapper.getAnnotation(BooleanOption.class);
            if (option == null || (key = fieldWrapper.getConstantValue()) == null || allowedOptions != null && !allowedOptions.contains(key)) continue;
            declarativeOptions.add(new ReflectiveCustomizerProvider.OptionDescriptor(key, option.defaultValue(), option.displayName(), option.tooltip()));
        }
        return !declarativeOptions.isEmpty() ? new ReflectiveCustomizerProvider(clazz.getName(), id, declarativeOptions) : null;
    }

    static void processMethod(Map<HintMetadata, Collection<HintDescription>> hints, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        CodeHintProviderImpl.processTreeKindHint(hints, m, metadata);
        CodeHintProviderImpl.processPatternHint(hints, m, metadata);
    }

    private static void processTreeKindHint(Map<HintMetadata, Collection<HintDescription>> hints, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        TriggerTreeKind kindTrigger = m.getAnnotation(TriggerTreeKind.class);
        if (kindTrigger == null) {
            return;
        }
        WorkerImpl w = new WorkerImpl(m.getClazz().getName(), m.getName());
        EnumSet<Tree.Kind> kinds = EnumSet.noneOf(Tree.Kind.class);
        kinds.addAll(Arrays.asList(kindTrigger.value()));
        CodeHintProviderImpl.addHint(hints, metadata, HintDescriptionFactory.create().setTrigger(new Trigger.Kinds(kinds)).setWorker(w).setMetadata(metadata).produce());
    }

    private static void processPatternHint(Map<HintMetadata, Collection<HintDescription>> hints, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        TriggerPattern patternTrigger = m.getAnnotation(TriggerPattern.class);
        if (patternTrigger != null) {
            CodeHintProviderImpl.processPatternHint(hints, patternTrigger, m, metadata);
            return;
        }
        TriggerPatterns patternTriggers = m.getAnnotation(TriggerPatterns.class);
        if (patternTriggers != null) {
            for (TriggerPattern pattern : patternTriggers.value()) {
                CodeHintProviderImpl.processPatternHint(hints, pattern, m, metadata);
            }
            return;
        }
    }

    private static void processPatternHint(Map<HintMetadata, Collection<HintDescription>> hints, TriggerPattern patternTrigger, FSWrapper.MethodWrapper m, HintMetadata metadata) {
        String pattern = patternTrigger.value();
        HashMap<String, String> constraints = new HashMap<String, String>();
        for (ConstraintVariableType c : patternTrigger.constraints()) {
            constraints.put(c.variable(), c.type());
        }
        Trigger.PatternDescription pd = Trigger.PatternDescription.create(pattern, constraints, new String[0]);
        CodeHintProviderImpl.addHint(hints, metadata, HintDescriptionFactory.create().setTrigger(pd).setWorker(new WorkerImpl(m.getClazz().getName(), m.getName())).setMetadata(metadata).produce());
    }

    private static void addHint(Map<HintMetadata, Collection<HintDescription>> hints, HintMetadata metadata, HintDescription hint) {
        Collection<HintDescription> list = hints.get(metadata);
        if (list == null) {
            list = new LinkedList<HintDescription>();
            hints.put(metadata, list);
        }
        list.add(hint);
    }

    private static final class DelegatingCustomizerProvider
    implements CustomizerProvider {
        private final Class<? extends CustomizerProvider> component;

        public DelegatingCustomizerProvider(Class<? extends CustomizerProvider> component) {
            this.component = component;
        }

        @Override
        public JComponent getCustomizer(Preferences prefs) {
            try {
                return this.component.newInstance().getCustomizer(prefs);
            }
            catch (SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InstantiationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return new JPanel();
        }
    }

    private static final class EmptyHintMetadataDescription
    implements Hint {
        private static final String[] EMPTY_SW = new String[0];
        private static final Hint.Options[] EMPTY_OPTIONS = new Hint.Options[0];

        private EmptyHintMetadataDescription() {
        }

        @Override
        public String id() {
            return "";
        }

        @Override
        public String category() {
            return "general";
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public Severity severity() {
            return Severity.VERIFIER;
        }

        @Override
        public String[] suppressWarnings() {
            return EMPTY_SW;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Hint.class;
        }

        @Override
        public Class<? extends CustomizerProvider> customizerProvider() {
            return CustomizerProvider.class;
        }

        @Override
        public Hint.Kind hintKind() {
            return Hint.Kind.INSPECTION;
        }

        @Override
        public Hint.Options[] options() {
            return EMPTY_OPTIONS;
        }

        @Override
        public String displayName() {
            return "";
        }

        @Override
        public String description() {
            return "";
        }
    }

    static final class WorkerImpl
    implements HintDescription.Worker {
        private final String className;
        private final String methodName;
        private final AtomicReference<Method> methodRef = new AtomicReference();

        public WorkerImpl(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        @Override
        public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
            try {
                Object result;
                Method method = this.methodRef.get();
                if (method == null) {
                    method = this.getMethod();
                    this.methodRef.set(method);
                }
                if ((result = method.invoke(null, ctx)) == null) {
                    return null;
                }
                if (result instanceof Iterable) {
                    LinkedList<ErrorDescription> out = new LinkedList<ErrorDescription>();
                    for (ErrorDescription ed : NbCollections.iterable((Iterator)NbCollections.checkedIteratorByFilter(((Iterable)result).iterator(), ErrorDescription.class, (boolean)false))) {
                        out.add(ed);
                    }
                    return out;
                }
                if (result instanceof ErrorDescription) {
                    return Collections.singletonList((ErrorDescription)result);
                }
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                LOG.log(Level.INFO, null, ex);
                Exceptions.printStackTrace((Throwable)ex.getCause());
            }
            return null;
        }

        Method getMethod() throws NoSuchMethodException, ClassNotFoundException {
            return FSWrapper.resolveMethod(this.className, this.methodName);
        }
    }
}

