/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.validation;

import java.util.ArrayList;
import java.util.List;

public final class ValidationResult {
    private final List<Message> errors = new ArrayList<Message>();
    private final List<Message> warnings = new ArrayList<Message>();

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Message> getErrors() {
        return new ArrayList<Message>(this.errors);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<Message> getWarnings() {
        return new ArrayList<Message>(this.warnings);
    }

    void addError(Message error) {
        this.errors.add(error);
    }

    void addWarning(Message warning) {
        this.warnings.add(warning);
    }

    void merge(ValidationResult otherResult) {
        this.errors.addAll(otherResult.errors);
        this.warnings.addAll(otherResult.warnings);
    }

    public static final class Message {
        private final String source;
        private final String message;

        public Message(String source, String message) {
            this.source = source;
            this.message = message;
        }

        public String getSource() {
            return this.source;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "ValidationMessage{source=" + this.source + ", message=" + this.message + '}';
        }
    }
}

