/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.validation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.web.clientproject.validation.Bundle;
import org.netbeans.modules.web.clientproject.validation.ProjectFoldersValidator;
import org.netbeans.modules.web.clientproject.validation.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class RunProjectValidator {
    public static final String START_FILE = "start.file";
    public static final String PROJECT_URL = "project.url";
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public RunProjectValidator validateStartFile(File siteRootFolder, File startFile) {
        ValidationResult foldersResult = new ProjectFoldersValidator().validateSiteRootFolder(siteRootFolder).getResult();
        this.result.merge(foldersResult);
        if (this.result.hasErrors()) {
            return this;
        }
        if (startFile == null || !startFile.isFile()) {
            this.result.addError(new ValidationResult.Message(START_FILE, Bundle.RunProjectValidator_error_startFile_invalid()));
            return this;
        }
        if (!FileUtil.isParentOf((FileObject)FileUtil.toFileObject((File)siteRootFolder), (FileObject)FileUtil.toFileObject((File)startFile))) {
            this.result.addError(new ValidationResult.Message(START_FILE, Bundle.RunProjectValidator_error_startFile_notUnderSiteRoot()));
        }
        return this;
    }

    public RunProjectValidator validateProjectUrl(String projectUrl) {
        if (projectUrl == null || projectUrl.isEmpty()) {
            this.result.addError(new ValidationResult.Message(PROJECT_URL, Bundle.RunProjectValidator_error_projectUrl_missing()));
            return this;
        }
        if (!(projectUrl.startsWith("http://") || projectUrl.startsWith("https://") || projectUrl.startsWith("file://"))) {
            this.result.addError(new ValidationResult.Message(PROJECT_URL, Bundle.RunProjectValidator_error_projectUrl_invalidProtocol()));
            return this;
        }
        try {
            URL url = new URL(projectUrl);
            String host = url.getHost();
            if (host == null || host.isEmpty()) {
                this.result.addError(new ValidationResult.Message(PROJECT_URL, Bundle.RunProjectValidator_error_projectUrl_invalid()));
            }
        }
        catch (MalformedURLException ex) {
            this.result.addError(new ValidationResult.Message(PROJECT_URL, Bundle.RunProjectValidator_error_projectUrl_invalid()));
        }
        return this;
    }
}

