/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.validation;

import java.io.File;
import org.netbeans.modules.web.clientproject.validation.Bundle;
import org.netbeans.modules.web.clientproject.validation.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ProjectFoldersValidator {
    public static final String SITE_ROOT_FOLDER = "site.root.folder";
    public static final String TEST_FOLDER = "test.folder";
    public static final String CONFIG_FOLDER = "config.folder";
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public ProjectFoldersValidator validate(File projectDirectory, File siteRootFolder, File testFolder, File configFolder) {
        this.validateSiteRootFolder(siteRootFolder);
        this.validateTestFolder(projectDirectory, testFolder);
        this.validateConfigFolder(projectDirectory, configFolder);
        return this;
    }

    public ProjectFoldersValidator validateSiteRootFolder(File siteRootFolder) {
        if (siteRootFolder == null || !siteRootFolder.isDirectory()) {
            this.result.addError(new ValidationResult.Message(SITE_ROOT_FOLDER, Bundle.ProjectFoldersValidator_error_siteRoot_invalid()));
        }
        return this;
    }

    ProjectFoldersValidator validateTestFolder(File projectDirectory, File testFolder) {
        this.validateProjectFolder(projectDirectory, testFolder, TEST_FOLDER, Bundle.ProjectFoldersValidator_error_test_invalid(), Bundle.ProjectFoldersValidator_error_test_notUnderProjectDir());
        return this;
    }

    ProjectFoldersValidator validateConfigFolder(File projectDirectory, File configFolder) {
        this.validateProjectFolder(projectDirectory, configFolder, CONFIG_FOLDER, Bundle.ProjectFoldersValidator_error_config_invalid(), Bundle.ProjectFoldersValidator_error_config_notUnderProjectDir());
        return this;
    }

    private void validateProjectFolder(File projectDirectory, File folder, String source, String invalidFolderMessage, String notInProjectMessage) {
        if (folder == null) {
            return;
        }
        if (!folder.isDirectory()) {
            this.result.addError(new ValidationResult.Message(source, invalidFolderMessage));
            return;
        }
        if (!FileUtil.isParentOf((FileObject)FileUtil.toFileObject((File)projectDirectory), (FileObject)FileUtil.toFileObject((File)folder))) {
            this.result.addError(new ValidationResult.Message(source, notInProjectMessage));
        }
    }
}

