/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.util;

import java.io.File;

public final class ValidationUtilities {
    private static final char[] INVALID_FILENAME_CHARS = new char[]{'/', '\\', '|', ':', '*', '?', '\"', '<', '>'};

    private ValidationUtilities() {
    }

    public static boolean isValidFilename(String filename) {
        assert (filename != null);
        if (filename.trim().length() == 0) {
            return false;
        }
        for (char ch : INVALID_FILENAME_CHARS) {
            if (filename.indexOf(ch) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFilename(File file) {
        assert (file != null);
        for (File tmp = file; tmp != null && !tmp.exists(); tmp = tmp.getParentFile()) {
            if (tmp.isAbsolute() && tmp.getParentFile() == null) {
                return true;
            }
            if (ValidationUtilities.isValidFilename(tmp.getName())) continue;
            return false;
        }
        return true;
    }
}

