/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class FileUtilities {
    private static final Logger LOGGER = Logger.getLogger(FileUtilities.class.getName());
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String XHTML_MIME_TYPE = "text/xhtml";
    private static final String CSS_MIME_TYPE = "text/css";

    private FileUtilities() {
    }

    public static boolean isHtmlFile(FileObject file) {
        String mimeType = FileUtil.getMIMEType((FileObject)file, (String[])new String[]{HTML_MIME_TYPE, XHTML_MIME_TYPE});
        return HTML_MIME_TYPE.equals(mimeType) || XHTML_MIME_TYPE.equals(mimeType);
    }

    public static boolean isCssFile(FileObject file) {
        return CSS_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)file, (String[])new String[]{CSS_MIME_TYPE}));
    }

    public static void cleanupFolder(FileObject fileObject) throws IOException {
        for (FileObject child : fileObject.getChildren()) {
            child.delete();
        }
    }

    public static void moveContent(FileObject source, FileObject target) throws IOException {
        for (FileObject child : source.getChildren()) {
            String newName;
            FileObject newChild = target.getFileObject(child.getNameExt());
            if (newChild == null) {
                FileUtil.moveFile((FileObject)child, (FileObject)target, (String)child.getName());
                continue;
            }
            if (newChild.isFolder()) {
                FileUtilities.moveContent(child, newChild);
                child.delete();
                continue;
            }
            int i = 0;
            while (target.getFileObject(newName = child.getName() + "_" + i++) != null) {
            }
            FileUtil.moveFile((FileObject)child, (FileObject)target, (String)newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnZipEntries(@NonNull File zipFile, @NonNull ZipEntryTask entryTask, @NullAllowed ZipEntryFilter entryFilter) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                boolean accept = true;
                if (entryFilter != null) {
                    accept = entryFilter.accept(zipEntry);
                }
                if (!accept) continue;
                entryTask.run(zipEntry);
                InputStream inputStream = zip.getInputStream(zipEntry);
                try {
                    entryTask.run(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    public static List<String> listZipFiles(@NonNull File zipFile, @NonNull ZipEntryFilter entryFilter) throws IOException {
        assert (zipFile != null);
        assert (entryFilter != null);
        final ArrayList<String> files = new ArrayList<String>();
        FileUtilities.runOnZipEntries(zipFile, new ZipEntryTask(){

            @Override
            public void run(ZipEntry zipEntry) {
                files.add(zipEntry.getName());
            }

            @Override
            public void run(InputStream zipEntryInputStream) {
            }
        }, entryFilter);
        return files;
    }

    public static List<String> listJsFilesFromZipFile(File zipFile) {
        try {
            return FileUtilities.listZipFiles(zipFile, new ZipEntryFilter(){

                @Override
                public boolean accept(ZipEntry zipEntry) {
                    return !zipEntry.isDirectory() && zipEntry.getName().toLowerCase().endsWith(".js");
                }
            });
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return Collections.emptyList();
        }
    }

    public static interface ZipEntryTask {
        public void run(ZipEntry var1);

        public void run(InputStream var1);
    }

    public static interface ZipEntryFilter {
        public boolean accept(ZipEntry var1);
    }
}

