/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.util;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.api.MissingLibResourceException;
import org.netbeans.modules.web.clientproject.api.WebClientLibraryManager;
import org.netbeans.modules.web.clientproject.ui.JavaScriptLibrarySelection;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.util.Bundle;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ClientSideProjectUtilities {
    private static final Logger LOGGER = Logger.getLogger(ClientSideProjectUtilities.class.getName());
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.web.clientproject");
    public static final Charset DEFAULT_PROJECT_CHARSET = ClientSideProjectUtilities.getDefaultProjectCharset();

    private ClientSideProjectUtilities() {
    }

    public static boolean isProject(File folder) {
        Project prj = null;
        boolean foundButBroken = false;
        try {
            prj = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)folder)));
        }
        catch (IOException ex) {
            foundButBroken = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return prj != null || foundButBroken;
    }

    public static AntProjectHelper setupProject(FileObject dirFO, String name) throws IOException {
        AntProjectHelper projectHelper = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.web.clientproject");
        ClientSideProjectUtilities.setProjectName(projectHelper, name);
        ClientSideProject project = (ClientSideProject)FileOwnerQuery.getOwner((FileObject)dirFO);
        ClientSideProjectProperties projectProperties = new ClientSideProjectProperties(project);
        projectProperties.setEncoding(DEFAULT_PROJECT_CHARSET.name());
        projectProperties.save();
        return projectHelper;
    }

    public static void initializeProject(@NonNull ClientSideProject project, @NonNull String siteRoot, @NullAllowed String test, @NullAllowed String config) throws IOException {
        File projectDirectory = FileUtil.toFile((FileObject)project.getProjectDirectory());
        assert (projectDirectory != null);
        assert (projectDirectory.isDirectory());
        ClientSideProjectUtilities.ensureDirectoryExists(PropertyUtils.resolveFile((File)projectDirectory, (String)siteRoot));
        if (test != null) {
            ClientSideProjectUtilities.ensureDirectoryExists(PropertyUtils.resolveFile((File)projectDirectory, (String)test));
        }
        if (config != null) {
            ClientSideProjectUtilities.ensureDirectoryExists(PropertyUtils.resolveFile((File)projectDirectory, (String)config));
        }
        ClientSideProjectProperties projectProperties = new ClientSideProjectProperties(project);
        projectProperties.setSiteRootFolder(siteRoot);
        projectProperties.setTestFolder(test);
        projectProperties.setConfigFolder(config);
        projectProperties.save();
    }

    private static void ensureDirectoryExists(File folder) throws IOException {
        if (!folder.isDirectory() && !folder.mkdirs()) {
            throw new IOException("Cannot create folder " + folder);
        }
    }

    public static void setProjectName(final AntProjectHelper projectHelper, final String name) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Element nameElement;
                Element data = projectHelper.getPrimaryConfigurationData(true);
                Document document = data.getOwnerDocument();
                NodeList nameList = data.getElementsByTagNameNS("http://www.netbeans.org/ns/clientside-project/1", "name");
                if (nameList.getLength() == 1) {
                    nameElement = (Element)nameList.item(0);
                    NodeList deadKids = nameElement.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameElement.removeChild(deadKids.item(0));
                    }
                } else {
                    nameElement = document.createElementNS("http://www.netbeans.org/ns/clientside-project/1", "name");
                    data.insertBefore(nameElement, data.getChildNodes().item(0));
                }
                nameElement.appendChild(document.createTextNode(name));
                projectHelper.putPrimaryConfigurationData(data, true);
            }
        });
    }

    public static SourceGroup[] getSourceGroups(Project project) {
        assert (project instanceof ClientSideProject) : "ClientSideProject project expected but got: " + project.getClass().getName();
        Sources sources = ProjectUtils.getSources((Project)project);
        ArrayList<SourceGroup> res = new ArrayList<SourceGroup>();
        res.addAll(Arrays.asList(sources.getSourceGroups("HTML5-Sources")));
        res.addAll(Arrays.asList(sources.getSourceGroups("HTML5-Tests")));
        res.addAll(Arrays.asList(sources.getSourceGroups("HTML5-Config")));
        return res.toArray(new SourceGroup[res.size()]);
    }

    public static SourceGroup[] getSourceGroups(Project project, String type) {
        Sources sources = ProjectUtils.getSources((Project)project);
        return sources.getSourceGroups(type);
    }

    public static FileObject[] getSourceObjects(Project project) {
        SourceGroup[] groups = ClientSideProjectUtilities.getSourceGroups(project);
        FileObject[] fileObjects = new FileObject[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            fileObjects[i] = groups[i].getRootFolder();
        }
        return fileObjects;
    }

    @CheckReturnValue
    public static List<JavaScriptLibrarySelection.SelectedLibrary> applyJsLibraries(List<JavaScriptLibrarySelection.SelectedLibrary> selectedLibraries, String jsLibFolder, FileObject siteRootDir, @NullAllowed ProgressHandle handle) throws IOException {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Must be run in a background thread");
        }
        ArrayList<JavaScriptLibrarySelection.SelectedLibrary> failed = new ArrayList<JavaScriptLibrarySelection.SelectedLibrary>(selectedLibraries.size());
        FileObject librariesRoot = null;
        for (JavaScriptLibrarySelection.SelectedLibrary selectedLibrary : selectedLibraries) {
            if (Thread.currentThread().isInterrupted()) break;
            if (selectedLibrary.isDefault()) continue;
            if (librariesRoot == null) {
                librariesRoot = FileUtil.createFolder((FileObject)siteRootDir, (String)jsLibFolder);
            }
            JavaScriptLibrarySelection.LibraryVersion libraryVersion = selectedLibrary.getLibraryVersion();
            Library library = libraryVersion.getLibrary();
            if (handle != null) {
                handle.progress(Bundle.ClientSideProjectUtilities_msg_downloadingJsLib(library.getProperties().get("displayname")));
            }
            try {
                WebClientLibraryManager.addLibraries((Library[])new Library[]{library}, (FileObject)librariesRoot, (String)libraryVersion.getType());
            }
            catch (MissingLibResourceException e) {
                LOGGER.log(Level.FINE, null, e);
                failed.add(selectedLibrary);
            }
        }
        return failed;
    }

    private static Charset getDefaultProjectCharset() {
        try {
            return Charset.forName("UTF-8");
        }
        catch (IllegalCharsetNameException exception) {
            LOGGER.log(Level.INFO, "UTF-8 charset not supported, falling back to the default charset.", exception);
        }
        catch (UnsupportedCharsetException exception) {
            LOGGER.log(Level.INFO, "UTF-8 charset not supported, falling back to the default charset.", exception);
        }
        return Charset.defaultCharset();
    }

    public static String[] splitPathAndFragment(String url) {
        int index = url.lastIndexOf(35);
        if (index != -1) {
            return new String[]{url.substring(0, index), url.substring(index)};
        }
        return new String[]{url, ""};
    }

    public static void logUsage(Class<? extends Object> srcClass, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle(srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        USG_LOGGER.log(logRecord);
    }
}

