/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.clientproject.util.FileUtilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class NewFileWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(NewFileWizardIterator.class.getName());
    private WizardDescriptor descriptor;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private int index;

    public void initialize(WizardDescriptor wizard) {
        this.descriptor = wizard;
        this.setTargetFolder();
        this.panels = this.getPanels();
        String[] beforeSteps = (String[])wizard.getProperty("WizardPanel_contentData");
        int beforeStepLength = beforeSteps.length - 1;
        String[] steps = this.createSteps(beforeSteps);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i + beforeStepLength - 1);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public Set<FileObject> instantiate() throws IOException {
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.descriptor);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.descriptor);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)dir);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        DataObject createdFile = dataTemplate.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.descriptor));
        return Collections.singleton(createdFile.getPrimaryFile());
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        Project project = Templates.getProject((WizardDescriptor)this.descriptor);
        SourceGroup[] groups = this.getSourceGroups(project, Templates.getTemplate((WizardDescriptor)this.descriptor));
        WizardDescriptor.Panel simpleTargetChooserPanel = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])groups).create();
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{simpleTargetChooserPanel};
        return panels;
    }

    private SourceGroup[] getSourceGroups(Project project, FileObject file) {
        SourceGroup[] groups = ClientSideProjectUtilities.getSourceGroups(project);
        if (!FileUtilities.isHtmlFile(file) && !FileUtilities.isCssFile(file)) {
            return groups;
        }
        ClientSideProject clientSideProject = this.getClientSideProject(project);
        if (clientSideProject == null) {
            return groups;
        }
        return ClientSideProjectUtilities.getSourceGroups(project, "HTML5-Sources");
    }

    private void setTargetFolder() {
        if (Templates.getTargetFolder((WizardDescriptor)this.descriptor) != null) {
            return;
        }
        Project project = Templates.getProject((WizardDescriptor)this.descriptor);
        if (project == null) {
            return;
        }
        ClientSideProject clientSideProject = this.getClientSideProject(project);
        if (clientSideProject == null) {
            return;
        }
        FileObject siteRoot = clientSideProject.getSiteRootFolder();
        if (siteRoot != null) {
            Templates.setTargetFolder((WizardDescriptor)this.descriptor, (FileObject)siteRoot);
        }
    }

    private String[] createSteps(String[] beforeSteps) {
        int beforeStepLength = beforeSteps.length - 1;
        String[] res = new String[beforeStepLength + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeStepLength ? beforeSteps[i] : this.panels[i - beforeStepLength].getComponent().getName();
        }
        return res;
    }

    private ClientSideProject getClientSideProject(Project project) {
        if (!(project instanceof ClientSideProject)) {
            LOGGER.log(Level.WARNING, "ClientSideProject expected but found {0}", project.getClass().getName());
            return null;
        }
        return (ClientSideProject)project;
    }
}

