/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.ui.JavaScriptLibrarySelection;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.ui.wizard.Bundle;
import org.netbeans.modules.web.common.api.Pair;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public class JavaScriptLibrarySelectionPanel
implements WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor> {
    static final Logger LOGGER = Logger.getLogger(JavaScriptLibrarySelectionPanel.class.getName());
    private final FileObject librariesFolder;
    private final LibrariesValidator librariesValidator = new LibrariesValidator();
    private volatile JavaScriptLibrarySelection javaScriptLibrarySelection;
    private volatile WizardDescriptor wizardDescriptor;
    volatile boolean asynchError = false;

    public JavaScriptLibrarySelectionPanel() {
        this.librariesFolder = this.createLibrariesFolder();
    }

    public JavaScriptLibrarySelection getComponent() {
        if (this.javaScriptLibrarySelection == null) {
            this.javaScriptLibrarySelection = new JavaScriptLibrarySelection(this.librariesValidator);
            this.javaScriptLibrarySelection.setAdditionalInfo(Bundle.JavaScriptLibrarySelectionPanel_jsLibs_info());
            this.javaScriptLibrarySelection.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JavaScriptLibrarySelectionPanel.this.asynchError = false;
                        }
                    });
                }
            });
        }
        return this.javaScriptLibrarySelection;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.web.clientproject.ui.wizard.JavaScriptLibrarySelectionPanel");
    }

    public void readSettings(WizardDescriptor settings) {
        this.asynchError = false;
        this.wizardDescriptor = settings;
        SiteTemplateImplementation siteTemplate = (SiteTemplateImplementation)this.wizardDescriptor.getProperty("SITE_TEMPLATE");
        Collection supportedLibraries = siteTemplate.supportedLibraries();
        this.getComponent().updateDefaultLibraries(supportedLibraries);
        this.librariesValidator.updateJsFilesFromTemplate(supportedLibraries);
        this.getComponent().updateFailedLibraries(Collections.<JavaScriptLibrarySelection.SelectedLibrary>emptyList());
    }

    public void storeSettings(WizardDescriptor settings) {
        this.wizardDescriptor.putProperty("LIBRARIES_FOLDER", (Object)this.librariesFolder);
        this.wizardDescriptor.putProperty("LIBRARIES_PATH", (Object)this.javaScriptLibrarySelection.getLibrariesFolder());
        this.wizardDescriptor.putProperty("LIBRARY_NAMES", (Object)ClientSideProjectProperties.createListOfJsLibraries(this.getComponent().getSelectedLibraries()));
    }

    public void prepareValidation() {
        this.getComponent().lockPanel();
    }

    /*
     * Exception decompiling
     */
    public void validate() throws WizardValidationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isValid() {
        if (this.asynchError) {
            return true;
        }
        String error = this.getComponent().getErrorMessage();
        if (error != null && !error.isEmpty()) {
            this.setErrorMessage(error);
            return false;
        }
        String warning = this.getComponent().getWarningMessage();
        if (warning != null && !warning.isEmpty()) {
            this.setErrorMessage(warning);
            return true;
        }
        this.setErrorMessage("");
        return true;
    }

    private void setErrorMessage(String message) {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.getComponent().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getComponent().removeChangeListener(listener);
    }

    public boolean isFinishPanel() {
        return true;
    }

    private FileObject createLibrariesFolder() {
        FileObject fo;
        File tmpDir;
        int i = 0;
        while ((tmpDir = new File(System.getProperty("java.io.tmpdir"), "netbeans-jslibs-" + i++)).isDirectory() || !tmpDir.mkdirs() || (fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)tmpDir))) == null || !fo.isValid()) {
        }
        return fo;
    }

    List<String> convertToStrings(List<JavaScriptLibrarySelection.SelectedLibrary> failedLibs) {
        ArrayList<String> result = new ArrayList<String>(failedLibs.size());
        for (JavaScriptLibrarySelection.SelectedLibrary library : failedLibs) {
            result.add(library.getLibraryVersion().getLibrary().getDisplayName());
        }
        return result;
    }

    private static final class LibrariesValidator
    implements JavaScriptLibrarySelection.JavaScriptLibrariesValidator {
        private final List<String> jsFilesFromTemplate = new CopyOnWriteArrayList<String>();

        private LibrariesValidator() {
        }

        public void updateJsFilesFromTemplate(Collection<String> jsFilesFromTemplate) {
            this.jsFilesFromTemplate.clear();
            this.jsFilesFromTemplate.addAll(jsFilesFromTemplate);
        }

        @Override
        public Pair<Set<JavaScriptLibrarySelection.SelectedLibrary>, String> validate(String librariesFolder, Set<JavaScriptLibrarySelection.SelectedLibrary> newLibraries) {
            if (newLibraries.isEmpty()) {
                return VALID_RESULT;
            }
            HashSet<JavaScriptLibrarySelection.SelectedLibrary> existing = new HashSet<JavaScriptLibrarySelection.SelectedLibrary>();
            for (JavaScriptLibrarySelection.SelectedLibrary selectedLibrary : newLibraries) {
                for (String filePath : selectedLibrary.getFilePaths()) {
                    for (String jsFileFromTemplate : this.jsFilesFromTemplate) {
                        if (!jsFileFromTemplate.endsWith(librariesFolder + "/" + filePath)) continue;
                        existing.add(selectedLibrary);
                    }
                }
            }
            if (!existing.isEmpty()) {
                return Pair.of(existing, (Object)Bundle.JavaScriptLibrarySelectionPanel_error_jsLibsAlreadyExist());
            }
            return VALID_RESULT;
        }
    }
}

