/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.clientproject.ui.wizard.Bundle;
import org.netbeans.modules.web.clientproject.ui.wizard.ClientSideProjectDetector;
import org.netbeans.modules.web.clientproject.ui.wizard.NewClientSideProject;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.clientproject.util.ValidationUtilities;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ExistingClientSideProject
extends JPanel {
    private static final long serialVersionUID = -4683211573157747L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    boolean fireChanges = true;
    String lastSiteRoot = "";
    String lastProjectName = "";
    volatile String configDir = null;
    volatile String testDir = null;
    private JButton projectDirectoryBrowseButton;
    private JLabel projectDirectoryLabel;
    private JTextField projectDirectoryTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JButton siteRootBrowseButton;
    private JLabel siteRootLabel;
    private JTextField siteRootTextField;

    public ExistingClientSideProject() {
        this.initComponents();
        this.initSiteRoot();
        this.initProjectName();
        this.initProjectDirectory();
    }

    private void initSiteRoot() {
        this.siteRootTextField.getDocument().addDocumentListener(new DefaultDocumentListener(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                ExistingClientSideProject.this.fireChanges = false;
                ExistingClientSideProject.this.updateProjectName();
                ExistingClientSideProject.this.updateProjectDirectory();
                ExistingClientSideProject.this.lastSiteRoot = ExistingClientSideProject.this.getSiteRoot();
                ExistingClientSideProject.this.detectClientSideProject(ExistingClientSideProject.this.lastSiteRoot);
                ExistingClientSideProject.this.fireChanges = true;
            }
        }));
    }

    private void initProjectName() {
        this.projectNameTextField.getDocument().addDocumentListener(new DefaultDocumentListener(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                ExistingClientSideProject.this.fireChanges = false;
                ExistingClientSideProject.this.updateProjectDirectoryName();
                ExistingClientSideProject.this.lastProjectName = ExistingClientSideProject.this.getProjectName();
                ExistingClientSideProject.this.fireChanges = true;
            }
        }));
    }

    private void initProjectDirectory() {
        this.projectDirectoryTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
    }

    public String getSiteRoot() {
        return this.siteRootTextField.getText().trim();
    }

    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    public String getProjectDirectory() {
        return this.projectDirectoryTextField.getText().trim();
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public String getTestDir() {
        return this.testDir;
    }

    public final void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getErrorMessage() {
        String error = this.validateSiteRoot();
        if (error != null) {
            return error;
        }
        error = this.validateProjectName();
        if (error != null) {
            return error;
        }
        error = this.validateProjectDirectory();
        if (error != null) {
            return error;
        }
        return null;
    }

    private String validateSiteRoot() {
        String siteRoot = this.getSiteRoot();
        if (siteRoot.isEmpty()) {
            return Bundle.ExistingClientSideProject_error_siteRoot_empty();
        }
        File siteRootDir = FileUtil.normalizeFile((File)new File(siteRoot).getAbsoluteFile());
        if (!siteRootDir.isDirectory()) {
            return Bundle.ExistingClientSideProject_error_siteRoot_invalid();
        }
        if (ClientSideProjectUtilities.isProject(siteRootDir)) {
            return Bundle.ExistingClientSideProject_error_siteRoot_nbproject();
        }
        return null;
    }

    private String validateProjectName() {
        String projectName = this.getProjectName();
        if (projectName.isEmpty()) {
            return Bundle.ExistingClientSideProject_error_name_empty();
        }
        return null;
    }

    private String validateProjectDirectory() {
        String projectDirectory = this.getProjectDirectory();
        if (projectDirectory.isEmpty()) {
            return Bundle.ExistingClientSideProject_error_projectDirectory_empty();
        }
        File projDir = FileUtil.normalizeFile((File)new File(projectDirectory).getAbsoluteFile());
        if (ClientSideProjectUtilities.isProject(projDir)) {
            return Bundle.ExistingClientSideProject_error_projectDirectory_alreadyProject();
        }
        File siteRoot = FileUtil.normalizeFile((File)new File(this.getSiteRoot()).getAbsoluteFile());
        if (projDir.isDirectory()) {
            if (projDir.equals(siteRoot)) {
                return null;
            }
        } else {
            File existingParent;
            if (!ValidationUtilities.isValidFilename(projDir)) {
                return Bundle.ExistingClientSideProject_error_projectDirectory_invalid();
            }
            for (existingParent = projDir; existingParent != null && !existingParent.exists(); existingParent = existingParent.getParentFile()) {
            }
            if (existingParent == null || !existingParent.canWrite()) {
                return Bundle.ExistingClientSideProject_error_projectDirectory_notWritable();
            }
        }
        return null;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void updateProjectName() {
        this.projectNameTextField.setText(new File(this.getSiteRoot()).getName());
    }

    void updateProjectDirectory() {
        assert (EventQueue.isDispatchThread());
        String projectDirectory = this.getProjectDirectory();
        if (!this.lastSiteRoot.isEmpty() && projectDirectory.equals(this.lastSiteRoot)) {
            return;
        }
        this.projectDirectoryTextField.setText(this.getSiteRoot());
    }

    void updateProjectDirectoryName() {
        String projectDirectory = this.getProjectDirectory();
        if (projectDirectory.equals(this.getSiteRoot())) {
            return;
        }
        if (!this.lastProjectName.isEmpty() && !projectDirectory.equals(this.lastProjectName) && projectDirectory.endsWith(this.lastProjectName)) {
            String newProjDir = projectDirectory.substring(0, projectDirectory.length() - this.lastProjectName.length()) + this.getProjectName();
            this.projectDirectoryTextField.setText(newProjDir);
        }
    }

    void detectClientSideProject(String siteRoot) {
        ClientSideProjectDetector detector = new ClientSideProjectDetector(new File(siteRoot));
        if (detector.detected()) {
            this.projectNameTextField.setText(detector.getName());
            this.projectDirectoryTextField.setText(detector.getProjectDirPath());
            this.configDir = detector.getConfigDirPath();
            this.testDir = detector.getTestDirPath();
        } else {
            this.resetDetectedValues();
        }
    }

    void resetDetectedValues() {
        this.configDir = null;
        this.testDir = null;
    }

    private void initComponents() {
        this.siteRootLabel = new JLabel();
        this.siteRootTextField = new JTextField();
        this.siteRootBrowseButton = new JButton();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectDirectoryLabel = new JLabel();
        this.projectDirectoryTextField = new JTextField();
        this.projectDirectoryBrowseButton = new JButton();
        this.siteRootLabel.setLabelFor(this.siteRootTextField);
        Mnemonics.setLocalizedText((JLabel)this.siteRootLabel, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.siteRootLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.siteRootBrowseButton, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.siteRootBrowseButton.text"));
        this.siteRootBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExistingClientSideProject.this.siteRootBrowseButtonActionPerformed(evt);
            }
        });
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.projectNameLabel.text"));
        this.projectDirectoryLabel.setLabelFor(this.projectDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectDirectoryLabel, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.projectDirectoryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectDirectoryBrowseButton, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.projectDirectoryBrowseButton.text"));
        this.projectDirectoryBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExistingClientSideProject.this.projectDirectoryBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectDirectoryLabel).addComponent(this.siteRootLabel).addComponent(this.projectNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteRootTextField).addComponent(this.projectDirectoryTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteRootBrowseButton, GroupLayout.Alignment.TRAILING).addComponent(this.projectDirectoryBrowseButton, GroupLayout.Alignment.TRAILING))).addComponent(this.projectNameTextField))));
        layout.linkSize(0, this.projectDirectoryBrowseButton, this.siteRootBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.siteRootLabel).addComponent(this.siteRootTextField, -2, -1, -2).addComponent(this.siteRootBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameTextField, -2, -1, -2).addComponent(this.projectNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectDirectoryLabel).addComponent(this.projectDirectoryTextField, -2, -1, -2).addComponent(this.projectDirectoryBrowseButton))));
    }

    private void siteRootBrowseButtonActionPerformed(ActionEvent evt) {
        File siteRoot = this.browseFile(".siteRoot", Bundle.ExistingClientSideProject_siteRoot_dialog_title(), this.getSiteRoot());
        if (siteRoot != null) {
            this.siteRootTextField.setText(FileUtil.normalizeFile((File)siteRoot).getAbsolutePath());
        }
    }

    private void projectDirectoryBrowseButtonActionPerformed(ActionEvent evt) {
        File projectDirectory = this.browseFile(".projectDirectory", Bundle.ExistingClientSideProject_projectDirectory_dialog_title(), this.getProjectDirectory());
        if (projectDirectory != null) {
            File result = FileUtil.normalizeFile((File)projectDirectory);
            File[] children = result.listFiles();
            if (children != null && children.length > 0) {
                result = new File(result, this.getProjectName());
            }
            this.projectDirectoryTextField.setText(result.getAbsolutePath());
        }
    }

    private File browseFile(String dirKey, String title, String currentDirectory) {
        File currDir;
        File workDir = null;
        if (currentDirectory != null && !currentDirectory.isEmpty() && (currDir = new File(currentDirectory)).isDirectory()) {
            workDir = currDir;
        }
        FileChooserBuilder builder = new FileChooserBuilder(NewClientSideProject.class.getName() + dirKey).setTitle(title).setDirectoriesOnly(true);
        if (workDir != null) {
            builder.setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true);
        }
        return builder.showOpenDialog();
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private final Runnable task;

        public DefaultDocumentListener() {
            this(null);
        }

        public DefaultDocumentListener(Runnable task) {
            this.task = task;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            assert (EventQueue.isDispatchThread());
            if (this.task != null) {
                this.task.run();
            }
            if (ExistingClientSideProject.this.fireChanges) {
                ExistingClientSideProject.this.fireChange();
            }
        }
    }
}

