/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.sites.SiteZip;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.ui.wizard.Bundle;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.CheckableNode;
import org.openide.explorer.view.OutlineView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CreateSiteTemplate
extends JPanel
implements ExplorerManager.Provider,
DocumentListener {
    private FileObject root;
    private OutlineView tree;
    private ExplorerManager manager;
    private WizardPanel wp;
    private JButton browseButton;
    private JTextField fileTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField nameTextField;
    private JPanel placeholder;

    public CreateSiteTemplate(FileObject root, FileObject externalSiteRoot, WizardPanel wp) {
        this.root = root;
        this.manager = new ExplorerManager();
        this.wp = wp;
        try {
            if (externalSiteRoot != null) {
                ExternalSiteRootNode externalSiteRootNode = new ExternalSiteRootNode(DataObject.find((FileObject)externalSiteRoot).getNodeDelegate(), externalSiteRoot.isFolder());
                this.manager.setRootContext((Node)new OurFilteredNode(DataObject.find((FileObject)root).getNodeDelegate(), externalSiteRootNode));
            } else {
                this.manager.setRootContext((Node)new OurFilteredNode(DataObject.find((FileObject)root).getNodeDelegate(), root.isFolder()));
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.initComponents();
        this.tree = new OutlineView();
        this.tree.setTreeSortable(false);
        this.placeholder.setLayout(new BorderLayout());
        this.placeholder.add((Component)this.tree, "Center");
        this.nameTextField.getDocument().addDocumentListener(this);
        this.fileTextField.getDocument().addDocumentListener(this);
        this.fileTextField.setText(new File(System.getProperty("user.home")).getAbsolutePath());
    }

    @Override
    public String getName() {
        return Bundle.CreateSiteTemplate_Label();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.placeholder = new JPanel();
        this.jLabel2 = new JLabel();
        this.fileTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.nameTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel1.setText(NbBundle.getMessage(CreateSiteTemplate.class, (String)"CreateSiteTemplate.jLabel1.text"));
        GroupLayout placeholderLayout = new GroupLayout(this.placeholder);
        this.placeholder.setLayout(placeholderLayout);
        placeholderLayout.setHorizontalGroup(placeholderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 393, Short.MAX_VALUE));
        placeholderLayout.setVerticalGroup(placeholderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 185, Short.MAX_VALUE));
        this.jLabel2.setText(NbBundle.getMessage(CreateSiteTemplate.class, (String)"CreateSiteTemplate.jLabel2.text"));
        this.fileTextField.setText(NbBundle.getMessage(CreateSiteTemplate.class, (String)"CreateSiteTemplate.fileTextField.text"));
        this.jLabel3.setText(NbBundle.getMessage(CreateSiteTemplate.class, (String)"CreateSiteTemplate.jLabel3.text"));
        this.nameTextField.setText(NbBundle.getMessage(CreateSiteTemplate.class, (String)"CreateSiteTemplate.nameTextField.text"));
        this.browseButton.setText(NbBundle.getMessage(CreateSiteTemplate.class, (String)"CreateSiteTemplate.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateSiteTemplate.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileTextField).addComponent(this.nameTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 177, Short.MAX_VALUE)).addComponent(this.placeholder, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.fileTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.placeholder, -1, -1, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.CreateSiteTemplate_FileChooser());
        chooser.setMultiSelectionEnabled(false);
        chooser.setApproveButtonText(Bundle.CreateSiteTemplate_FileChooserButton());
        chooser.setFileSelectionMode(1);
        if (chooser.showDialog(this, null) == 0) {
            File f = chooser.getSelectedFile();
            if (f.isFile()) {
                f = f.getParentFile();
            }
            this.fileTextField.setText(f.getAbsolutePath());
        }
    }

    private String getErrorMessage() {
        String tplName = this.getTemplateName().trim();
        if (tplName.length() == 0) {
            return Bundle.CreateSiteTemplate_Error1();
        }
        if (tplName.indexOf(46) != -1 && !tplName.endsWith(".zip")) {
            return Bundle.CreateSiteTemplate_Error1_extension();
        }
        if (this.getTemplateFolder().trim().length() == 0) {
            return Bundle.CreateSiteTemplate_Error2();
        }
        if (!new File(this.getTemplateFolder()).exists()) {
            return Bundle.CreateSiteTemplate_Error3();
        }
        return "";
    }

    public String getTemplateName() {
        return this.nameTextField.getText();
    }

    public String getTemplateFolder() {
        return this.fileTextField.getText();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.wp.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.wp.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.wp.fireChange();
    }

    public static void showWizard(ClientSideProject p) {
        WizardDescriptor wd = new WizardDescriptor((WizardDescriptor.Iterator)new WizardIterator(p));
        wd.setTitleFormat(new MessageFormat("{0}"));
        wd.setTitle(Bundle.CreateSiteTemplate_WizardTitle());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)wd);
    }

    private static boolean isValidChild(Node n) {
        FileObject fo = (FileObject)n.getLookup().lookup(FileObject.class);
        if (fo == null) {
            return false;
        }
        if ("nbproject".equals(fo.getName())) {
            return false;
        }
        return VisibilityQuery.getDefault().isVisible(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static void createZipFile(File templateFile, ClientSideProject project, Node rootNode) throws IOException {
        if (!templateFile.exists()) {
            templateFile.createNewFile();
        }
        ZipOutputStream str = new ZipOutputStream(new FileOutputStream(templateFile));
        try {
            CreateSiteTemplate.writeProjectMetadata(str, project);
            CreateSiteTemplate.writeChildren(str, project.getProjectDirectory(), project.getSiteRootFolder(), rootNode.getChildren());
        }
        finally {
            str.close();
        }
        SiteZip.registerTemplate(templateFile);
    }

    private static void writeProjectMetadata(ZipOutputStream str, ClientSideProject project) throws IOException {
        ZipEntry ze = new ZipEntry("netbeans-project.properties");
        str.putNextEntry(ze);
        EditableProperties ep = new EditableProperties(false);
        ClientSideProjectProperties projectProperties = new ClientSideProjectProperties(project);
        String siteRoot = CreateSiteTemplate.isSiteRootExternal(project.getProjectDirectory(), project.getSiteRootFolder()) ? "public_html" : projectProperties.getSiteRootFolder();
        ep.setProperty("site.root.folder", siteRoot);
        ep.setProperty("test.folder", projectProperties.getTestFolder());
        ep.setProperty("config.folder", projectProperties.getConfigFolder());
        ep.store((OutputStream)str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeChildren(ZipOutputStream str, FileObject projectDirectory, FileObject siteRoot, Children children) throws IOException {
        for (Node node : children.getNodes(true)) {
            FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
            InputStream is = null;
            if (!fo.isFolder()) {
                is = fo.getInputStream();
            }
            try {
                Checkable ch = (Checkable)node.getLookup().lookup(Checkable.class);
                if (!Boolean.TRUE.equals(ch.isSelected())) continue;
                String relPath = CreateSiteTemplate.getRelativePath(projectDirectory, siteRoot, fo);
                if (fo.isFolder()) {
                    relPath = relPath + "/";
                }
                ZipEntry ze = new ZipEntry(relPath);
                str.putNextEntry(ze);
                if (is != null) {
                    FileUtil.copy((InputStream)fo.getInputStream(), (OutputStream)str);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            if (node.isLeaf()) continue;
            CreateSiteTemplate.writeChildren(str, projectDirectory, siteRoot, node.getChildren());
        }
    }

    private static boolean isSiteRootExternal(FileObject projectDirectory, FileObject siteRootFolder) {
        return !projectDirectory.equals(siteRootFolder) && !FileUtil.isParentOf((FileObject)projectDirectory, (FileObject)siteRootFolder);
    }

    private static String getRelativePath(FileObject projectDirectory, FileObject siteRoot, FileObject fo) {
        String relativePath = FileUtil.getRelativePath((FileObject)projectDirectory, (FileObject)fo);
        if (relativePath != null) {
            return relativePath;
        }
        if (fo.equals(siteRoot)) {
            return "public_html";
        }
        relativePath = FileUtil.getRelativePath((FileObject)siteRoot, (FileObject)fo);
        assert (relativePath != null) : "File '" + fo + "' not underneath site root '" + siteRoot + "'";
        assert (!relativePath.isEmpty()) : "Some relative path expected for '" + fo + "' and site root '" + siteRoot + "'";
        return "public_html/" + relativePath;
    }

    private static class Checkable
    implements CheckableNode {
        private static boolean internalUpdate = false;
        private Boolean checked = Boolean.TRUE;
        private OurFilteredNode node;
        private JComponent comp;

        private Checkable() {
        }

        public boolean isCheckable() {
            return true;
        }

        public boolean isCheckEnabled() {
            return true;
        }

        public Boolean isSelected() {
            return this.checked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelected(Boolean selected) {
            this.checked = selected;
            if (internalUpdate) {
                return;
            }
            try {
                internalUpdate = true;
                if (this.checked != null) {
                    Checkable.propagateChanges(this.node, this.checked);
                }
            }
            finally {
                internalUpdate = false;
            }
        }

        private static void propagateChanges(OurFilteredNode node, boolean checked) {
            if (checked) {
                Checkable.tick(node.getChildren(), true);
                OurFilteredNode n = node;
                while (n.getParentNode() != null) {
                    n = (OurFilteredNode)n.getParentNode();
                    ((Checkable)n.getLookup().lookup(Checkable.class)).setSelected(Boolean.TRUE);
                    n.refresh();
                }
            } else {
                Checkable.tick(node.getChildren(), false);
            }
        }

        private static void tick(Children ch, boolean tick) {
            if (ch == null) {
                return;
            }
            for (Node n : ch.getNodes(true)) {
                ((Checkable)n.getLookup().lookup(Checkable.class)).setSelected(tick ? Boolean.TRUE : Boolean.FALSE);
                ((OurFilteredNode)n).refresh();
                Checkable.tick(n.getChildren(), tick);
            }
        }

        private void setOwner(OurFilteredNode aThis) {
            this.node = aThis;
        }

        public void setComponent(JComponent comp) {
            this.comp = comp;
        }
    }

    private class ExternalSiteRootNode
    extends OurFilteredNode {
        public ExternalSiteRootNode(Node original, boolean hasChildren) {
            super(original, hasChildren);
        }

        public String getDisplayName() {
            return "public_html";
        }

        public String getShortDescription() {
            return this.getDisplayName();
        }
    }

    private class FilteredChildren
    extends FilterNode.Children {
        public FilteredChildren(Node owner) {
            super(owner);
        }

        protected Node copyNode(Node node) {
            FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
            assert (fo != null);
            return new OurFilteredNode(node, fo.isFolder());
        }

        protected Node[] createNodes(Node key) {
            if (!CreateSiteTemplate.isValidChild(key)) {
                return new Node[0];
            }
            return super.createNodes(key);
        }
    }

    private class ProjectChildren
    extends Children.Keys<Node> {
        private Node projectNode;
        private Node externalSiteRoot;

        public ProjectChildren(Node projectNode, Node externalSiteRoot) {
            this.projectNode = projectNode;
            this.externalSiteRoot = externalSiteRoot;
        }

        protected void addNotify() {
            super.addNotify();
            ArrayList<Node> res = new ArrayList<Node>();
            res.add(this.externalSiteRoot);
            res.addAll(Arrays.asList(this.projectNode.getChildren().getNodes(true)));
            this.setKeys(res);
        }

        protected Node[] createNodes(Node key) {
            if (!CreateSiteTemplate.isValidChild(key)) {
                return new Node[0];
            }
            FileObject fo = (FileObject)key.getLookup().lookup(FileObject.class);
            assert (fo != null);
            return new Node[]{new OurFilteredNode(key, fo.isFolder())};
        }
    }

    private class OurFilteredNode
    extends FilterNode {
        public OurFilteredNode(Node projectNode, ExternalSiteRootNode externalSiteRoot) {
            super(projectNode, (Children)new ProjectChildren(projectNode, (Node)externalSiteRoot), Lookups.fixed((Object[])new Object[]{new Checkable(), projectNode.getLookup().lookup(FileObject.class)}));
            Checkable ch = (Checkable)this.getLookup().lookup(Checkable.class);
            ch.setOwner(this);
            ch.setComponent((JComponent)CreateSiteTemplate.this.tree);
        }

        public OurFilteredNode(Node original, boolean hasChildren) {
            super(original, (Children)(hasChildren ? new FilteredChildren(original) : FilterNode.Children.LEAF), Lookups.fixed((Object[])new Object[]{new Checkable(), original.getLookup().lookup(FileObject.class)}));
            Checkable ch = (Checkable)this.getLookup().lookup(Checkable.class);
            ch.setOwner(this);
            ch.setComponent((JComponent)CreateSiteTemplate.this.tree);
        }

        public void refresh() {
            this.fireIconChange();
        }
    }

    private static class WizardIterator
    implements WizardDescriptor.BackgroundInstantiatingIterator<WizardDescriptor> {
        private final WizardPanel panel;
        private final ClientSideProject p;
        private final ChangeSupport sup = new ChangeSupport((Object)this);

        public WizardIterator(ClientSideProject p) {
            this.p = p;
            this.panel = new WizardPanel(p);
            this.panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    WizardIterator.this.sup.fireChange();
                }
            });
        }

        public Set<FileObject> instantiate() throws IOException {
            File f;
            assert (!EventQueue.isDispatchThread());
            String name = this.panel.comp.getTemplateName();
            if (!name.endsWith(".zip")) {
                name = name + ".zip";
            }
            if ((f = new File(this.panel.comp.getTemplateFolder(), name)).exists() && DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.CreateSiteTemplate_Error4(f.getAbsolutePath()))) != NotifyDescriptor.YES_OPTION) {
                return null;
            }
            CreateSiteTemplate.createZipFile(f, this.p, this.panel.comp.manager.getRootContext());
            StatusDisplayer.getDefault().setStatusText(Bundle.CreateSiteTemplate_info_templateCreated(name));
            ClientSideProjectUtilities.logUsage(CreateSiteTemplate.class, "USG_PROJECT_HTML5_SAVE_AS_TEMPLATE", null);
            return null;
        }

        public void initialize(WizardDescriptor wizard) {
        }

        public void uninitialize(WizardDescriptor wizard) {
        }

        public WizardDescriptor.Panel<WizardDescriptor> current() {
            return this.panel;
        }

        public String name() {
            return Bundle.CreateSiteTemplate_Name();
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public void nextPanel() {
        }

        public void previousPanel() {
        }

        public void addChangeListener(ChangeListener l) {
            this.sup.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.sup.removeChangeListener(l);
        }
    }

    private static class WizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    WizardDescriptor.FinishablePanel<WizardDescriptor> {
        private final CreateSiteTemplate comp;
        private final ChangeSupport sup = new ChangeSupport((Object)this);
        private WizardDescriptor wd;

        public WizardPanel(ClientSideProject p) {
            FileObject siteRoot = p.getSiteRootFolder();
            this.comp = new CreateSiteTemplate(p.getProjectDirectory(), siteRoot != null && !FileUtil.isParentOf((FileObject)p.getProjectDirectory(), (FileObject)siteRoot) ? siteRoot : null, this);
            this.comp.putClientProperty("WizardPanel_contentSelectedIndex", 0);
            this.comp.putClientProperty("WizardPanel_contentData", new String[]{Bundle.CreateSiteTemplate_Title()});
            this.comp.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            this.comp.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            this.comp.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }

        public Component getComponent() {
            return this.comp;
        }

        public HelpCtx getHelp() {
            return new HelpCtx("org.netbeans.modules.web.clientproject.ui.wizard.CreateSiteTemplate");
        }

        public boolean isValid() {
            String error = this.comp.getErrorMessage();
            this.setErrorMessage(error);
            return error.length() == 0;
        }

        public void setErrorMessage(String message) {
            if (this.wd != null) {
                this.wd.putProperty("WizardPanel_errorMessage", (Object)message);
            }
        }

        public void addChangeListener(ChangeListener l) {
            this.sup.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.sup.removeChangeListener(l);
        }

        void fireChange() {
            this.sup.fireChange();
        }

        public boolean isFinishPanel() {
            return true;
        }

        public void readSettings(WizardDescriptor settings) {
            this.wd = settings;
        }

        public void storeSettings(WizardDescriptor settings) {
        }
    }
}

