/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.spi.ClientProjectExtender;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.ui.wizard.Bundle;
import org.netbeans.modules.web.clientproject.ui.wizard.ExistingClientSideProjectPanel;
import org.netbeans.modules.web.clientproject.ui.wizard.JavaScriptLibrarySelectionPanel;
import org.netbeans.modules.web.clientproject.ui.wizard.NewClientSideProjectPanel;
import org.netbeans.modules.web.clientproject.ui.wizard.SiteTemplateWizardPanel;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.clientproject.util.FileUtilities;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class ClientSideProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(ClientSideProjectWizardIterator.class.getName());
    private final Wizard wizard;
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private WizardDescriptor.Panel<WizardDescriptor>[] extenderPanels;
    private Collection<? extends ClientProjectExtender> extenders;
    private WizardDescriptor wizardDescriptor;

    private ClientSideProjectWizardIterator(Wizard wizard) {
        assert (wizard != null);
        this.wizard = wizard;
    }

    public static ClientSideProjectWizardIterator newProject() {
        return new ClientSideProjectWizardIterator(new NewProjectWizard());
    }

    public static ClientSideProjectWizardIterator existingProject() {
        return new ClientSideProjectWizardIterator(new ExistingProjectWizard());
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(Bundle.ClientSideProjectWizardIterator_progress_creatingProject());
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        File projectDirectory = FileUtil.normalizeFile((File)((File)this.wizardDescriptor.getProperty("PROJECT_DIRECTORY")));
        String name = (String)this.wizardDescriptor.getProperty("NAME");
        if (!projectDirectory.isDirectory() && !projectDirectory.mkdirs()) {
            throw new IOException("Cannot create project directory");
        }
        FileObject dir = FileUtil.toFileObject((File)projectDirectory);
        AntProjectHelper projectHelper = ClientSideProjectUtilities.setupProject(dir, name);
        files.add(dir);
        ClientSideProject project = (ClientSideProject)FileOwnerQuery.getOwner((FileObject)projectHelper.getProjectDirectory());
        FileObject siteRoot = this.wizard.instantiate(files, handle, this.wizardDescriptor, project);
        if (siteRoot != null) {
            FileObject indexFile = siteRoot.getFileObject("index", "html");
            if (indexFile != null) {
                files.add(indexFile);
            }
        } else {
            ClientSideProjectWizardIterator.errorOccured(Bundle.ClientSideProjectWizardIterator_error_noSiteRoot());
        }
        File parent = projectDirectory.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        handle.finish();
        SiteTemplateImplementation siteTemplate = (SiteTemplateImplementation)this.wizardDescriptor.getProperty("SITE_TEMPLATE");
        String libraryNames = (String)this.wizardDescriptor.getProperty("LIBRARY_NAMES");
        boolean newProjWizard = this.wizard instanceof NewProjectWizard;
        Object[] objectArray = new Object[4];
        objectArray[0] = newProjWizard ? "NEW" : "EXISTING";
        objectArray[1] = siteTemplate != null ? siteTemplate.getId() : "NONE";
        Object object = objectArray[2] = libraryNames == null ? "" : libraryNames;
        objectArray[3] = !newProjWizard && siteRoot != null ? (FileUtil.isParentOf((FileObject)dir, (FileObject)siteRoot) ? "YES" : "NO") : "";
        ClientSideProjectUtilities.logUsage(ClientSideProjectWizardIterator.class, "USG_PROJECT_HTML5_CREATE", objectArray);
        return files;
    }

    public Set<FileObject> instantiate() throws IOException {
        throw new UnsupportedOperationException("never implemented - use progress one");
    }

    public void initialize(WizardDescriptor wiz) {
        JComponent jc;
        int i;
        this.wizardDescriptor = wiz;
        this.index = 0;
        this.extenders = Lookup.getDefault().lookupAll(ClientProjectExtender.class);
        this.panels = this.wizard.createPanels();
        ArrayList<String> steps = new ArrayList<String>();
        steps.addAll(Arrays.asList(this.wizard.createSteps()));
        ArrayList<WizardDescriptor.Panel> extenderPanelsCol = new ArrayList<WizardDescriptor.Panel>();
        for (ClientProjectExtender clientProjectExtender : this.extenders) {
            for (WizardDescriptor.Panel panel : clientProjectExtender.createWizardPanels()) {
                extenderPanelsCol.add(panel);
                steps.add(panel.getComponent().getName());
            }
        }
        this.extenderPanels = extenderPanelsCol.toArray(new WizardDescriptor.Panel[0]);
        for (i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            assert (steps.get(i) != null) : "Missing name for step: " + i;
            if (!(component instanceof JComponent)) continue;
            jc = (JComponent)component;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps.toArray(new String[0]));
        }
        while (i < this.extenderPanels.length + this.panels.length) {
            Component component = this.extenderPanels[i - this.panels.length].getComponent();
            assert (steps.get(i) != null) : "Missing name for step: " + i;
            if (component instanceof JComponent) {
                jc = (JComponent)component;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps.toArray());
            }
            ++i;
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wizardDescriptor.putProperty("PROJECT_DIRECTORY", null);
        this.wizardDescriptor.putProperty("NAME", null);
        this.wizard.uninitialize(this.wizardDescriptor);
        this.panels = null;
        this.extenders = null;
        this.extenderPanels = null;
    }

    public String name() {
        return Bundle.ClientSideProjectWizardIterator_name(this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length + this.extenderPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        this.setTitle();
        if (this.index >= this.panels.length) {
            return this.extenderPanels[this.index - this.panels.length];
        }
        return this.panels[this.index];
    }

    private void setTitle() {
        if (this.wizardDescriptor != null) {
            String title = null;
            if (this.wizard instanceof NewProjectWizard) {
                title = Bundle.ClientSideProjectWizardIterator_newProject_displayName();
            } else if (this.wizard instanceof ExistingProjectWizard) {
                title = Bundle.ClientSideProjectWizardIterator_existingProject_displayName();
            } else assert (false) : "Unknown project wizard type: " + this.wizard.getClass().getName();
            if (title != null) {
                this.wizardDescriptor.putProperty("NewProjectWizard_Title", (Object)title);
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    static void errorOccured(String message) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    public static final class ExistingProjectWizard
    implements Wizard {
        public static final String SITE_ROOT = "SITE_ROOT";
        public static final String CONFIG_ROOT = "CONFIG_ROOT";
        public static final String TEST_ROOT = "TEST_ROOT";

        @Override
        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new ExistingClientSideProjectPanel()};
            return panels;
        }

        @Override
        public String[] createSteps() {
            return new String[]{Bundle.ExistingProjectWizard_step_createProject()};
        }

        @Override
        public FileObject instantiate(Set<FileObject> files, ProgressHandle handle, WizardDescriptor wizardDescriptor, ClientSideProject project) throws IOException {
            String configFolder;
            String testFolder;
            File siteRoot;
            File projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
            if (projectDir.equals(siteRoot = (File)wizardDescriptor.getProperty(SITE_ROOT))) {
                testFolder = null;
                configFolder = null;
            } else {
                testFolder = this.getExistingDir(wizardDescriptor, TEST_ROOT, "test");
                configFolder = this.getExistingDir(wizardDescriptor, CONFIG_ROOT, "config");
            }
            ClientSideProjectUtilities.initializeProject(project, siteRoot.getAbsolutePath(), testFolder, configFolder);
            return FileUtil.toFileObject((File)siteRoot);
        }

        @Override
        public void uninitialize(WizardDescriptor wizardDescriptor) {
            wizardDescriptor.putProperty(SITE_ROOT, null);
            wizardDescriptor.putProperty(CONFIG_ROOT, null);
            wizardDescriptor.putProperty(TEST_ROOT, null);
        }

        private String getExistingDir(WizardDescriptor wizardDescriptor, String property, String defaultDir) throws IOException {
            File dir = (File)wizardDescriptor.getProperty(property);
            if (dir != null) {
                return dir.getAbsolutePath();
            }
            return defaultDir;
        }
    }

    public static final class NewProjectWizard
    implements Wizard {
        public static final String SITE_TEMPLATE = "SITE_TEMPLATE";
        public static final String LIBRARIES_FOLDER = "LIBRARIES_FOLDER";
        public static final String LIBRARIES_PATH = "LIBRARIES_PATH";
        public static final String LIBRARY_NAMES = "LIBRARY_NAMES";

        @Override
        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new NewClientSideProjectPanel(), new SiteTemplateWizardPanel(), new JavaScriptLibrarySelectionPanel()};
            return panels;
        }

        @Override
        public String[] createSteps() {
            return new String[]{Bundle.NewProjectWizard_step_createProject(), Bundle.NewProjectWizard_step_chooseSite(), Bundle.NewProjectWizard_step_selectJsLibrary()};
        }

        @Override
        public FileObject instantiate(Set<FileObject> files, ProgressHandle handle, WizardDescriptor wizardDescriptor, ClientSideProject project) throws IOException {
            File[] htmlFiles;
            AntProjectHelper projectHelper = project.getProjectHelper();
            SiteTemplateImplementation siteTemplate = (SiteTemplateImplementation)wizardDescriptor.getProperty(SITE_TEMPLATE);
            SiteTemplateImplementation.ProjectProperties projectProperties = new SiteTemplateImplementation.ProjectProperties().setSiteRootFolder("public_html").setTestFolder("test").setConfigFolder("config");
            if (siteTemplate != null) {
                siteTemplate.configure(projectProperties);
                this.initProject(project, projectProperties);
                this.applySiteTemplate(projectHelper.getProjectDirectory(), projectProperties, siteTemplate, handle);
            } else {
                this.initProject(project, projectProperties);
            }
            FileObject siteRootDir = project.getSiteRootFolder();
            if (siteRootDir == null) {
                return null;
            }
            FileObject jsLibs = (FileObject)wizardDescriptor.getProperty(LIBRARIES_FOLDER);
            if (jsLibs != null) {
                FileUtilities.moveContent(jsLibs, siteRootDir);
            }
            if ((htmlFiles = FileUtil.toFile((FileObject)siteRootDir).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().toLowerCase().endsWith("html");
                }
            })) != null && htmlFiles.length == 0) {
                this.createIndexFile(siteRootDir);
            }
            for (ClientProjectExtender extender : Lookup.getDefault().lookupAll(ClientProjectExtender.class)) {
                extender.apply(project.getProjectDirectory(), siteRootDir, (String)wizardDescriptor.getProperty(LIBRARIES_PATH));
            }
            return siteRootDir;
        }

        @Override
        public void uninitialize(WizardDescriptor wizardDescriptor) {
            FileObject jsLibs = (FileObject)wizardDescriptor.getProperty(LIBRARIES_FOLDER);
            if (jsLibs != null && jsLibs.isValid()) {
                try {
                    jsLibs.delete();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
            wizardDescriptor.putProperty(SITE_TEMPLATE, null);
            wizardDescriptor.putProperty(LIBRARIES_FOLDER, null);
        }

        private void initProject(ClientSideProject project, SiteTemplateImplementation.ProjectProperties properties) throws IOException {
            ClientSideProjectUtilities.initializeProject(project, properties.getSiteRootFolder(), properties.getTestFolder(), properties.getConfigFolder());
        }

        private void applySiteTemplate(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, SiteTemplateImplementation siteTemplate, ProgressHandle handle) {
            assert (!EventQueue.isDispatchThread());
            String templateName = siteTemplate.getName();
            try {
                siteTemplate.apply(projectDir, projectProperties, handle);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
                ClientSideProjectWizardIterator.errorOccured(Bundle.ClientSideProjectWizardIterator_error_applyingSiteTemplate(templateName));
            }
        }

        private void createIndexFile(FileObject siteRoot) throws IOException {
            FileObject indexTemplate = FileUtil.getConfigFile((String)"Templates/Other/html.html");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)siteRoot);
            DataObject dataIndex = DataObject.find((FileObject)indexTemplate);
            dataIndex.createFromTemplate(dataFolder, "index");
        }
    }

    public static interface Wizard {
        public static final String PROJECT_DIRECTORY = "PROJECT_DIRECTORY";
        public static final String NAME = "NAME";

        public WizardDescriptor.Panel<WizardDescriptor>[] createPanels();

        public String[] createSteps();

        public FileObject instantiate(Set<FileObject> var1, ProgressHandle var2, WizardDescriptor var3, ClientSideProject var4) throws IOException;

        public void uninitialize(WizardDescriptor var1);
    }
}

