/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.validation.ProjectFoldersValidator;
import org.netbeans.modules.web.clientproject.validation.ValidationResult;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SourcesPanel
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = -49835154831321L;
    private final ProjectCustomizer.Category category;
    private final ClientSideProjectProperties uiProperties;
    private final ClientSideProject project;
    private JButton configBrowseButton;
    private JLabel configLabel;
    private JTextField configTextField;
    private JButton jBrowseSiteRootButton;
    private JButton jBrowseTestButton;
    private JComboBox jEncodingComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField jProjectFolderTextField;
    private JTextField jSiteRootFolderTextField;
    private JTextField jTestFolderTextField;

    public SourcesPanel(ProjectCustomizer.Category category, ClientSideProjectProperties uiProperties) {
        assert (category != null);
        assert (uiProperties != null);
        this.category = category;
        this.uiProperties = uiProperties;
        this.project = uiProperties.getProject();
        this.initComponents();
        this.init();
        this.initListeners();
        this.validateData();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.web.clientproject.ui.customizer.SourcesPanel");
    }

    private void init() {
        this.jProjectFolderTextField.setText(FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
        this.jSiteRootFolderTextField.setText(this.getSiteRootPath());
        this.jTestFolderTextField.setText(this.uiProperties.getTestFolder());
        this.configTextField.setText(this.uiProperties.getConfigFolder());
        this.jEncodingComboBox.setModel(ProjectCustomizer.encodingModel((String)this.uiProperties.getEncoding()));
        this.jEncodingComboBox.setRenderer(ProjectCustomizer.encodingRenderer());
    }

    private String getSiteRootPath() {
        FileObject siteRootFO;
        String siteRootPath = null;
        File siteRoot = this.uiProperties.getResolvedSiteRootFolder();
        if (siteRoot.exists() && (siteRootFO = FileUtil.toFileObject((File)siteRoot)) != null) {
            siteRootPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)siteRootFO);
        }
        if (siteRootPath == null) {
            siteRootPath = this.uiProperties.getSiteRootFolder();
        }
        return siteRootPath;
    }

    private void initListeners() {
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.jSiteRootFolderTextField.getDocument().addDocumentListener(documentListener);
        this.jTestFolderTextField.getDocument().addDocumentListener(documentListener);
        this.configTextField.getDocument().addDocumentListener(documentListener);
        this.jEncodingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourcesPanel.this.validateAndStore();
            }
        });
    }

    void validateAndStore() {
        this.validateData();
        this.storeData();
    }

    private void validateData() {
        ValidationResult result = new ProjectFoldersValidator().validate(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), this.getSiteRootFolder(), this.getTestFolder(), this.getConfigFolder()).getResult();
        if (result.hasErrors()) {
            this.category.setErrorMessage(result.getErrors().get(0).getMessage());
            this.category.setValid(false);
            return;
        }
        if (result.hasWarnings()) {
            this.category.setErrorMessage(result.getWarnings().get(0).getMessage());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(" ");
        this.category.setValid(true);
    }

    private void storeData() {
        File siteRootFolder = this.getSiteRootFolder();
        this.uiProperties.setSiteRootFolder(siteRootFolder.getAbsolutePath());
        File testFolder = this.getTestFolder();
        this.uiProperties.setTestFolder(testFolder != null ? testFolder.getAbsolutePath() : "");
        File configFolder = this.getConfigFolder();
        this.uiProperties.setConfigFolder(configFolder != null ? configFolder.getAbsolutePath() : "");
        this.uiProperties.setEncoding(this.getEncoding().name());
    }

    private File getSiteRootFolder() {
        File resolved = this.resolveFile(this.jSiteRootFolderTextField.getText());
        if (resolved != null) {
            return resolved;
        }
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    private File getTestFolder() {
        return this.resolveFile(this.jTestFolderTextField.getText());
    }

    private File getConfigFolder() {
        return this.resolveFile(this.configTextField.getText());
    }

    private Charset getEncoding() {
        return (Charset)this.jEncodingComboBox.getSelectedItem();
    }

    private File resolveFile(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return FileUtil.normalizeFile((File)this.project.getProjectHelper().resolveFile(path));
    }

    private String browseFolder(String title, File currentPath) {
        File folder;
        File workDir = null;
        if (currentPath != null) {
            workDir = currentPath.getParentFile();
        }
        if (workDir == null || !workDir.exists()) {
            workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        if ((folder = new FileChooserBuilder(SourcesPanel.class).setTitle(title).setDirectoriesOnly(true).setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true).setFileHiding(true).showOpenDialog()) == null) {
            return null;
        }
        String filePath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)FileUtil.toFileObject((File)folder));
        if (filePath == null) {
            filePath = folder.getAbsolutePath();
        }
        return filePath;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jProjectFolderTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSiteRootFolderTextField = new JTextField();
        this.jBrowseSiteRootButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jTestFolderTextField = new JTextField();
        this.jBrowseTestButton = new JButton();
        this.configLabel = new JLabel();
        this.configTextField = new JTextField();
        this.configBrowseButton = new JButton();
        this.jLabel4 = new JLabel();
        this.jEncodingComboBox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.jLabel1.text"));
        this.jProjectFolderTextField.setEditable(false);
        this.jProjectFolderTextField.setText(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.jProjectFolderTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.jLabel2.text"));
        this.jSiteRootFolderTextField.setText(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.jSiteRootFolderTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jBrowseSiteRootButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.jBrowseSiteRootButton.text"));
        this.jBrowseSiteRootButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.jBrowseSiteRootButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.jLabel3.text"));
        this.jTestFolderTextField.setText(NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.jTestFolderTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jBrowseTestButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.jBrowseTestButton.text"));
        this.jBrowseTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.jBrowseTestButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.configLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configBrowseButton, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.configBrowseButton.text"));
        this.configBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourcesPanel.this.configBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SourcesPanel.class, (String)"SourcesPanel.jLabel4.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.configLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProjectFolderTextField).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jEncodingComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jTestFolderTextField, GroupLayout.Alignment.TRAILING).addComponent(this.jSiteRootFolderTextField, GroupLayout.Alignment.TRAILING).addComponent(this.configTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configBrowseButton).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jBrowseSiteRootButton, GroupLayout.Alignment.TRAILING).addComponent(this.jBrowseTestButton, GroupLayout.Alignment.TRAILING)))))));
        layout.linkSize(0, this.configBrowseButton, this.jBrowseSiteRootButton, this.jBrowseTestButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jProjectFolderTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jSiteRootFolderTextField, -2, -1, -2).addComponent(this.jBrowseSiteRootButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTestFolderTextField, -2, -1, -2).addComponent(this.jBrowseTestButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configLabel).addComponent(this.configTextField, -2, -1, -2).addComponent(this.configBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jEncodingComboBox, -2, -1, -2))));
    }

    private void jBrowseSiteRootButtonActionPerformed(ActionEvent evt) {
        String filePath = this.browseFolder(Bundle.SourcesPanel_browse_siteRootFolder(), this.getSiteRootFolder());
        if (filePath != null) {
            this.jSiteRootFolderTextField.setText(filePath);
        }
    }

    private void jBrowseTestButtonActionPerformed(ActionEvent evt) {
        String filePath = this.browseFolder(Bundle.SourcesPanel_browse_testFolder(), this.getTestFolder());
        if (filePath != null) {
            this.jTestFolderTextField.setText(filePath);
        }
    }

    private void configBrowseButtonActionPerformed(ActionEvent evt) {
        String filePath = this.browseFolder(Bundle.SourcesPanel_browse_configFolder(), this.getConfigFolder());
        if (filePath != null) {
            this.configTextField.setText(filePath);
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            SourcesPanel.this.validateAndStore();
        }
    }
}

