/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.web.clientproject.ClientSideConfigurationProvider;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectConfigurationImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.netbeans.modules.web.clientproject.ui.BrowseFolders;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.clientproject.validation.ProjectFoldersValidator;
import org.netbeans.modules.web.clientproject.validation.RunProjectValidator;
import org.netbeans.modules.web.clientproject.validation.ValidationResult;
import org.netbeans.modules.web.common.api.WebServer;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RunPanel
extends JPanel
implements DocumentListener,
ItemListener,
HelpCtx.Provider {
    private static final long serialVersionUID = 98712411454L;
    private final ClientSideProject project;
    private final ComboBoxModel webServerModel;
    private final ProjectCustomizer.Category category;
    private final ClientSideProjectProperties uiProperties;
    private JButton jBrowseButton;
    private JComboBox jConfigurationComboBox;
    private JPanel jConfigurationPlaceholder;
    private JTextField jFileToRunTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jProjectURLDescriptionLabel;
    private JLabel jProjectURLLabel;
    private JTextField jProjectURLTextField;
    private JComboBox jServerComboBox;
    private JLabel jWebRootExampleLabel;
    private JLabel jWebRootLabel;
    private JTextField jWebRootTextField;

    public RunPanel(ProjectCustomizer.Category category, ClientSideProjectProperties uiProperties) {
        assert (category != null);
        assert (uiProperties != null);
        this.category = category;
        this.uiProperties = uiProperties;
        this.project = uiProperties.getProject();
        this.webServerModel = new DefaultComboBoxModel<ClientSideProjectProperties.ProjectServer>(ClientSideProjectProperties.ProjectServer.values());
        this.initComponents();
        this.init();
        this.initListeners();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.web.clientproject.ui.customizer.RunPanel");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        File siteRoot = this.getSiteRoot();
        ValidationResult result = new ProjectFoldersValidator().validateSiteRootFolder(siteRoot).getResult();
        boolean siteRootValid = !result.hasErrors();
        String info = siteRootValid ? NbBundle.getMessage(RunPanel.class, (String)"URL_DESCRIPTION", (Object)siteRoot.getAbsolutePath()) : " ";
        this.jProjectURLDescriptionLabel.setText(info);
        this.jFileToRunTextField.setEnabled(siteRootValid);
        this.jBrowseButton.setEnabled(siteRootValid);
        this.validateData();
    }

    private void init() {
        ClientSideConfigurationProvider configProvider = this.project.getProjectConfigurations();
        this.jConfigurationComboBox.setRenderer(new ConfigRenderer(this.jConfigurationComboBox.getRenderer()));
        this.jConfigurationComboBox.setModel(new DefaultComboBoxModel<Object>(configProvider.getConfigurations().toArray()));
        this.jConfigurationComboBox.setSelectedItem(this.uiProperties.getActiveConfiguration());
        this.updateConfigurationCustomizer();
        this.jFileToRunTextField.setText(this.uiProperties.getStartFile());
        this.jServerComboBox.setModel(this.webServerModel);
        this.jServerComboBox.setRenderer(new ServerRenderer(this.jServerComboBox.getRenderer()));
        this.jServerComboBox.setSelectedItem((Object)this.uiProperties.getProjectServer());
        this.jProjectURLTextField.setText(this.uiProperties.getProjectUrl());
        this.jWebRootTextField.setText(this.uiProperties.getWebRoot());
        this.updateWebRootEnablement();
    }

    private void initListeners() {
        this.jConfigurationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunPanel.this.validateAndStore();
            }
        });
        this.jFileToRunTextField.getDocument().addDocumentListener(this);
        this.jServerComboBox.addItemListener(this);
        this.jProjectURLTextField.getDocument().addDocumentListener(this);
        this.jWebRootTextField.getDocument().addDocumentListener(this);
    }

    void validateAndStore() {
        this.validateData();
        this.storeData();
    }

    private void validateData() {
        ValidationResult result;
        RunProjectValidator validator = new RunProjectValidator().validateStartFile(this.getSiteRoot(), this.getResolvedStartFile());
        if (this.jProjectURLTextField.isVisible()) {
            validator.validateProjectUrl(this.getProjectUrl());
        }
        if ((result = validator.getResult()).hasErrors()) {
            this.category.setErrorMessage(result.getErrors().get(0).getMessage());
            this.category.setValid(false);
            return;
        }
        if (result.hasWarnings()) {
            this.category.setErrorMessage(result.getWarnings().get(0).getMessage());
            this.category.setValid(true);
            return;
        }
        this.category.setErrorMessage(" ");
        this.category.setValid(true);
    }

    private void storeData() {
        this.uiProperties.setActiveConfiguration(this.getActiveConfiguration());
        this.uiProperties.setStartFile(this.getStartFile());
        this.uiProperties.setProjectServer(this.getProjectServer());
        this.uiProperties.setProjectUrl(this.getProjectUrl());
        this.uiProperties.setWebRoot(this.getWebRoot());
    }

    private void updateConfigurationCustomizer() {
        ProjectConfigurationCustomizer customizerPanel;
        this.jConfigurationPlaceholder.removeAll();
        ClientProjectConfigurationImplementation selectedConfiguration = this.getActiveConfiguration();
        if (selectedConfiguration != null && (customizerPanel = selectedConfiguration.getProjectConfigurationCustomizer()) != null) {
            this.jConfigurationPlaceholder.add((Component)customizerPanel.createPanel(), "Center");
        }
        this.validate();
        this.repaint();
    }

    private ClientProjectConfigurationImplementation getActiveConfiguration() {
        return (ClientProjectConfigurationImplementation)this.jConfigurationComboBox.getSelectedItem();
    }

    private File getSiteRoot() {
        return this.uiProperties.getResolvedSiteRootFolder();
    }

    private String getStartFile() {
        return this.jFileToRunTextField.getText();
    }

    @CheckForNull
    private File getResolvedStartFile() {
        String startFile = this.getStartFile();
        if (startFile == null) {
            return null;
        }
        File directFile = new File(startFile = ClientSideProjectUtilities.splitPathAndFragment(startFile)[0]);
        if (directFile.isAbsolute()) {
            return directFile;
        }
        FileObject siteRoot = FileUtil.toFileObject((File)this.getSiteRoot());
        if (siteRoot == null) {
            return null;
        }
        FileObject fo = siteRoot.getFileObject(startFile);
        if (fo == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)fo);
    }

    private ClientSideProjectProperties.ProjectServer getProjectServer() {
        return (ClientSideProjectProperties.ProjectServer)((Object)this.jServerComboBox.getSelectedItem());
    }

    private String getProjectUrl() {
        return this.jProjectURLTextField.getText();
    }

    private String getWebRoot() {
        return this.jWebRootTextField.getText();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jFileToRunTextField = new JTextField();
        this.jBrowseButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jServerComboBox = new JComboBox();
        this.jWebRootLabel = new JLabel();
        this.jWebRootTextField = new JTextField();
        this.jWebRootExampleLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.jConfigurationComboBox = new JComboBox();
        this.jProjectURLLabel = new JLabel();
        this.jProjectURLTextField = new JTextField();
        this.jConfigurationPlaceholder = new JPanel();
        this.jProjectURLDescriptionLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jLabel1.text"));
        this.jFileToRunTextField.setText(NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jFileToRunTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jBrowseButton, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jBrowseButton.text"));
        this.jBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunPanel.this.jBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jWebRootLabel, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jWebRootLabel.text"));
        this.jWebRootTextField.setText(NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jWebRootTextField.text"));
        this.jWebRootExampleLabel.setFont(this.jWebRootExampleLabel.getFont().deriveFont((float)this.jWebRootExampleLabel.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.jWebRootExampleLabel, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jWebRootExampleLabel.text"));
        this.jWebRootExampleLabel.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jLabel3.text"));
        this.jConfigurationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunPanel.this.jConfigurationComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jProjectURLLabel, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jProjectURLLabel.text"));
        this.jProjectURLTextField.setText(NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jProjectURLTextField.text"));
        this.jConfigurationPlaceholder.setLayout(new BorderLayout());
        this.jProjectURLDescriptionLabel.setFont(this.jProjectURLDescriptionLabel.getFont().deriveFont((float)this.jProjectURLDescriptionLabel.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.jProjectURLDescriptionLabel, (String)NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jProjectURLDescriptionLabel.text"));
        this.jProjectURLDescriptionLabel.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jWebRootLabel).addComponent(this.jProjectURLLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jWebRootExampleLabel, -1, 290, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jFileToRunTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBrowseButton)).addComponent(this.jConfigurationComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jServerComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jProjectURLTextField).addComponent(this.jWebRootTextField).addComponent(this.jConfigurationPlaceholder, -1, -1, Short.MAX_VALUE).addComponent(this.jProjectURLDescriptionLabel))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jConfigurationComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jConfigurationPlaceholder, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jFileToRunTextField, -2, -1, -2).addComponent(this.jBrowseButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jServerComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jProjectURLLabel).addComponent(this.jProjectURLTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProjectURLDescriptionLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jWebRootLabel).addComponent(this.jWebRootTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jWebRootExampleLabel, -2, -1, -2).addGap(0, 2, Short.MAX_VALUE)));
    }

    private void jBrowseButtonActionPerformed(ActionEvent evt) {
        FileObject siteRootFolder = FileUtil.toFileObject((File)this.getSiteRoot());
        assert (siteRootFolder != null);
        FileObject selectedFile = BrowseFolders.showDialog(new FileObject[]{siteRootFolder}, DataObject.class, this.getStartFile());
        if (selectedFile != null) {
            this.jFileToRunTextField.setText(FileUtil.getRelativePath((FileObject)siteRootFolder, (FileObject)selectedFile));
        }
    }

    private void jConfigurationComboBoxActionPerformed(ActionEvent evt) {
        this.updateConfigurationCustomizer();
    }

    private void updateWebRooExample() {
        if (!this.jWebRootTextField.isVisible()) {
            return;
        }
        if (!this.jWebRootTextField.isEnabled()) {
            this.jWebRootExampleLabel.setText(" ");
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(WebServer.getWebserver().getPort());
        String ctx = this.jWebRootTextField.getText();
        if (ctx.trim().length() == 0) {
            s.append("/");
        } else {
            if (!ctx.startsWith("/")) {
                s.append("/");
            }
            s.append(ctx);
        }
        this.jWebRootExampleLabel.setText(NbBundle.getMessage(RunPanel.class, (String)"RunPanel.jWebRootExampleLabel.text", (Object)s.toString()));
    }

    private boolean isEmbeddedServer() {
        return this.jServerComboBox.getSelectedItem() == ClientSideProjectProperties.ProjectServer.INTERNAL;
    }

    private void updateWebRootEnablement() {
        this.jWebRootTextField.setVisible(this.isEmbeddedServer());
        this.jWebRootLabel.setVisible(this.isEmbeddedServer());
        this.jWebRootExampleLabel.setVisible(this.isEmbeddedServer());
        this.jProjectURLLabel.setVisible(!this.isEmbeddedServer());
        this.jProjectURLTextField.setVisible(!this.isEmbeddedServer());
        this.jProjectURLDescriptionLabel.setVisible(!this.isEmbeddedServer());
        this.updateWebRooExample();
        this.validateAndStore();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateWebRooExample();
        this.validateAndStore();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateWebRooExample();
        this.validateAndStore();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateWebRooExample();
        this.validateAndStore();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateWebRootEnablement();
    }

    private static final class ServerRenderer
    implements ListCellRenderer {
        private final ListCellRenderer original;

        public ServerRenderer(ListCellRenderer original) {
            this.original = original;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            value = ((ClientSideProjectProperties.ProjectServer)((Object)value)).getTitle();
            return this.original.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static final class ConfigRenderer
    implements ListCellRenderer {
        private final ListCellRenderer original;

        public ConfigRenderer(ListCellRenderer original) {
            this.original = original;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ProjectConfiguration) {
                value = ((ProjectConfiguration)value).getDisplayName();
            }
            return this.original.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

