/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.web.clientproject.ui.JavaScriptLibrarySelection;
import org.netbeans.modules.web.clientproject.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.ui.customizer.ClientSideProjectProperties;
import org.netbeans.modules.web.clientproject.validation.ProjectFoldersValidator;
import org.netbeans.modules.web.clientproject.validation.ValidationResult;
import org.netbeans.modules.web.common.api.Pair;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public final class JavaScriptFilesPanel
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 8973245611032L;
    static final String JS_MIME_TYPE = "text/javascript";
    private final ProjectCustomizer.Category category;
    final ClientSideProjectProperties uiProperties;
    private final JavaScriptLibrarySelection javaScriptLibrarySelection;
    private JPanel placeholderPanel;

    JavaScriptFilesPanel(ProjectCustomizer.Category category, ClientSideProjectProperties uiProperties) {
        assert (EventQueue.isDispatchThread());
        assert (category != null);
        assert (uiProperties != null);
        this.category = category;
        this.uiProperties = uiProperties;
        this.javaScriptLibrarySelection = new JavaScriptLibrarySelection(new LibraryValidator(uiProperties));
        this.initComponents();
        this.init();
    }

    private void init() {
        this.javaScriptLibrarySelection.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JavaScriptFilesPanel.this.validateAndStore();
            }
        });
        this.placeholderPanel.add((Component)this.javaScriptLibrarySelection, "Center");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setJsFiles();
        this.validateData();
    }

    private void setJsFiles() {
        assert (EventQueue.isDispatchThread());
        File siteRootFolder = this.uiProperties.getResolvedSiteRootFolder();
        ValidationResult result = new ProjectFoldersValidator().validateSiteRootFolder(siteRootFolder).getResult();
        Collection<Object> jsFiles = result.hasErrors() ? Collections.emptyList() : this.findProjectJsFiles(FileUtil.toFileObject((File)siteRootFolder));
        this.javaScriptLibrarySelection.updateDefaultLibraries(jsFiles);
    }

    void validateAndStore() {
        if (this.validateData()) {
            this.storeData();
        }
    }

    boolean validateData() {
        assert (EventQueue.isDispatchThread());
        String errorMessage = this.javaScriptLibrarySelection.getErrorMessage();
        if (errorMessage != null) {
            this.category.setErrorMessage(errorMessage);
            this.category.setValid(false);
            return false;
        }
        String warningMessage = this.javaScriptLibrarySelection.getWarningMessage();
        if (warningMessage != null) {
            this.category.setErrorMessage(warningMessage);
            this.category.setValid(true);
            return true;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
        return true;
    }

    private void storeData() {
        assert (EventQueue.isDispatchThread());
        this.uiProperties.setJsLibFolder(this.javaScriptLibrarySelection.getLibrariesFolder());
        this.uiProperties.setNewJsLibraries(this.javaScriptLibrarySelection.getSelectedLibraries());
    }

    private Collection<String> findProjectJsFiles(final FileObject siteRoot) {
        final SortedSet<String> jsFiles = Collections.synchronizedSortedSet(new TreeSet());
        ProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                Enumeration children = siteRoot.getChildren(true);
                while (children.hasMoreElements()) {
                    FileObject child = (FileObject)children.nextElement();
                    if (!JavaScriptFilesPanel.JS_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)child, (String[])new String[]{JavaScriptFilesPanel.JS_MIME_TYPE}))) continue;
                    jsFiles.add(FileUtil.getRelativePath((FileObject)siteRoot, (FileObject)child));
                }
            }
        }, (String)Bundle.JavaScriptFilesPanel_progress_detectingJsFiles());
        return jsFiles;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.web.clientproject.ui.customizer.JavaScriptFilesPanel");
    }

    private void initComponents() {
        this.placeholderPanel = new JPanel();
        this.placeholderPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.placeholderPanel, -1, 199, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.placeholderPanel, -1, 161, Short.MAX_VALUE));
    }

    private static final class LibraryValidator
    implements JavaScriptLibrarySelection.JavaScriptLibrariesValidator {
        private final ClientSideProjectProperties uiProperties;

        private LibraryValidator(ClientSideProjectProperties uiProperties) {
            assert (uiProperties != null);
            this.uiProperties = uiProperties;
        }

        @Override
        public Pair<Set<JavaScriptLibrarySelection.SelectedLibrary>, String> validate(String librariesFolder, Set<JavaScriptLibrarySelection.SelectedLibrary> newLibraries) {
            if (newLibraries.isEmpty()) {
                return VALID_RESULT;
            }
            FileObject libsFolder = this.getLibsFolder(librariesFolder);
            if (libsFolder == null) {
                return VALID_RESULT;
            }
            HashSet<JavaScriptLibrarySelection.SelectedLibrary> existing = new HashSet<JavaScriptLibrarySelection.SelectedLibrary>();
            for (JavaScriptLibrarySelection.SelectedLibrary selectedLibrary : newLibraries) {
                for (String filePath : selectedLibrary.getFilePaths()) {
                    if (libsFolder.getFileObject(filePath) == null) continue;
                    existing.add(selectedLibrary);
                }
            }
            if (!existing.isEmpty()) {
                return Pair.of(existing, (Object)Bundle.JavaScriptFilesPanel_error_jsLibsAlreadyExist());
            }
            return VALID_RESULT;
        }

        private FileObject getLibsFolder(String librariesFolder) {
            FileObject siteRootFolder = FileUtil.toFileObject((File)this.uiProperties.getResolvedSiteRootFolder());
            if (siteRootFolder == null) {
                return null;
            }
            return siteRootFolder.getFileObject(librariesFolder);
        }
    }
}

