/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.customizer;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.web.clientproject.ClientSideConfigurationProvider;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectConfigurationImplementation;
import org.netbeans.modules.web.clientproject.ui.JavaScriptLibrarySelection;
import org.netbeans.modules.web.clientproject.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class ClientSideProjectProperties {
    private static final Logger LOGGER = Logger.getLogger(ClientSideProjectProperties.class.getName());
    final ClientSideProject project;
    private final List<JavaScriptLibrarySelection.SelectedLibrary> newJsLibraries = new CopyOnWriteArrayList<JavaScriptLibrarySelection.SelectedLibrary>();
    private volatile String siteRootFolder = null;
    private volatile String testFolder = null;
    private volatile String configFolder = null;
    private volatile String jsLibFolder = null;
    private volatile String encoding = null;
    private volatile String startFile = null;
    private volatile String webRoot = null;
    private volatile String projectUrl = null;
    private volatile ProjectServer projectServer = null;
    private volatile ClientProjectConfigurationImplementation activeConfiguration = null;

    public ClientSideProjectProperties(ClientSideProject project) {
        this.project = project;
    }

    public void save(final Map<String, String> projectProperties, final Map<String, String> privateProperties) {
        assert (!EventQueue.isDispatchThread());
        assert (!projectProperties.isEmpty() || !privateProperties.isEmpty()) : "Neither project nor private properties to be saved";
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    AntProjectHelper helper = ClientSideProjectProperties.this.project.getProjectHelper();
                    this.mergeProperties(helper, "nbproject/project.properties", projectProperties);
                    this.mergeProperties(helper, "nbproject/private/private.properties", privateProperties);
                    ProjectManager.getDefault().saveProject((Project)ClientSideProjectProperties.this.project);
                    return null;
                }

                private void mergeProperties(AntProjectHelper helper, String path, Map<String, String> properties) {
                    if (properties.isEmpty()) {
                        return;
                    }
                    EditableProperties currentProperties = helper.getProperties(path);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        currentProperties.put(entry.getKey(), entry.getValue());
                    }
                    helper.putProperties(path, currentProperties);
                }
            });
        }
        catch (MutexException e) {
            LOGGER.log(Level.WARNING, null, e.getException());
        }
    }

    public void save() {
        assert (!EventQueue.isDispatchThread());
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    ClientSideProjectProperties.this.saveProperties();
                    ClientSideProjectProperties.this.saveConfigs();
                    ClientSideProjectProperties.this.setActiveConfig();
                    ClientSideProjectProperties.this.addNewJsLibraries();
                    ProjectManager.getDefault().saveProject((Project)ClientSideProjectProperties.this.project);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            LOGGER.log(Level.WARNING, null, e.getException());
        }
    }

    void saveProperties() {
        String siteRootFolderReference = this.createForeignFileReference(this.siteRootFolder);
        String testFolderReference = this.createForeignFileReference(this.testFolder);
        String configFolderReference = this.createForeignFileReference(this.configFolder);
        EditableProperties projectProperties = this.project.getProjectHelper().getProperties("nbproject/project.properties");
        this.putProperty(projectProperties, "site.root.folder", siteRootFolderReference);
        this.putProperty(projectProperties, "test.folder", testFolderReference);
        this.putProperty(projectProperties, "config.folder", configFolderReference);
        this.putProperty(projectProperties, "files.encoding", this.encoding);
        this.putProperty(projectProperties, "start.file", this.startFile);
        if (this.projectServer != null) {
            this.putProperty(projectProperties, "server", this.projectServer.name());
        }
        this.putProperty(projectProperties, "external.project.url", this.projectUrl);
        this.putProperty(projectProperties, "web.context.root", this.webRoot);
        this.project.getProjectHelper().putProperties("nbproject/project.properties", projectProperties);
    }

    void saveConfigs() {
        assert (ProjectManager.mutex().isWriteAccess()) : "Write mutex required";
        for (ClientProjectConfigurationImplementation config : ((ClientSideConfigurationProvider)this.project.getLookup().lookup(ClientSideConfigurationProvider.class)).getConfigurations()) {
            config.save();
        }
    }

    void setActiveConfig() throws IOException {
        if (this.activeConfiguration != null) {
            try {
                this.project.getProjectConfigurations().setActiveConfiguration(this.activeConfiguration);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewJsLibraries() throws IOException {
        if (this.jsLibFolder != null && !this.newJsLibraries.isEmpty()) {
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)Bundle.ClientSideProjectProperties_jsLibs_downloading());
            progressHandle.start();
            try {
                List<JavaScriptLibrarySelection.SelectedLibrary> failedLibs = ClientSideProjectUtilities.applyJsLibraries(this.newJsLibraries, this.jsLibFolder, this.project.getSiteRootFolder(), progressHandle);
                if (!failedLibs.isEmpty()) {
                    LOGGER.log(Level.INFO, "Failed download of JS libraries: {0}", failedLibs);
                    ClientSideProjectProperties.errorOccured(Bundle.ClientSideProjectProperties_error_jsLibs(ClientSideProjectProperties.joinStrings(this.getLibraryNames(failedLibs), "<br>")));
                }
            }
            finally {
                progressHandle.finish();
            }
        }
    }

    public ClientSideProject getProject() {
        return this.project;
    }

    public String getSiteRootFolder() {
        if (this.siteRootFolder == null) {
            this.siteRootFolder = this.getProjectProperty("site.root.folder", "");
        }
        return this.siteRootFolder;
    }

    public void setSiteRootFolder(String siteRootFolder) {
        this.siteRootFolder = siteRootFolder;
    }

    public String getTestFolder() {
        if (this.testFolder == null) {
            this.testFolder = this.getProjectProperty("test.folder", "");
        }
        return this.testFolder;
    }

    public void setTestFolder(String testFolder) {
        if (testFolder == null) {
            testFolder = "";
        }
        this.testFolder = testFolder;
    }

    public String getConfigFolder() {
        if (this.configFolder == null) {
            this.configFolder = this.getProjectProperty("config.folder", "");
        }
        return this.configFolder;
    }

    public void setConfigFolder(String configFolder) {
        if (configFolder == null) {
            configFolder = "";
        }
        this.configFolder = configFolder;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.getProjectProperty("files.encoding", ClientSideProjectUtilities.DEFAULT_PROJECT_CHARSET.name());
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getStartFile() {
        if (this.startFile == null) {
            this.startFile = this.project.getStartFile();
        }
        return this.startFile;
    }

    public void setStartFile(String startFile) {
        this.startFile = startFile;
    }

    public String getWebRoot() {
        if (this.webRoot == null) {
            this.webRoot = this.project.getWebContextRoot();
        }
        return this.webRoot;
    }

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public String getProjectUrl() {
        if (this.projectUrl == null) {
            this.projectUrl = this.getProjectProperty("external.project.url", "");
        }
        return this.projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public ProjectServer getProjectServer() {
        if (this.projectServer == null) {
            String value = this.getProjectProperty("server", ProjectServer.INTERNAL.name());
            try {
                this.projectServer = ProjectServer.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.INFO, "Unknown project server type", ex);
                this.projectServer = ProjectServer.INTERNAL;
            }
        }
        return this.projectServer;
    }

    public void setProjectServer(ProjectServer projectServer) {
        this.projectServer = projectServer;
    }

    public ClientProjectConfigurationImplementation getActiveConfiguration() {
        if (this.activeConfiguration == null) {
            this.activeConfiguration = this.project.getProjectConfigurations().getActiveConfiguration();
        }
        return this.activeConfiguration;
    }

    public void setActiveConfiguration(ClientProjectConfigurationImplementation activeConfiguration) {
        this.activeConfiguration = activeConfiguration;
    }

    public void setNewJsLibraries(List<JavaScriptLibrarySelection.SelectedLibrary> newJsLibraries) {
        assert (newJsLibraries != null);
        this.newJsLibraries.clear();
        this.newJsLibraries.addAll(newJsLibraries);
    }

    List<JavaScriptLibrarySelection.SelectedLibrary> getNewJsLibraries() {
        return this.newJsLibraries;
    }

    public static String createListOfJsLibraries(List<JavaScriptLibrarySelection.SelectedLibrary> libs) {
        StringBuilder sb = new StringBuilder();
        List<JavaScriptLibrarySelection.SelectedLibrary> selectedLibraries = libs;
        for (JavaScriptLibrarySelection.SelectedLibrary lib : selectedLibraries) {
            if (lib.isDefault()) continue;
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(lib.getLibraryVersion().getLibrary().getName());
        }
        return sb.toString();
    }

    public void setJsLibFolder(String jsLibFolder) {
        assert (jsLibFolder != null);
        this.jsLibFolder = jsLibFolder;
    }

    public File getResolvedSiteRootFolder() {
        File resolvedFile = this.resolveFile(this.getSiteRootFolder());
        if (resolvedFile != null) {
            return resolvedFile;
        }
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    @CheckForNull
    public File getResolvedStartFile() {
        return this.resolveFile(this.getSiteRootFolder() + "/" + this.getStartFile());
    }

    private static void errorOccured(String message) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    private List<String> getLibraryNames(List<JavaScriptLibrarySelection.SelectedLibrary> libraries) {
        ArrayList<String> names = new ArrayList<String>(libraries.size());
        for (JavaScriptLibrarySelection.SelectedLibrary selectedLibrary : libraries) {
            JavaScriptLibrarySelection.LibraryVersion libraryVersion = selectedLibrary.getLibraryVersion();
            Library library = libraryVersion.getLibrary();
            String name = (String)library.getProperties().get("displayname");
            names.add(name);
        }
        return names;
    }

    private String getProjectProperty(String property, String defaultValue) {
        String value = this.project.getEvaluator().getProperty(property);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private void putProperty(EditableProperties properties, String property, String value) {
        if (value != null) {
            properties.put(property, value);
        }
    }

    private String createForeignFileReference(String filePath) {
        if (filePath == null) {
            return null;
        }
        if (filePath.isEmpty()) {
            return "";
        }
        File file = this.project.getProjectHelper().resolveFile(filePath);
        return this.project.getReferenceHelper().createForeignFileReference(file, null);
    }

    @CheckForNull
    private File resolveFile(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return this.project.getProjectHelper().resolveFile(path);
    }

    private static String joinStrings(Collection<String> strings, String glue) {
        StringBuilder sb = new StringBuilder(200);
        for (String string : strings) {
            if (sb.length() > 0) {
                sb.append(glue);
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public static final class ProjectServer
    extends Enum<ProjectServer> {
        public static final /* enum */ ProjectServer INTERNAL = new ProjectServer(Bundle.ProjectServer_internal_title());
        public static final /* enum */ ProjectServer EXTERNAL = new ProjectServer(Bundle.ProjectServer_external_title());
        private final String title;
        private static final /* synthetic */ ProjectServer[] $VALUES;

        public static ProjectServer[] values() {
            return (ProjectServer[])$VALUES.clone();
        }

        public static ProjectServer valueOf(String name) {
            return Enum.valueOf(ProjectServer.class, name);
        }

        private ProjectServer(String title) {
            assert (title != null);
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        static {
            $VALUES = new ProjectServer[]{INTERNAL, EXTERNAL};
        }
    }
}

