/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.action;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.filesystems.FileObject;

public class ProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final ClientSideProject project;

    public ProjectOperations(ClientSideProject project) {
        this.project = project;
    }

    public void notifyDeleting() throws IOException {
    }

    public void notifyDeleted() throws IOException {
        this.project.getProjectHelper().notifyDeleted();
    }

    public void notifyCopying() throws IOException {
    }

    public void notifyCopied(Project original, File originalPath, String nueName) throws IOException {
        if (original == null) {
            return;
        }
        this.project.setName(nueName);
        this.project.getReferenceHelper().fixReferences(originalPath);
    }

    public void notifyMoving() throws IOException {
    }

    public void notifyMoved(Project original, File originalPath, String nueName) throws IOException {
        if (original == null) {
            this.project.getProjectHelper().notifyDeleted();
            return;
        }
        this.project.setName(nueName);
        this.project.getReferenceHelper().fixReferences(originalPath);
    }

    public List<FileObject> getMetadataFiles() {
        FileObject nbproject = this.project.getProjectDirectory().getFileObject("nbproject");
        if (nbproject != null) {
            return Collections.singletonList(nbproject);
        }
        return Collections.emptyList();
    }

    public List<FileObject> getDataFiles() {
        return Arrays.asList(ClientSideProjectUtilities.getSourceObjects(this.project));
    }
}

