/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableRowSorter;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.web.clientproject.api.WebClientLibraryManager;
import org.netbeans.modules.web.clientproject.ui.Bundle;
import org.netbeans.modules.web.clientproject.util.StringUtilities;
import org.netbeans.modules.web.common.api.Pair;
import org.netbeans.modules.web.common.api.Version;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class JavaScriptLibrarySelection
extends JPanel {
    private static final long serialVersionUID = -468734354571212312L;
    static final Logger LOGGER = Logger.getLogger(JavaScriptLibrarySelection.class.getName());
    private static final Pattern LIBRARIES_FOLDER_PATTERN = Pattern.compile("^[\\w-]+$", 2);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final JavaScriptLibrariesValidator librariesValidator;
    final List<SelectedLibrary> selectedLibraries = Collections.synchronizedList(new ArrayList());
    final Set<SelectedLibrary> failedLibraries = Collections.synchronizedSet(new HashSet());
    final Set<SelectedLibrary> invalidLibraries = new HashSet<SelectedLibrary>();
    final LibrariesTableModel librariesTableModel = new LibrariesTableModel();
    final TableRowSorter<LibrariesTableModel> librariesTableSorter = new TableRowSorter<LibrariesTableModel>(this.librariesTableModel);
    final LibrariesListModel selectedLibrariesListModel = new LibrariesListModel(this.selectedLibraries);
    private volatile String librariesFolder = null;
    private JLabel additionalInfoLabel;
    private JButton deselectSelectedButton;
    private JLabel generalInfoLabel;
    private JTextField librariesFilterTextField;
    private JLabel librariesFolderLabel;
    private JTextField librariesFolderTextField;
    private JLabel librariesLabel;
    private JScrollPane librariesScrollPane;
    private JTable librariesTable;
    private JButton selectSelectedButton;
    private JLabel selectedLabel;
    private JList selectedLibrariesList;
    private JScrollPane selectedLibrariesScrollPane;

    public JavaScriptLibrarySelection(JavaScriptLibrariesValidator librariesValidator) {
        assert (EventQueue.isDispatchThread());
        assert (librariesValidator != null);
        this.librariesValidator = librariesValidator;
        this.initComponents();
        this.initInfos();
        this.initLibraries();
        this.initLibrariesFolder();
    }

    private void initInfos() {
        this.setAdditionalInfo(null);
    }

    private void initLibraries() {
        this.initLibrariesTable();
        this.initLibrariesList();
        this.initLibrariesButtons();
    }

    private void initLibrariesTable() {
        assert (EventQueue.isDispatchThread());
        this.librariesTable.setModel(this.librariesTableModel);
        this.librariesTable.setRowSorter(this.librariesTableSorter);
        this.librariesTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                assert (EventQueue.isDispatchThread());
                Point point = e.getPoint();
                int row = JavaScriptLibrarySelection.this.librariesTable.convertRowIndexToModel(JavaScriptLibrarySelection.this.librariesTable.rowAtPoint(point));
                JavaScriptLibrarySelection.this.librariesTable.setToolTipText(this.getWrappedText(JavaScriptLibrarySelection.this.librariesTableModel.getItems().get(row).getDescription()));
            }

            private String getWrappedText(String text) {
                if (text == null || text.isEmpty()) {
                    return null;
                }
                int lineLength = 100;
                if (text.length() <= 100) {
                    return text;
                }
                StringBuilder sb = new StringBuilder(text.length() + 40);
                int currentLineLength = 100;
                for (String word : text.split(" ")) {
                    sb.append(word);
                    if (sb.length() > currentLineLength) {
                        sb.append("<br>");
                        currentLineLength += 104;
                        continue;
                    }
                    sb.append(" ");
                }
                return "<html>" + sb.toString();
            }
        });
        this.librariesFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
                JavaScriptLibrarySelection.this.filterLibrariesTable();
            }
        });
    }

    private void initLibrariesList() {
        assert (EventQueue.isDispatchThread());
        this.selectedLibrariesList.setModel(this.selectedLibrariesListModel);
        this.selectedLibrariesList.setCellRenderer(new SelectedLibraryRenderer(this.selectedLibrariesList.getCellRenderer()));
    }

    private void initLibrariesButtons() {
        assert (EventQueue.isDispatchThread());
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JavaScriptLibrarySelection.this.enableLibraryButtons();
            }
        };
        this.librariesTable.getSelectionModel().addListSelectionListener(selectionListener);
        this.selectedLibrariesList.getSelectionModel().addListSelectionListener(selectionListener);
        this.librariesTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                JavaScriptLibrarySelection.this.enableLibraryButtons();
            }
        });
        this.selectedLibrariesListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.dataChanged();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.dataChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.dataChanged();
            }

            private void dataChanged() {
                JavaScriptLibrarySelection.this.enableLibraryButtons();
                JavaScriptLibrarySelection.this.fireChangeEvent();
            }
        });
        this.selectSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaScriptLibrarySelection.this.selectSelectedLibraries();
            }
        });
        this.deselectSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaScriptLibrarySelection.this.deselectSelectedLibraries();
            }
        });
        this.enableLibraryButtons();
    }

    private void initLibrariesFolder() {
        this.librariesFolder = this.librariesFolderTextField.getText();
        this.librariesFolderTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
                JavaScriptLibrarySelection.this.librariesFolder = JavaScriptLibrarySelection.this.librariesFolderTextField.getText();
                while (JavaScriptLibrarySelection.this.librariesFolder.endsWith("/")) {
                    JavaScriptLibrarySelection.this.librariesFolder = JavaScriptLibrarySelection.this.librariesFolder.substring(0, JavaScriptLibrarySelection.this.librariesFolder.length() - 1);
                }
                JavaScriptLibrarySelection.this.fireChangeEvent();
            }
        });
    }

    public List<SelectedLibrary> getSelectedLibraries() {
        return this.selectedLibraries;
    }

    public String getLibrariesFolder() {
        return this.librariesFolder;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    public String getErrorMessage() {
        String error = this.validateLibrariesFolder();
        if (error != null) {
            return error;
        }
        error = this.validateLibraries();
        if (error != null) {
            return error;
        }
        return null;
    }

    public String getWarningMessage() {
        return null;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfoLabel.setText(additionalInfo);
        this.additionalInfoLabel.setVisible(additionalInfo != null);
        ((GroupLayout)this.getLayout()).setHonorsVisibility(this.additionalInfoLabel, additionalInfo != null);
    }

    public void lockPanel() {
        this.enablePanel(false);
    }

    public void unlockPanel() {
        this.enablePanel(true);
    }

    private void enablePanel(boolean enabled) {
        this.librariesFilterTextField.setEnabled(enabled);
        this.librariesTable.setEnabled(enabled);
        this.librariesTable.setRowSelectionAllowed(enabled);
        this.librariesTable.setColumnSelectionAllowed(enabled);
        this.selectSelectedButton.setEnabled(enabled);
        this.deselectSelectedButton.setEnabled(enabled);
        this.selectedLibrariesList.setEnabled(enabled);
        this.librariesFolderTextField.setEnabled(enabled);
    }

    void enableLibraryButtons() {
        assert (EventQueue.isDispatchThread());
        this.selectSelectedButton.setEnabled(this.librariesTable.getSelectedRows().length > 0);
        this.deselectSelectedButton.setEnabled(this.canDeselectSelected());
    }

    void filterLibrariesTable() {
        assert (EventQueue.isDispatchThread());
        final String filter = this.librariesFilterTextField.getText().toLowerCase();
        if (filter.isEmpty()) {
            this.librariesTableSorter.setRowFilter(null);
            return;
        }
        this.librariesTableSorter.setRowFilter(new RowFilter<LibrariesTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends LibrariesTableModel, ? extends Integer> entry) {
                return entry.getStringValue(0).toLowerCase().contains(filter);
            }
        });
    }

    private boolean canDeselectSelected() {
        if (this.selectedLibraries.isEmpty()) {
            return false;
        }
        for (int index : this.selectedLibrariesList.getSelectedIndices()) {
            if (index >= this.selectedLibraries.size() || this.selectedLibraries.get(index).isDefault()) continue;
            return true;
        }
        return false;
    }

    void selectSelectedLibraries() {
        assert (EventQueue.isDispatchThread());
        for (int i : this.librariesTable.getSelectedRows()) {
            this.selectLibrary(this.librariesTable.convertRowIndexToModel(i));
        }
        this.selectedLibrariesListModel.fireContentsChanged();
    }

    private void selectLibrary(int libraryIndex) {
        assert (EventQueue.isDispatchThread());
        ModelItem modelItem = this.librariesTableModel.getItems().get(libraryIndex);
        LibraryVersion libraryVersion = modelItem.getSelectedVersion();
        this.selectedLibraries.add(new SelectedLibrary(libraryVersion));
    }

    void deselectSelectedLibraries() {
        assert (EventQueue.isDispatchThread());
        int[] selectedIndices = this.selectedLibrariesList.getSelectedIndices();
        ArrayList<SelectedLibrary> selected = new ArrayList<SelectedLibrary>(selectedIndices.length);
        for (int index : selectedIndices) {
            SelectedLibrary library = this.selectedLibraries.get(index);
            if (library.isDefault()) continue;
            selected.add(library);
        }
        HashSet<SelectedLibrary> set = new HashSet<SelectedLibrary>(this.selectedLibraries);
        set.removeAll(selected);
        this.selectedLibraries.clear();
        this.selectedLibraries.addAll(set);
        this.selectedLibrariesListModel.fireContentsChanged();
    }

    private String validateLibrariesFolder() {
        for (String segment : this.librariesFolder.split("/")) {
            if (LIBRARIES_FOLDER_PATTERN.matcher(segment).matches()) continue;
            return Bundle.JavaScriptLibrarySelection_error_librariesFolder_invalid();
        }
        return null;
    }

    private String validateLibraries() {
        assert (EventQueue.isDispatchThread());
        HashSet<SelectedLibrary> newLibraries = new HashSet<SelectedLibrary>();
        for (SelectedLibrary library : this.selectedLibraries) {
            if (library.isDefault()) continue;
            newLibraries.add(library);
        }
        Pair<Set<SelectedLibrary>, String> result = this.librariesValidator.validate(this.librariesFolder, newLibraries);
        this.invalidLibraries.clear();
        this.invalidLibraries.addAll((Collection)result.getA());
        return (String)result.getB();
    }

    public void updateDefaultLibraries(Collection<String> defaultLibs) {
        Iterator<SelectedLibrary> iterator = this.selectedLibraries.iterator();
        while (iterator.hasNext()) {
            SelectedLibrary library = iterator.next();
            if (!library.isDefault()) continue;
            iterator.remove();
        }
        for (String lib : defaultLibs) {
            this.selectedLibraries.add(new SelectedLibrary(lib));
        }
        this.fireSelectedLibrariesChangeInEDT();
    }

    public void updateFailedLibraries(List<SelectedLibrary> failedLibs) {
        this.failedLibraries.clear();
        this.failedLibraries.addAll(failedLibs);
        this.fireSelectedLibrariesChangeInEDT();
    }

    private void fireSelectedLibrariesChangeInEDT() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                JavaScriptLibrarySelection.this.selectedLibrariesListModel.fireContentsChanged();
            }
        });
    }

    private void initComponents() {
        this.generalInfoLabel = new JLabel();
        this.additionalInfoLabel = new JLabel();
        this.librariesLabel = new JLabel();
        this.librariesFilterTextField = new JTextField();
        this.librariesScrollPane = new JScrollPane();
        this.librariesTable = new LibrariesTable();
        this.selectSelectedButton = new JButton();
        this.deselectSelectedButton = new JButton();
        this.selectedLabel = new JLabel();
        this.selectedLibrariesScrollPane = new JScrollPane();
        this.selectedLibrariesList = new JList();
        this.librariesFolderLabel = new JLabel();
        this.librariesFolderTextField = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.generalInfoLabel, (String)NbBundle.getMessage(JavaScriptLibrarySelection.class, (String)"JavaScriptLibrarySelection.generalInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.additionalInfoLabel, (String)"ADDITIONAL_INFO");
        this.librariesLabel.setLabelFor(this.librariesTable);
        Mnemonics.setLocalizedText((JLabel)this.librariesLabel, (String)NbBundle.getMessage(JavaScriptLibrarySelection.class, (String)"JavaScriptLibrarySelection.librariesLabel.text"));
        this.librariesScrollPane.setViewportView(this.librariesTable);
        Mnemonics.setLocalizedText((AbstractButton)this.selectSelectedButton, (String)NbBundle.getMessage(JavaScriptLibrarySelection.class, (String)"JavaScriptLibrarySelection.selectSelectedButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.deselectSelectedButton, (String)NbBundle.getMessage(JavaScriptLibrarySelection.class, (String)"JavaScriptLibrarySelection.deselectSelectedButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.selectedLabel, (String)NbBundle.getMessage(JavaScriptLibrarySelection.class, (String)"JavaScriptLibrarySelection.selectedLabel.text"));
        this.selectedLibrariesScrollPane.setViewportView(this.selectedLibrariesList);
        this.librariesFolderLabel.setLabelFor(this.librariesFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.librariesFolderLabel, (String)NbBundle.getMessage(JavaScriptLibrarySelection.class, (String)"JavaScriptLibrarySelection.librariesFolderLabel.text"));
        this.librariesFolderTextField.setText("js/libs");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.librariesFolderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.librariesFolderTextField)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.librariesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.librariesFilterTextField, -1, 164, Short.MAX_VALUE)).addComponent(this.librariesScrollPane, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectSelectedButton).addComponent(this.deselectSelectedButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedLabel).addComponent(this.selectedLibrariesScrollPane, -1, 221, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.additionalInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.generalInfoLabel, -2, 0, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(0, this.deselectSelectedButton, this.selectSelectedButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.generalInfoLabel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.additionalInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.librariesLabel).addComponent(this.selectedLabel).addComponent(this.librariesFilterTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectedLibrariesScrollPane, -1, 160, Short.MAX_VALUE).addComponent(this.librariesScrollPane, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.selectSelectedButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deselectSelectedButton).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.librariesFolderLabel).addComponent(this.librariesFolderTextField, -2, -1, -2))));
    }

    public static interface JavaScriptLibrariesValidator {
        public static final Pair<Set<SelectedLibrary>, String> VALID_RESULT = Pair.of(Collections.emptySet(), null);

        public Pair<Set<SelectedLibrary>, String> validate(String var1, Set<SelectedLibrary> var2);
    }

    public static final class SelectedLibrary {
        private final String filename;
        private final LibraryVersion libraryVersion;

        public SelectedLibrary(String filename) {
            this(filename, null);
            assert (filename != null);
        }

        public SelectedLibrary(LibraryVersion libraryVersion) {
            this(null, libraryVersion);
            assert (libraryVersion != null);
        }

        private SelectedLibrary(String filename, LibraryVersion libraryVersion) {
            this.filename = filename;
            this.libraryVersion = libraryVersion;
        }

        public List<String> getFilePaths() {
            if (this.filename != null) {
                return Collections.singletonList(this.filename);
            }
            return this.getLibraryFilePaths();
        }

        public LibraryVersion getLibraryVersion() {
            return this.libraryVersion;
        }

        public boolean isDefault() {
            return this.libraryVersion == null;
        }

        private List<String> getLibraryFilePaths() {
            return WebClientLibraryManager.getLibraryFilePaths((Library)this.libraryVersion.getLibrary(), (String)this.libraryVersion.getType());
        }

        public int hashCode() {
            int hash = 3;
            hash = 31 * hash + (this.filename != null ? this.filename.hashCode() : 0);
            hash = 31 * hash + (this.libraryVersion != null ? this.libraryVersion.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SelectedLibrary other = (SelectedLibrary)obj;
            if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
                return false;
            }
            return this.libraryVersion == other.libraryVersion || this.libraryVersion != null && this.libraryVersion.equals(other.libraryVersion);
        }

        public String toString() {
            return "SelectedLibrary{filename=" + this.filename + ", libraryVersion=" + this.libraryVersion + '}';
        }
    }

    public static final class LibraryVersion {
        private final Library library;
        private final String type;

        public LibraryVersion(Library library, String type) {
            assert (library != null);
            assert (type != null && !type.isEmpty());
            this.library = library;
            this.type = type;
        }

        public Library getLibrary() {
            return this.library;
        }

        public String getType() {
            return this.type;
        }

        public String getLibraryVersion() {
            return (String)this.library.getProperties().get("version");
        }

        public int hashCode() {
            int hash = 5;
            hash = 41 * hash + this.getLibraryVersion().hashCode();
            hash = 41 * hash + (this.type != null ? this.type.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LibraryVersion other = (LibraryVersion)obj;
            if (!(this.library == other.library || this.library != null && this.getLibraryVersion().equals(other.getLibraryVersion()))) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "LibraryVersion{library=" + this.library.getName() + ", type=" + this.type + '}';
        }
    }

    private static final class ModelItem {
        private static final Comparator<Library> LIBRARY_COMPARATOR = new Comparator<Library>(){

            @Override
            public int compare(Library o1, Library o2) {
                Version ver2;
                Version ver1 = Version.fromDottedNotationWithFallback((String)((String)o1.getProperties().get("version")));
                if (ver1.equals((Object)(ver2 = Version.fromDottedNotationWithFallback((String)((String)o2.getProperties().get("version")))))) {
                    if (!o1.getContent("documented").isEmpty()) {
                        return -1;
                    }
                    if (!o2.getContent("documented").isEmpty()) {
                        return 1;
                    }
                    if (!o1.getContent("regular").isEmpty()) {
                        return -1;
                    }
                    if (!o2.getContent("regular").isEmpty()) {
                        return 1;
                    }
                    return 0;
                }
                return ver1.isBelowOrEqual(ver2) ? 1 : -1;
            }
        };
        private final Set<LibraryVersion> versions;
        private LibraryVersion selectedVersion;

        public ModelItem(List<Library> libraries) {
            assert (EventQueue.isDispatchThread());
            Collections.sort(libraries, LIBRARY_COMPARATOR);
            this.versions = this.createVersions(libraries);
            this.selectedVersion = this.versions.iterator().next();
        }

        public String getSimpleDisplayName() {
            return (String)this.getLibrary().getProperties().get("displayname");
        }

        public String getDescription() {
            return this.getLibrary().getDescription();
        }

        public LibraryVersion[] getVersions() {
            assert (EventQueue.isDispatchThread());
            return this.versions.toArray(new LibraryVersion[this.versions.size()]);
        }

        public LibraryVersion getSelectedVersion() {
            assert (EventQueue.isDispatchThread());
            return this.selectedVersion;
        }

        public void setSelectedVersion(LibraryVersion selectedVersion) {
            assert (EventQueue.isDispatchThread());
            assert (selectedVersion != null);
            this.selectedVersion = selectedVersion;
        }

        private Set<LibraryVersion> createVersions(List<Library> libraries) {
            LinkedHashSet<LibraryVersion> libraryVersions = new LinkedHashSet<LibraryVersion>();
            for (Library library : libraries) {
                LibraryVersion libraryVersion = null;
                if (!library.getContent("documented").isEmpty()) {
                    libraryVersion = new LibraryVersion(library, "documented");
                    libraryVersions.add(libraryVersion);
                }
                if (!library.getContent("regular").isEmpty()) {
                    libraryVersion = new LibraryVersion(library, "regular");
                    libraryVersions.add(libraryVersion);
                }
                if (!library.getContent("minified").isEmpty()) {
                    libraryVersion = new LibraryVersion(library, "minified");
                    libraryVersions.add(libraryVersion);
                }
                if (libraryVersion == null) assert (false) : "Unknown library version: " + library.getName();
            }
            return libraryVersions;
        }

        private Library getLibrary() {
            assert (EventQueue.isDispatchThread());
            return this.versions.iterator().next().getLibrary();
        }
    }

    private final class SelectedLibraryRenderer
    implements ListCellRenderer {
        private final ListCellRenderer defaultRenderer;

        public SelectedLibraryRenderer(ListCellRenderer defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            assert (EventQueue.isDispatchThread());
            SelectedLibrary selectedLibrary = (SelectedLibrary)value;
            List<String> filePaths = selectedLibrary.getFilePaths();
            assert (!filePaths.isEmpty()) : "No files for library: " + selectedLibrary;
            if (selectedLibrary.isDefault()) {
                assert (filePaths.size() == 1) : "Exactly one file expected but found " + filePaths.size() + " for default library " + selectedLibrary;
                String path = filePaths.get(0);
                int slashIndex = path.lastIndexOf(47);
                label = slashIndex == -1 ? path : Bundle.JavaScriptLibrarySelection_SelectedLibraryRenderer_label_defaultLibrary(path.substring(slashIndex + 1), path.substring(0, slashIndex));
            } else {
                label = StringUtilities.implode(filePaths, ", ");
            }
            Component component = this.defaultRenderer.getListCellRendererComponent(list, label, index, isSelected, cellHasFocus);
            if (selectedLibrary.isDefault()) {
                component.setEnabled(false);
            }
            if (JavaScriptLibrarySelection.this.failedLibraries.contains(selectedLibrary) || JavaScriptLibrarySelection.this.invalidLibraries.contains(selectedLibrary)) {
                component.setForeground(UIManager.getColor("nb.errorForeground"));
            }
            return component;
        }
    }

    private static final class LibrariesListModel
    extends AbstractListModel {
        private static final long serialVersionUID = -57683546574861110L;
        private static final String DELIMITER = ", ";
        private static final Comparator<SelectedLibrary> SELECTED_LIBRARIES_COMPARATOR = new Comparator<SelectedLibrary>(){

            @Override
            public int compare(SelectedLibrary library1, SelectedLibrary library2) {
                if (library1.isDefault() && !library2.isDefault()) {
                    return 1;
                }
                if (!library1.isDefault() && library2.isDefault()) {
                    return -1;
                }
                String paths1 = StringUtilities.implode(library1.getFilePaths(), LibrariesListModel.DELIMITER);
                String paths2 = StringUtilities.implode(library2.getFilePaths(), LibrariesListModel.DELIMITER);
                return paths1.compareToIgnoreCase(paths2);
            }
        };
        private final List<SelectedLibrary> libraries;

        public LibrariesListModel(List<SelectedLibrary> libraries) {
            this.libraries = libraries;
        }

        @Override
        public int getSize() {
            return this.libraries.size();
        }

        @Override
        public SelectedLibrary getElementAt(int index) {
            return this.libraries.get(index);
        }

        public void fireContentsChanged() {
            this.sanitizeLibraries();
            this.fireContentsChanged(this, 0, this.libraries.size() - 1);
        }

        private void sanitizeLibraries() {
            TreeSet<SelectedLibrary> sortedSet = new TreeSet<SelectedLibrary>(SELECTED_LIBRARIES_COMPARATOR);
            sortedSet.addAll(this.libraries);
            this.libraries.clear();
            this.libraries.addAll(sortedSet);
        }
    }

    private static final class LibrariesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8732134781780336L;
        private final List<ModelItem> items = new ArrayList<ModelItem>();

        public LibrariesTableModel() {
            assert (EventQueue.isDispatchThread());
            HashMap<String, ArrayList<Library>> map = new HashMap<String, ArrayList<Library>>();
            for (Library lib : WebClientLibraryManager.getLibraries()) {
                if (!"javascript".equals(lib.getType())) continue;
                String name = (String)lib.getProperties().get("name");
                ArrayList<Library> libs = (ArrayList<Library>)map.get(name);
                if (libs == null) {
                    libs = new ArrayList<Library>();
                    map.put(name, libs);
                }
                libs.add(lib);
            }
            for (List libs : map.values()) {
                this.items.add(new ModelItem(libs));
            }
            Collections.sort(this.items, new Comparator<ModelItem>(){

                @Override
                public int compare(ModelItem o1, ModelItem o2) {
                    return o1.getSimpleDisplayName().toLowerCase().compareTo(o2.getSimpleDisplayName().toLowerCase());
                }
            });
        }

        @Override
        public int getRowCount() {
            assert (EventQueue.isDispatchThread());
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Bundle.JavaScriptLibrarySelection_column_library();
            }
            if (columnIndex == 1) {
                return Bundle.JavaScriptLibrarySelection_column_version();
            }
            assert (false) : "Unknown column index: " + columnIndex;
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            assert (EventQueue.isDispatchThread());
            ModelItem modelItem = this.items.get(rowIndex);
            if (columnIndex == 0) {
                return modelItem.getSimpleDisplayName();
            }
            if (columnIndex == 1) {
                return VersionsRenderer.getLabel(modelItem.getSelectedVersion());
            }
            assert (false) : "Unknown column index: " + columnIndex;
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (EventQueue.isDispatchThread());
            ModelItem modelItem = this.items.get(rowIndex);
            if (columnIndex == 1) {
                modelItem.setSelectedVersion((LibraryVersion)aValue);
                return;
            }
            assert (false) : "Unknown column index: " + columnIndex;
        }

        List<ModelItem> getItems() {
            assert (EventQueue.isDispatchThread());
            return this.items;
        }
    }

    private static final class VersionsRenderer
    implements ListCellRenderer {
        private final ListCellRenderer defaultRenderer;

        public VersionsRenderer(ListCellRenderer defaultRenderer) {
            this.defaultRenderer = defaultRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.defaultRenderer.getListCellRendererComponent(list, VersionsRenderer.getLabel((LibraryVersion)value), index, isSelected, cellHasFocus);
        }

        public static String getLabel(LibraryVersion libraryVersion) {
            String type;
            String version = libraryVersion.getLibraryVersion();
            String rawType = libraryVersion.getType();
            if ("documented".equals(rawType)) {
                type = Bundle.VersionsRenderer_type_documented();
            } else if ("minified".equals(rawType)) {
                type = Bundle.VersionsRenderer_type_minified();
            } else if ("regular".equals(rawType)) {
                type = "";
            } else {
                assert (false) : "Unknown library type: " + libraryVersion;
                type = "";
            }
            return Bundle.VersionsRenderer_label(version, type).trim();
        }
    }

    private static final class LibrariesTable
    extends JTable {
        private static final long serialVersionUID = 1578314546784244L;

        private LibrariesTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            row = this.convertRowIndexToModel(row);
            if (column != 1) {
                return super.getCellEditor(row, column);
            }
            LibrariesTableModel model = (LibrariesTableModel)this.getModel();
            JComboBox<LibraryVersion> versionsComboBox = new JComboBox<LibraryVersion>(model.getItems().get(row).getVersions());
            versionsComboBox.setRenderer(new VersionsRenderer(versionsComboBox.getRenderer()));
            return new DefaultCellEditor(versionsComboBox);
        }
    }
}

