/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.ui.Bundle;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ClientSideProjectLogicalView
implements LogicalViewProvider {
    static final Logger LOGGER = Logger.getLogger(ClientSideProjectLogicalView.class.getName());
    private final ClientSideProject project;

    public ClientSideProjectLogicalView(ClientSideProject project) {
        this.project = project;
    }

    public Node createLogicalView() {
        return new ClientSideProjectNode(this.project);
    }

    public Node findPath(Node root, Object target) {
        FileObject fo;
        Project prj = (Project)root.getLookup().lookup(Project.class);
        if (prj == null) {
            return null;
        }
        if (target instanceof FileObject) {
            fo = (FileObject)target;
        } else if (target instanceof DataObject) {
            fo = ((DataObject)target).getPrimaryFile();
        } else {
            return null;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (!prj.equals(owner)) {
            return null;
        }
        for (Node node : root.getChildren().getNodes(true)) {
            Node found;
            FileObject kid = (FileObject)node.getLookup().lookup(FileObject.class);
            if (kid == null) continue;
            if (kid == fo) {
                return node;
            }
            if (!FileUtil.isParentOf((FileObject)kid, (FileObject)fo) || (found = ClientSideProjectLogicalView.findNode(node, kid, fo)) == null || !this.hasObject(found, target)) continue;
            return found;
        }
        return null;
    }

    private static Node findNode(Node node, FileObject root, FileObject fo) {
        String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
        String[] path = relPath.split("/");
        path[path.length - 1] = fo.getName();
        Node found = ClientSideProjectLogicalView.findNode(node, path);
        if (found != null) {
            return found;
        }
        path[path.length - 1] = fo.getNameExt();
        return ClientSideProjectLogicalView.findNode(node, path);
    }

    private static Node findNode(Node start, String[] path) {
        Node found = null;
        try {
            found = NodeOp.findPath((Node)start, (String[])path);
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        return found;
    }

    private boolean hasObject(Node node, Object obj) {
        if (obj == null) {
            return false;
        }
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            return false;
        }
        if (obj instanceof DataObject) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            if (dataObject.equals(obj)) {
                return true;
            }
            return this.hasObject(node, ((DataObject)obj).getPrimaryFile());
        }
        if (obj instanceof FileObject) {
            return obj.equals(fileObject);
        }
        return false;
    }

    public static class RemoteFile {
        private URL url;
        private String name;
        private String urlAsString;

        public RemoteFile(URL url) {
            this.url = url;
            this.urlAsString = url.toExternalForm();
            int index = this.urlAsString.lastIndexOf(47);
            if (index != -1) {
                this.name = this.urlAsString.substring(index + 1);
            }
        }

        public URL getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.urlAsString;
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + (this.urlAsString != null ? this.urlAsString.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RemoteFile other = (RemoteFile)obj;
            return !(this.urlAsString == null ? other.urlAsString != null : !this.urlAsString.equals(other.urlAsString));
        }
    }

    private static class RemoteFileFilterNode
    extends FilterNode {
        private String desc;
        private Node delegate;

        public RemoteFileFilterNode(Node original, String desc) {
            super(original);
            this.desc = desc;
            this.delegate = original;
        }

        public String getShortDescription() {
            return this.desc;
        }

        public int hashCode() {
            int hash = 7;
            return hash * this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            RemoteFileFilterNode other = (RemoteFileFilterNode)((Object)obj);
            return this.delegate == other.delegate || this.delegate != null && this.delegate.equals((Object)other.delegate);
        }
    }

    private static class RemoteFilesChildren
    extends Children.Keys<RemoteFile>
    implements ChangeListener {
        final ClientSideProject project;

        public RemoteFilesChildren(ClientSideProject project) {
            this.project = project;
        }

        protected Node[] createNodes(RemoteFile key) {
            try {
                FileObject fo = RemoteFileCache.getRemoteFile((URL)key.getUrl());
                DataObject dobj = DataObject.find((FileObject)fo);
                return new Node[]{new RemoteFileFilterNode(dobj.getNodeDelegate().cloneNode(), key.getDescription())};
            }
            catch (DataObjectNotFoundException ex) {
                return new Node[0];
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new Node[0];
            }
        }

        protected void addNotify() {
            super.addNotify();
            this.project.getRemoteFiles().addChangeListener(this);
            this.updateKeys();
        }

        protected void removeNotify() {
            super.removeNotify();
            this.project.getRemoteFiles().removeChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateKeys();
        }

        private void updateKeys() {
            ArrayList<RemoteFile> keys = new ArrayList<RemoteFile>();
            for (URL u : this.project.getRemoteFiles().getRemoteFiles()) {
                keys.add(new RemoteFile(u));
            }
            Collections.sort(keys, new Comparator<RemoteFile>(){

                @Override
                public int compare(RemoteFile o1, RemoteFile o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            this.setKeys(keys);
        }
    }

    private static final class RemoteFilesNode
    extends AbstractNode {
        final ClientSideProject project;

        public RemoteFilesNode(ClientSideProject project) {
            super((Children)new RemoteFilesChildren(project));
            this.project = project;
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/web/clientproject/ui/resources/remotefiles.png");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return Bundle.LBL_RemoteFiles();
        }
    }

    private static class FolderFilterChildren
    extends FilterNode.Children {
        private final Set<File> ignoreList = new WeakSet();

        public FolderFilterChildren(Node n, List<File> ignoreList) {
            super(n);
            this.ignoreList.addAll(ignoreList);
        }

        protected Node[] createNodes(Node key) {
            FileObject fo = (FileObject)key.getLookup().lookup(FileObject.class);
            if (fo == null) {
                return super.createNodes(key);
            }
            File file = FileUtil.toFile((FileObject)fo);
            if (file == null) {
                return super.createNodes(key);
            }
            if (!VisibilityQuery.getDefault().isVisible(fo)) {
                return new Node[0];
            }
            if (this.ignoreList.contains(file)) {
                return new Node[0];
            }
            return super.createNodes(key);
        }
    }

    private static final class FolderFilterNode
    extends FilterNode {
        private BasicNodes nodeType;
        private Node iconDelegate;
        private Node delegate;
        private static final Image SOURCES_FILES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/clientproject/ui/resources/sources-badge.gif", (boolean)true);
        private static final Image TESTS_FILES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/clientproject/ui/resources/tests-badge.gif", (boolean)true);
        private static final Image CONFIGS_FILES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/web/clientproject/ui/resources/config-badge.gif", (boolean)true);

        public FolderFilterNode(BasicNodes nodeType, Node folderNode, List<File> ignoreList) {
            super(folderNode, (Children)(folderNode.isLeaf() ? FilterNode.Children.LEAF : new FolderFilterChildren(folderNode, ignoreList)));
            this.nodeType = nodeType;
            this.iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
            this.delegate = folderNode;
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add((Action)SystemAction.get(FindAction.class));
            actions.add(null);
            actions.add((Action)SystemAction.get(FileSystemAction.class));
            actions.add(null);
            actions.add((Action)SystemAction.get(PasteAction.class));
            actions.add(null);
            actions.add((Action)SystemAction.get(ToolsAction.class));
            actions.add(null);
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        public boolean canRename() {
            return false;
        }

        public Image getIcon(int type) {
            return this.computeIcon(this.nodeType, false, type);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(this.nodeType, true, type);
        }

        private Image computeIcon(BasicNodes node, boolean opened, int type) {
            Image image;
            Image badge = null;
            switch (this.nodeType) {
                case Sources: {
                    badge = SOURCES_FILES_BADGE;
                    break;
                }
                case Tests: {
                    badge = TESTS_FILES_BADGE;
                    break;
                }
                case Configuration: {
                    badge = CONFIGS_FILES_BADGE;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            Image image2 = image = opened ? this.iconDelegate.getOpenedIcon(type) : this.iconDelegate.getIcon(type);
            if (badge != null) {
                image = ImageUtilities.mergeImages((Image)image, (Image)badge, (int)7, (int)7);
            }
            return image;
        }

        public String getDisplayName() {
            switch (this.nodeType) {
                case Sources: {
                    return ResourceBundle.getBundle("org/netbeans/modules/web/clientproject/ui/Bundle").getString("SITE_ROOT");
                }
                case Tests: {
                    return ResourceBundle.getBundle("org/netbeans/modules/web/clientproject/ui/Bundle").getString("UNIT_TESTS");
                }
                case Configuration: {
                    return ResourceBundle.getBundle("org/netbeans/modules/web/clientproject/ui/Bundle").getString("CONFIGURATION_FILES");
                }
            }
            throw new AssertionError((Object)this.nodeType.name());
        }

        public int hashCode() {
            int hash = 3;
            return hash * this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            FolderFilterNode other = (FolderFilterNode)((Object)obj);
            return this.delegate == other.delegate || this.delegate != null && this.delegate.equals((Object)other.delegate);
        }
    }

    private static class ClientSideProjectChildren
    extends Children.Keys<BasicNodes> {
        private final ClientSideProject project;
        private final FileObject nbprojectFolder;
        private final Listener listener;

        public ClientSideProjectChildren(ClientSideProject p) {
            this.project = p;
            this.nbprojectFolder = p.getProjectDirectory().getFileObject("nbproject");
            assert (this.nbprojectFolder != null) : "Folder nbproject must exist for project " + this.project.getName();
            this.updateKeys();
            this.project.getRemoteFiles().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ClientSideProjectChildren.this.updateKeys();
                }
            });
            this.listener = new Listener();
            this.project.getEvaluator().addPropertyChangeListener((PropertyChangeListener)this.listener);
            this.project.getProjectDirectory().addRecursiveListener((FileChangeListener)this.listener);
        }

        private void refreshKeyInAWT(final BasicNodes type) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClientSideProjectChildren.this.refreshKey((Object)type);
                }
            });
        }

        protected Node[] createNodes(BasicNodes k) {
            switch (k) {
                case Sources: {
                    return this.createNodeForFolder(k);
                }
                case Tests: {
                    return this.createNodeForFolder(k);
                }
                case RemoteFiles: {
                    return new Node[]{new RemoteFilesNode(this.project)};
                }
                case Configuration: {
                    return this.createNodeForFolder(k);
                }
            }
            return new Node[0];
        }

        private List<File> getIgnoredFiles(BasicNodes basicNodes) {
            ArrayList<File> ignoredFiles = new ArrayList<File>();
            FileObject buildFolder = this.project.getProjectDirectory().getFileObject("build");
            switch (basicNodes) {
                case Sources: 
                case Tests: 
                case Configuration: {
                    this.addIgnoredFile(ignoredFiles, this.nbprojectFolder);
                    this.addIgnoredFile(ignoredFiles, buildFolder);
                    break;
                }
                case RemoteFiles: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown BasicNodes: " + (Object)((Object)basicNodes));
                }
            }
            return ignoredFiles;
        }

        private void addIgnoredFile(List<File> ignoredFiles, FileObject fileObject) {
            if (fileObject == null) {
                return;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file != null) {
                ignoredFiles.add(file);
            }
        }

        private boolean isNodeHidden(BasicNodes type) {
            if (type == BasicNodes.Sources) {
                return false;
            }
            FileObject root = this.getRootForNode(type);
            return root == null || !root.isValid() || root.getChildren().length == 0;
        }

        private FileObject getRootForNode(BasicNodes node) {
            switch (node) {
                case Configuration: {
                    return this.project.getConfigFolder();
                }
                case Tests: {
                    return this.project.getTestsFolder();
                }
                case Sources: {
                    return this.project.getSiteRootFolder();
                }
            }
            assert (false);
            return null;
        }

        private Node[] createNodeForFolder(BasicNodes type) {
            FileObject root = this.getRootForNode(type);
            if (root != null && root.isValid()) {
                DataFolder df = DataFolder.findFolder((FileObject)root);
                if (!this.isNodeHidden(type)) {
                    return new Node[]{new FolderFilterNode(type, df.getNodeDelegate(), this.getIgnoredFiles(type))};
                }
            }
            return new Node[0];
        }

        private void updateKeys() {
            ArrayList<BasicNodes> keys = new ArrayList<BasicNodes>();
            keys.add(BasicNodes.Sources);
            keys.add(BasicNodes.Tests);
            if (!this.project.getRemoteFiles().getRemoteFiles().isEmpty()) {
                keys.add(BasicNodes.RemoteFiles);
            }
            keys.add(BasicNodes.Configuration);
            this.setKeys(keys);
        }

        private class Listener
        extends FileChangeAdapter
        implements PropertyChangeListener {
            private volatile boolean sourcesNodeHidden;
            private volatile boolean testsNodeHidden;
            private volatile boolean configNodeHidden;

            public Listener() {
                this.sourcesNodeHidden = ClientSideProjectChildren.this.isNodeHidden(BasicNodes.Sources);
                this.testsNodeHidden = ClientSideProjectChildren.this.isNodeHidden(BasicNodes.Tests);
                this.configNodeHidden = ClientSideProjectChildren.this.isNodeHidden(BasicNodes.Configuration);
            }

            public void fileFolderCreated(FileEvent fe) {
                this.updateNodesVisibility();
            }

            public void fileDataCreated(FileEvent fe) {
                this.updateNodesVisibility();
            }

            public void fileDeleted(FileEvent fe) {
                this.updateNodesVisibility();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("site.root.folder".equals(evt.getPropertyName())) {
                    this.sourcesNodeHidden = ClientSideProjectChildren.this.isNodeHidden(BasicNodes.Sources);
                    ClientSideProjectChildren.this.refreshKeyInAWT(BasicNodes.Sources);
                } else if ("test.folder".equals(evt.getPropertyName())) {
                    this.testsNodeHidden = ClientSideProjectChildren.this.isNodeHidden(BasicNodes.Tests);
                    ClientSideProjectChildren.this.refreshKeyInAWT(BasicNodes.Tests);
                } else if ("config.folder".equals(evt.getPropertyName())) {
                    this.configNodeHidden = ClientSideProjectChildren.this.isNodeHidden(BasicNodes.Configuration);
                    ClientSideProjectChildren.this.refreshKeyInAWT(BasicNodes.Configuration);
                }
            }

            private void updateNodesVisibility() {
                boolean nodeHidden = ClientSideProjectChildren.this.isNodeHidden(BasicNodes.Sources);
                if (nodeHidden != this.sourcesNodeHidden) {
                    this.sourcesNodeHidden = nodeHidden;
                    ClientSideProjectChildren.this.refreshKeyInAWT(BasicNodes.Sources);
                }
                if ((nodeHidden = ClientSideProjectChildren.this.isNodeHidden(BasicNodes.Tests)) != this.testsNodeHidden) {
                    this.testsNodeHidden = nodeHidden;
                    ClientSideProjectChildren.this.refreshKeyInAWT(BasicNodes.Tests);
                }
                if ((nodeHidden = ClientSideProjectChildren.this.isNodeHidden(BasicNodes.Configuration)) != this.configNodeHidden) {
                    this.configNodeHidden = nodeHidden;
                    ClientSideProjectChildren.this.refreshKeyInAWT(BasicNodes.Configuration);
                }
            }
        }
    }

    private static enum BasicNodes {
        Sources,
        Tests,
        RemoteFiles,
        Configuration;

    }

    private static final class ClientSideProjectNode
    extends AbstractNode {
        final ClientSideProject project;

        public ClientSideProjectNode(ClientSideProject project) {
            super((Children)new ClientSideProjectChildren(project), ClientSideProjectNode.createLookup(project));
            this.project = project;
        }

        private static Lookup createLookup(ClientSideProject project) {
            InstanceContent instanceContent = new InstanceContent();
            instanceContent.add((Object)project);
            instanceContent.add((Object)project, (InstanceContent.Convertor)new InstanceContent.Convertor<ClientSideProject, FileObject>(){

                public FileObject convert(ClientSideProject obj) {
                    return obj.getProjectDirectory();
                }

                public Class<? extends FileObject> type(ClientSideProject obj) {
                    return FileObject.class;
                }

                public String id(ClientSideProject obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                public String displayName(ClientSideProject obj) {
                    return obj.toString();
                }
            });
            instanceContent.add((Object)project, (InstanceContent.Convertor)new InstanceContent.Convertor<ClientSideProject, DataObject>(){

                public DataObject convert(ClientSideProject obj) {
                    try {
                        FileObject fo = obj.getProjectDirectory();
                        return fo == null ? null : DataObject.find((FileObject)fo);
                    }
                    catch (DataObjectNotFoundException ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                        return null;
                    }
                }

                public Class<? extends DataObject> type(ClientSideProject obj) {
                    return DataObject.class;
                }

                public String id(ClientSideProject obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                public String displayName(ClientSideProject obj) {
                    return obj.toString();
                }
            });
            return new AbstractLookup((AbstractLookup.Content)instanceContent);
        }

        public Action[] getActions(boolean arg0) {
            return CommonProjectActions.forType((String)"org-netbeans-modules-web-clientproject");
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/web/clientproject/ui/resources/projecticon.png");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return this.project.getName();
        }

        public String getShortDescription() {
            return Bundle.ClientSideProjectNode_description(FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }
    }
}

