/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.sites;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.web.clientproject.sites.Bundle;
import org.netbeans.modules.web.clientproject.sites.SiteHelper;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.util.FileUtilities;
import org.openide.filesystems.FileObject;

public class SiteMobileBoilerplate
implements SiteTemplateImplementation {
    private static final Logger LOGGER = Logger.getLogger(SiteMobileBoilerplate.class.getName());
    private static final File LIB_FILE = new File(SiteHelper.getJsLibsDirectory(), "mobile-boilerplate-30.zip");

    public String getId() {
        return "MOBILE.BOILER";
    }

    public String getName() {
        return Bundle.SiteMobileBoilerplate_name();
    }

    public String getDescription() {
        return Bundle.SiteMobileBoilerplate_description();
    }

    public boolean isPrepared() {
        return LIB_FILE.isFile();
    }

    public void prepare() throws IOException {
        assert (!EventQueue.isDispatchThread());
        assert (!this.isPrepared());
        SiteHelper.download("https://github.com/h5bp/mobile-boilerplate/zipball/v3.0", LIB_FILE, null);
    }

    public void configure(SiteTemplateImplementation.ProjectProperties projectProperties) {
    }

    public void apply(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, ProgressHandle handle) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (!this.isPrepared()) {
            LOGGER.info("Template not correctly prepared, nothing to be applied");
            return;
        }
        SiteHelper.unzipProjectTemplate(projectDir.getFileObject(projectProperties.getSiteRootFolder()), LIB_FILE, handle, new String[0]);
    }

    public Collection<String> supportedLibraries() {
        return SiteHelper.stripRootFolder(FileUtilities.listJsFilesFromZipFile(LIB_FILE));
    }
}

